/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal.vendor;

import java.util.ArrayList;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.jpt.db.internal.vendor.AbstractVendor;
import org.eclipse.jpt.db.internal.vendor.CatalogStrategy;
import org.eclipse.jpt.db.internal.vendor.FoldingStrategy;
import org.eclipse.jpt.db.internal.vendor.NonFoldingStrategy;
import org.eclipse.jpt.db.internal.vendor.SimpleCatalogStrategy;
import org.eclipse.jpt.db.internal.vendor.UnknownCatalogStrategy;
import org.eclipse.jpt.db.internal.vendor.Vendor;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Sybase
extends AbstractVendor {
    private final String dtpVendorName;
    static final Vendor ASA = new Sybase("Sybase_ASA");
    static final Vendor ASE = new Sybase("Sybase_ASE");
    static final String DTP_VENDOR_EXTENSION_NAME = "Sybase";
    static final Vendor DTP_VENDOR_EXTENSION = new Sybase("Sybase");
    private static final String MASTER_CATALOG_NAME = "master";
    private static final String DEFAULT_SCHEMA_NAME = "dbo";
    private static final char[] EXTENDED_REGULAR_NAME_START_CHARACTERS = new char[]{'_', '@'};
    private static final char[] EXTENDED_REGULAR_NAME_PART_CHARACTERS = new char[]{'$', '\u00a5', '\u00a3', '#'};

    static Vendor asa() {
        return ASA;
    }

    static Vendor ase() {
        return ASE;
    }

    static Vendor dtpVendorExtension() {
        return DTP_VENDOR_EXTENSION;
    }

    private Sybase(String dtpVendorName) {
        this.dtpVendorName = dtpVendorName;
    }

    @Override
    public String getDTPVendorName() {
        return this.dtpVendorName;
    }

    @Override
    CatalogStrategy getCatalogStrategy() {
        if (this.getDTPVendorName().equals(DTP_VENDOR_EXTENSION_NAME)) {
            return UnknownCatalogStrategy.instance();
        }
        return SimpleCatalogStrategy.instance();
    }

    @Override
    FoldingStrategy getFoldingStrategy() {
        return NonFoldingStrategy.instance();
    }

    @Override
    void addDefaultCatalogNamesTo(Database database, String userName, ArrayList<String> names) {
        names.add(database.getName());
        names.add(MASTER_CATALOG_NAME);
    }

    @Override
    void addDefaultSchemaNamesTo(Database database, String userName, ArrayList<String> names) {
        names.add(DEFAULT_SCHEMA_NAME);
    }

    @Override
    char[] getExtendedRegularNameStartCharacters() {
        return EXTENDED_REGULAR_NAME_START_CHARACTERS;
    }

    @Override
    char[] getExtendedRegularNamePartCharacters() {
        return EXTENDED_REGULAR_NAME_PART_CHARACTERS;
    }

    @Override
    boolean identifierIsDelimited(String identifier) {
        return StringTools.stringIsBracketed((String)identifier) || super.identifierIsDelimited(identifier);
    }
}

