/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.jsdt.debug.internal.ui.Messages;

public class ScriptSelectionDialog
extends FilteredResourcesSelectionDialog {
    public static final String JS_EXTENSION_PATTERN = "*.js";

    public ScriptSelectionDialog(Shell shell, boolean multi, IContainer container) {
        super(shell, multi, container, 1);
        this.setInitialPattern(JS_EXTENSION_PATTERN);
    }

    protected String getMessage() {
        return Messages.select_javascript_file;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ScriptFilter();
    }

    class ScriptFilter
    extends FilteredResourcesSelectionDialog.ResourceFilter {
        ScriptFilter() {
            super((FilteredResourcesSelectionDialog)ScriptSelectionDialog.this);
        }

        public boolean matchItem(Object item) {
            return super.matchItem(item) && this.isJavaScriptContent((IFile)item);
        }

        boolean isJavaScriptContent(IFile file) {
            IContentType filetype = IDE.getContentType((IFile)file);
            if (filetype == null) {
                return false;
            }
            IContentType scripttype = Platform.getContentTypeManager().getContentType("org.eclipse.wst.jsdt.core.jsSource");
            return filetype.equals(scripttype);
        }
    }
}

