/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.JoiningStrategy;
import org.eclipse.jpt.core.internal.context.java.VirtualAssociationOverrideJoinColumnAnnotation;
import org.eclipse.jpt.core.internal.context.java.VirtualOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VirtualAssociationOverrideAnnotation
extends VirtualOverrideAnnotation
implements AssociationOverrideAnnotation {
    protected JoiningStrategy joiningStrategy;
    private final Vector<JoinColumnAnnotation> joinColumns;

    protected VirtualAssociationOverrideAnnotation(JavaResourcePersistentMember parent, String name, JoiningStrategy joiningStrategy) {
        super(parent, name);
        this.joiningStrategy = joiningStrategy;
        this.joinColumns = this.buildJoinColumns();
    }

    protected Vector<JoinColumnAnnotation> buildJoinColumns() {
        if (this.joiningStrategy instanceof JoinColumnJoiningStrategy) {
            Vector<JoinColumnAnnotation> result = new Vector<JoinColumnAnnotation>(((JoinColumnJoiningStrategy)this.joiningStrategy).joinColumnsSize());
            for (JoinColumn joinColumn : CollectionTools.iterable(((JoinColumnJoiningStrategy)this.joiningStrategy).joinColumns())) {
                result.add(new VirtualAssociationOverrideJoinColumnAnnotation(this, joinColumn));
            }
            return result;
        }
        return new Vector<JoinColumnAnnotation>();
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.AssociationOverride";
    }

    @Override
    protected AssociationOverrideAnnotation addAnnotation() {
        return (AssociationOverrideAnnotation)super.addAnnotation();
    }

    @Override
    public ListIterator<JoinColumnAnnotation> joinColumns() {
        return this.joinColumns.listIterator();
    }

    @Override
    public JoinColumnAnnotation joinColumnAt(int index) {
        return this.joinColumns.elementAt(index);
    }

    @Override
    public int indexOfJoinColumn(JoinColumnAnnotation joinColumn) {
        return this.joinColumns.indexOf(joinColumn);
    }

    @Override
    public int joinColumnsSize() {
        return this.joinColumns.size();
    }

    @Override
    public JoinColumnAnnotation addJoinColumn(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeJoinColumn(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveJoinColumn(int targetIndex, int sourceIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
    }
}

