/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.jsf.designtime.DTAppManagerUtil;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.IViewRootHandle;
import org.eclipse.jst.jsf.designtime.resolver.IStructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.jst.jsf.validation.internal.ValidationPreferences;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;

public final class JSFValidationContext {
    private final ValidationPreferences _prefs;
    private final boolean _isIncremental;
    private final IDTViewHandler _adapter;
    private final DiagnosticFactory _diagnosticFactory;
    private final IFile _file;
    private final IJSFViewValidator.IValidationReporter _reporter;
    private final IStructuredDocumentSymbolResolverFactory _symbolResolverFactory;
    private IViewRootHandle _viewRootHandle;

    public JSFValidationContext(boolean isIncremental, ValidationPreferences prefs, IDTViewHandler adapter, DiagnosticFactory diagnosticFactory, IFile file, IJSFViewValidator.IValidationReporter reporter, IStructuredDocumentSymbolResolverFactory symbolResolveFactory) {
        this._isIncremental = isIncremental;
        this._prefs = prefs;
        this._adapter = adapter;
        this._diagnosticFactory = diagnosticFactory;
        this._file = file;
        this._reporter = reporter;
        this._symbolResolverFactory = symbolResolveFactory;
    }

    public final boolean shouldValidateEL() {
        this._prefs.load();
        if (this._isIncremental) {
            return this._prefs.getElPrefs().isEnableIncrementalValidation();
        }
        return this._prefs.getElPrefs().isEnableBuildValidation();
    }

    public IDTViewHandler getAdapter() {
        return this._adapter;
    }

    public ValidationPreferences getPrefs() {
        return this._prefs;
    }

    public DiagnosticFactory getDiagnosticFactory() {
        return this._diagnosticFactory;
    }

    public IFile getFile() {
        return this._file;
    }

    public IJSFViewValidator.IValidationReporter getReporter() {
        return this._reporter;
    }

    public IStructuredDocumentSymbolResolverFactory getSymbolResolverFactory() {
        return this._symbolResolverFactory;
    }

    public IViewRootHandle getViewRootHandle() {
        if (this._viewRootHandle == null) {
            this._viewRootHandle = DTAppManagerUtil.getViewRootHandle((IResource)this._file);
            if (this._viewRootHandle.getCachedViewRoot() == null) {
                this._viewRootHandle.updateViewRoot();
            }
        }
        return this._viewRootHandle;
    }
}

