/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.listeners;

import org.eclipse.jpt.utility.model.event.ListAddEvent;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.ListClearEvent;
import org.eclipse.jpt.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.swt.widgets.Display;

public class SWTListChangeListenerWrapper
implements ListChangeListener {
    private final ListChangeListener listener;

    public SWTListChangeListenerWrapper(ListChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void itemsAdded(ListAddEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.itemsAdded_(event);
        } else {
            this.executeOnUIThread(this.buildItemsAddedRunnable(event));
        }
    }

    public void itemsRemoved(ListRemoveEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.itemsRemoved_(event);
        } else {
            this.executeOnUIThread(this.buildItemsRemovedRunnable(event));
        }
    }

    public void itemsMoved(ListMoveEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.itemsMoved_(event);
        } else {
            this.executeOnUIThread(this.buildItemsMovedRunnable(event));
        }
    }

    public void itemsReplaced(ListReplaceEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.itemsReplaced_(event);
        } else {
            this.executeOnUIThread(this.buildItemsReplacedRunnable(event));
        }
    }

    public void listCleared(ListClearEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.listCleared_(event);
        } else {
            this.executeOnUIThread(this.buildListClearedRunnable(event));
        }
    }

    public void listChanged(ListChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.listChanged_(event);
        } else {
            this.executeOnUIThread(this.buildListChangedRunnable(event));
        }
    }

    private Runnable buildItemsAddedRunnable(final ListAddEvent event) {
        return new Runnable(){

            public void run() {
                SWTListChangeListenerWrapper.this.itemsAdded_(event);
            }

            public String toString() {
                return "items added";
            }
        };
    }

    private Runnable buildItemsRemovedRunnable(final ListRemoveEvent event) {
        return new Runnable(){

            public void run() {
                SWTListChangeListenerWrapper.this.itemsRemoved_(event);
            }

            public String toString() {
                return "items removed";
            }
        };
    }

    private Runnable buildItemsMovedRunnable(final ListMoveEvent event) {
        return new Runnable(){

            public void run() {
                SWTListChangeListenerWrapper.this.itemsMoved_(event);
            }

            public String toString() {
                return "items moved";
            }
        };
    }

    private Runnable buildItemsReplacedRunnable(final ListReplaceEvent event) {
        return new Runnable(){

            public void run() {
                SWTListChangeListenerWrapper.this.itemsReplaced_(event);
            }

            public String toString() {
                return "items replaced";
            }
        };
    }

    private Runnable buildListClearedRunnable(final ListClearEvent event) {
        return new Runnable(){

            public void run() {
                SWTListChangeListenerWrapper.this.listCleared_(event);
            }

            public String toString() {
                return "list cleared";
            }
        };
    }

    private Runnable buildListChangedRunnable(final ListChangeEvent event) {
        return new Runnable(){

            public void run() {
                SWTListChangeListenerWrapper.this.listChanged_(event);
            }

            public String toString() {
                return "list changed";
            }
        };
    }

    private boolean isExecutingOnUIThread() {
        return Display.getCurrent() != null;
    }

    private void executeOnUIThread(Runnable r) {
        Display.getDefault().asyncExec(r);
    }

    void itemsAdded_(ListAddEvent event) {
        this.listener.itemsAdded(event);
    }

    void itemsRemoved_(ListRemoveEvent event) {
        this.listener.itemsRemoved(event);
    }

    void itemsMoved_(ListMoveEvent event) {
        this.listener.itemsMoved(event);
    }

    void itemsReplaced_(ListReplaceEvent event) {
        this.listener.itemsReplaced(event);
    }

    void listCleared_(ListClearEvent event) {
        this.listener.listCleared(event);
    }

    void listChanged_(ListChangeEvent event) {
        this.listener.listChanged(event);
    }

    public String toString() {
        return "SWT(" + this.listener.toString() + ')';
    }
}

