/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.taglibprocessing.attributevalues;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidValues;
import org.eclipse.jst.jsf.metadataprocessors.features.ValidationMessage;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.Messages;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.PathType;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class WebPathType
extends PathType
implements IMetaDataEnabledFeature,
IValidValues {
    public boolean isValidValue(String value) {
        try {
            URL url = new URL(value);
            if (url.getProtocol().equals("file")) {
                this.validateFileRelativeToWebRoot(url.getPath());
            }
        }
        catch (MalformedURLException malformedURLException) {
            if (value != null && value.length() > 1 && value.charAt(0) == '/') {
                this.validateFileRelativeToWebRoot(value);
            }
            this.validateFileRelativeToCurrentFile(value);
        }
        return this.getValidationMessages().size() == 0;
    }

    private void validateFileRelativeToWebRoot(String value) {
        IVirtualContainer webRoot = this.getWebRoot();
        if (!webRoot.exists()) {
            this.getValidationMessages().add(new ValidationMessage(Messages.WebPathType_1));
        } else {
            IVirtualFile file = webRoot.getFile((IPath)new Path(value));
            if (!file.exists()) {
                this.getValidationMessages().add(new ValidationMessage(Messages.WebPathType_2));
            }
        }
    }

    private IVirtualContainer getWebRoot() {
        IVirtualFolder webRoot = ComponentCore.createComponent((IProject)this.getProject()).getRootFolder();
        return webRoot;
    }

    private void validateFileRelativeToCurrentFile(String value) {
        IPath webContentPath = ComponentCore.createComponent((IProject)this.getProject()).getRootFolder().getUnderlyingFolder().getFullPath();
        IWorkspaceContextResolver wkspaceResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(this.getStructuredDocumentContext());
        IResource resource = wkspaceResolver.getResource();
        IPath filePath = resource.getFullPath();
        if (filePath.matchingFirstSegments(webContentPath) == webContentPath.segmentCount()) {
            filePath = filePath.removeFirstSegments(webContentPath.segmentCount());
            filePath = filePath.removeLastSegments(1);
            filePath = filePath.append(value);
            IVirtualFile file = this.getWebRoot().getFile(filePath);
            if (!file.exists()) {
                this.getValidationMessages().add(new ValidationMessage(Messages.WebPathType_2));
            }
        }
    }
}

