/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.RelationshipReference;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.jpa2.context.SimpleMetamodelField;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.jpa2.context.AttributeMapping2_0;
import org.eclipse.jpt.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.core.jpa2.context.java.JavaPersistentAttribute2_0;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaAttributeMapping<T extends Annotation>
extends AbstractJavaJpaContextNode
implements JavaAttributeMapping,
AttributeMapping2_0 {
    protected T mappingAnnotation;
    protected Vector<String> supportingAnnotationNames;

    protected AbstractJavaAttributeMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void initialize(Annotation annotation) {
        this.mappingAnnotation = annotation;
        this.initialize();
    }

    protected void initialize() {
    }

    @Override
    public void update(Annotation annotation) {
        this.mappingAnnotation = annotation;
        this.update();
    }

    protected void update() {
    }

    @Override
    public JavaPersistentAttribute getParent() {
        return (JavaPersistentAttribute)super.getParent();
    }

    @Override
    public JavaPersistentAttribute getPersistentAttribute() {
        return this.getParent();
    }

    protected JavaResourcePersistentAttribute getResourcePersistentAttribute() {
        return this.getParent().getResourcePersistentAttribute();
    }

    public T getMappingAnnotation() {
        return this.mappingAnnotation;
    }

    @Override
    public boolean isDefault() {
        return this.getPersistentAttribute().mappingIsDefault(this);
    }

    @Override
    public boolean shouldValidateAgainstDatabase() {
        return this.getTypeMapping().shouldValidateAgainstDatabase();
    }

    @Override
    public TypeMapping getTypeMapping() {
        return this.getPersistentAttribute().getOwningTypeMapping();
    }

    @Override
    public String getName() {
        return this.getPersistentAttribute().getName();
    }

    public Table getDbTable(String tableName) {
        return this.getTypeMapping().getDbTable(tableName);
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return null;
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return false;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return false;
    }

    @Override
    public boolean isRelationshipOwner() {
        return false;
    }

    @Override
    public boolean isOwnedBy(AttributeMapping mapping) {
        return false;
    }

    @Override
    public Iterator<String> allMappingNames() {
        return new SingleElementIterator((Object)this.getName());
    }

    @Override
    public AttributeMapping resolveAttributeMapping(String name) {
        if (this.getName().equals(name)) {
            return this;
        }
        return null;
    }

    @Override
    public Iterator<String> allOverrideableAttributeMappingNames() {
        if (this.isOverridableAttributeMapping()) {
            return new SingleElementIterator((Object)this.getName());
        }
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<String> allOverrideableAssociationMappingNames() {
        if (this.isOverridableAssociationMapping()) {
            return new SingleElementIterator((Object)this.getName());
        }
        return EmptyIterator.instance();
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        ColumnMapping columnMapping = this.resolveColumnMapping(attributeName);
        return columnMapping == null ? null : columnMapping.getColumn();
    }

    protected ColumnMapping resolveColumnMapping(String name) {
        AttributeMapping attributeMapping = this.resolveAttributeMapping(name);
        if (attributeMapping != null && attributeMapping.isOverridableAttributeMapping()) {
            return (ColumnMapping)attributeMapping;
        }
        return null;
    }

    @Override
    public RelationshipReference resolveRelationshipReference(String attributeName) {
        RelationshipMapping relationshipMapping = this.resolveRelationshipMapping(attributeName);
        return relationshipMapping == null ? null : relationshipMapping.getRelationshipReference();
    }

    protected RelationshipMapping resolveRelationshipMapping(String name) {
        AttributeMapping attributeMapping = this.resolveAttributeMapping(name);
        if (attributeMapping != null && attributeMapping.isOverridableAssociationMapping()) {
            return (RelationshipMapping)attributeMapping;
        }
        return null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public Iterable<String> getSupportingAnnotationNames() {
        if (this.supportingAnnotationNames == null) {
            this.supportingAnnotationNames = this.buildSupportingAnnotationNames();
        }
        return this.supportingAnnotationNames;
    }

    protected Vector<String> buildSupportingAnnotationNames() {
        Vector<String> names = new Vector<String>();
        this.addSupportingAnnotationNamesTo(names);
        return names;
    }

    protected void addSupportingAnnotationNamesTo(Vector<String> names) {
    }

    @Override
    public MetamodelField getMetamodelField() {
        return new SimpleMetamodelField(this.getMetamodelFieldModifiers(), this.getMetamodelFieldTypeName(), this.getMetamodelFieldTypeArgumentNames(), this.getMetamodelFieldName());
    }

    protected Iterable<String> getMetamodelFieldModifiers() {
        return STANDARD_METAMODEL_FIELD_MODIFIERS;
    }

    protected String getMetamodelFieldTypeName() {
        return "javax.persistence.metamodel.SingularAttribute";
    }

    protected final Iterable<String> getMetamodelFieldTypeArgumentNames() {
        ArrayList<String> typeArgumentNames = new ArrayList<String>(3);
        typeArgumentNames.add(this.getTypeMapping().getPersistentType().getName());
        this.addMetamodelFieldTypeArgumentNamesTo(typeArgumentNames);
        return typeArgumentNames;
    }

    protected void addMetamodelFieldTypeArgumentNamesTo(ArrayList<String> typeArgumentNames) {
        typeArgumentNames.add(this.getMetamodelTypeName());
    }

    @Override
    public String getMetamodelTypeName() {
        return ((JavaPersistentAttribute2_0)this.getPersistentAttribute()).getMetamodelTypeName();
    }

    protected String getMetamodelFieldName() {
        return this.getName();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateMappingType(messages, astRoot);
    }

    protected void validateMappingType(List<IMessage> messages, CompilationUnit astRoot) {
        if (!this.getTypeMapping().attributeMappingKeyAllowed(this.getKey())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_INVALID_MAPPING", new String[]{this.getName()}, this, this.getValidationTextRange(astRoot)));
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getMappingAnnotationTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    protected TextRange getMappingAnnotationTextRange(CompilationUnit astRoot) {
        return this.mappingAnnotation == null ? null : this.mappingAnnotation.getTextRange(astRoot);
    }
}

