/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.core.JpaPlatformVariation;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.DiscriminatorColumn;
import org.eclipse.jpt.core.context.DiscriminatorType;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.RelationshipReference;
import org.eclipse.jpt.core.context.SecondaryTable;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaIdClassReference;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.java.JavaSecondaryTable;
import org.eclipse.jpt.core.context.java.JavaTable;
import org.eclipse.jpt.core.context.orm.OrmAssociationOverride;
import org.eclipse.jpt.core.context.orm.OrmAssociationOverrideContainer;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.core.context.orm.OrmBaseJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmDiscriminatorColumn;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmGeneratorContainer;
import org.eclipse.jpt.core.context.orm.OrmIdClassReference;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmQueryContainer;
import org.eclipse.jpt.core.context.orm.OrmSecondaryTable;
import org.eclipse.jpt.core.context.orm.OrmTable;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.PrimaryKeyTextRangeResolver;
import org.eclipse.jpt.core.internal.context.PrimaryKeyValidator;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaEntity;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmTypeMapping;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmIdClassReference;
import org.eclipse.jpt.core.internal.context.orm.OrmEntityTextRangeResolver;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlAttributeOverrideColumn;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlColumn;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlSecondaryTable;
import org.eclipse.jpt.core.internal.jpa1.context.GenericEntityPrimaryKeyValidator;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.jpa2.context.SingleRelationshipMapping2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmCacheableHolder2_0;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.orm.Inheritance;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAssociationOverride;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.resource.orm.XmlGeneratorContainer;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlQueryContainer;
import org.eclipse.jpt.core.resource.orm.XmlSecondaryTable;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.utility.internal.ClassName;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.jpt.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmEntity
extends AbstractOrmTypeMapping<XmlEntity>
implements OrmEntity,
OrmCacheableHolder2_0 {
    protected String specifiedName;
    protected String defaultName;
    protected final OrmIdClassReference idClassReference = this.buildIdClassReference();
    protected final OrmTable table = this.getXmlContextNodeFactory().buildOrmTable(this);
    protected boolean specifiedTableIsAllowed;
    protected boolean tableIsUndefined;
    protected final List<OrmSecondaryTable> specifiedSecondaryTables = new ArrayList<OrmSecondaryTable>();
    protected final List<OrmSecondaryTable> virtualSecondaryTables = new ArrayList<OrmSecondaryTable>();
    protected final List<OrmPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns;
    protected final List<OrmPrimaryKeyJoinColumn> defaultPrimaryKeyJoinColumns;
    protected InheritanceType specifiedInheritanceStrategy;
    protected InheritanceType defaultInheritanceStrategy;
    protected String defaultDiscriminatorValue;
    protected String specifiedDiscriminatorValue;
    protected boolean specifiedDiscriminatorValueIsAllowed;
    protected boolean discriminatorValueIsUndefined;
    protected final OrmDiscriminatorColumn discriminatorColumn = this.buildDiscriminatorColumn();
    protected boolean specifiedDiscriminatorColumnIsAllowed;
    protected boolean discriminatorColumnIsUndefined;
    protected final OrmGeneratorContainer generatorContainer;
    protected final OrmAttributeOverrideContainer attributeOverrideContainer;
    protected final OrmAssociationOverrideContainer associationOverrideContainer;
    protected final OrmQueryContainer queryContainer;
    protected Entity rootEntity;

    protected AbstractOrmEntity(OrmPersistentType parent, XmlEntity resourceMapping) {
        super(parent, resourceMapping);
        this.specifiedPrimaryKeyJoinColumns = new ArrayList<OrmPrimaryKeyJoinColumn>();
        this.defaultPrimaryKeyJoinColumns = new ArrayList<OrmPrimaryKeyJoinColumn>();
        this.associationOverrideContainer = this.buildAssociationOverrideContainer();
        this.attributeOverrideContainer = this.buildAttributeOverrideContainer();
        this.queryContainer = this.buildQueryContainer();
        this.generatorContainer = this.buildGeneratorContainer();
        this.specifiedName = ((XmlEntity)this.resourceTypeMapping).getName();
        this.defaultName = this.buildDefaultName();
        this.rootEntity = this.calculateRootEntity();
        this.initializeInheritance(this.getResourceInheritance());
        this.specifiedDiscriminatorColumnIsAllowed = this.buildSpecifiedDiscriminatorColumnIsAllowed();
        this.discriminatorColumnIsUndefined = this.buildDiscriminatorColumnIsUndefined();
        this.discriminatorColumn.initialize((XmlEntity)this.resourceTypeMapping);
        this.specifiedDiscriminatorValueIsAllowed = this.buildSpecifiedDiscriminatorValueIsAllowed();
        this.discriminatorValueIsUndefined = this.buildDiscriminatorValueIsUndefined();
        this.specifiedDiscriminatorValue = ((XmlEntity)this.resourceTypeMapping).getDiscriminatorValue();
        this.defaultDiscriminatorValue = this.buildDefaultDiscriminatorValue();
        this.specifiedTableIsAllowed = this.buildSpecifiedTableIsAllowed();
        this.tableIsUndefined = this.buildTableIsUndefined();
        this.table.initialize((XmlEntity)this.resourceTypeMapping);
        this.initializeSpecifiedSecondaryTables();
        this.initializeVirtualSecondaryTables();
        this.initializeSpecifiedPrimaryKeyJoinColumns();
        this.initializeDefaultPrimaryKeyJoinColumns();
    }

    protected OrmIdClassReference buildIdClassReference() {
        return new GenericOrmIdClassReference(this, this.getJavaIdClassReferenceForDefaults());
    }

    protected OrmDiscriminatorColumn buildDiscriminatorColumn() {
        return this.getXmlContextNodeFactory().buildOrmDiscriminatorColumn(this, this.buildDiscriminatorColumnOwner());
    }

    protected OrmDiscriminatorColumn.Owner buildDiscriminatorColumnOwner() {
        return new OrmDiscriminatorColumn.Owner(){

            public String getDefaultTableName() {
                return AbstractOrmEntity.this.getPrimaryTableName();
            }

            public org.eclipse.jpt.db.Table getDbTable(String tableName) {
                return AbstractOrmEntity.this.getDbTable(tableName);
            }

            public TypeMapping getTypeMapping() {
                return AbstractOrmEntity.this;
            }

            public String getDefaultColumnName() {
                if (((XmlEntity)AbstractOrmEntity.this.getResourceTypeMapping()).getDiscriminatorColumn() == null && !AbstractOrmEntity.this.isMetadataComplete() && AbstractOrmEntity.this.getJavaEntity() != null && AbstractOrmEntity.this.getJavaEntity().getDiscriminatorColumn().getSpecifiedName() != null) {
                    return AbstractOrmEntity.this.getJavaEntity().getDiscriminatorColumn().getSpecifiedName();
                }
                return AbstractOrmEntity.this.isDescendant() ? AbstractOrmEntity.this.getRootEntity().getDiscriminatorColumn().getName() : (AbstractOrmEntity.this.isTablePerClass() ? null : "DTYPE");
            }

            public int getDefaultLength() {
                if (((XmlEntity)AbstractOrmEntity.this.getResourceTypeMapping()).getDiscriminatorColumn() == null && !AbstractOrmEntity.this.isMetadataComplete() && AbstractOrmEntity.this.getJavaEntity() != null && AbstractOrmEntity.this.getJavaEntity().getDiscriminatorColumn().getSpecifiedLength() != null) {
                    return AbstractOrmEntity.this.getJavaEntity().getDiscriminatorColumn().getSpecifiedLength();
                }
                return AbstractOrmEntity.this.isDescendant() ? AbstractOrmEntity.this.getRootEntity().getDiscriminatorColumn().getLength() : (AbstractOrmEntity.this.isTablePerClass() ? 0 : 31);
            }

            public DiscriminatorType getDefaultDiscriminatorType() {
                if (((XmlEntity)AbstractOrmEntity.this.getResourceTypeMapping()).getDiscriminatorColumn() == null && !AbstractOrmEntity.this.isMetadataComplete() && AbstractOrmEntity.this.getJavaEntity() != null && AbstractOrmEntity.this.getJavaEntity().getDiscriminatorColumn().getSpecifiedDiscriminatorType() != null) {
                    return AbstractOrmEntity.this.getJavaEntity().getDiscriminatorColumn().getSpecifiedDiscriminatorType();
                }
                return AbstractOrmEntity.this.isDescendant() ? AbstractOrmEntity.this.getRootEntity().getDiscriminatorColumn().getDiscriminatorType() : (AbstractOrmEntity.this.isTablePerClass() ? null : DiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE);
            }

            public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
                return DefaultJpaValidationMessages.buildMessage(1, "DISCRIMINATOR_COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
            }

            public TextRange getValidationTextRange() {
                return AbstractOrmEntity.this.getValidationTextRange();
            }
        };
    }

    protected OrmAssociationOverrideContainer buildAssociationOverrideContainer() {
        return this.getXmlContextNodeFactory().buildOrmAssociationOverrideContainer(this, (OrmAssociationOverrideContainer.Owner)new AssociationOverrideContainerOwner());
    }

    protected OrmAttributeOverrideContainer buildAttributeOverrideContainer() {
        return this.getXmlContextNodeFactory().buildOrmAttributeOverrideContainer(this, new AttributeOverrideContainerOwner());
    }

    protected OrmGeneratorContainer buildGeneratorContainer() {
        return this.getXmlContextNodeFactory().buildOrmGeneratorContainer(this, (XmlGeneratorContainer)((Object)this.resourceTypeMapping));
    }

    protected OrmQueryContainer buildQueryContainer() {
        return this.getXmlContextNodeFactory().buildOrmQueryContainer(this, (XmlQueryContainer)((Object)this.resourceTypeMapping));
    }

    @Override
    public String getKey() {
        return "entity";
    }

    @Override
    public JavaPersistentType getIdClass() {
        return this.idClassReference.getIdClass();
    }

    @Override
    public String getPrimaryTableName() {
        return this.table.getName();
    }

    @Override
    public org.eclipse.jpt.db.Table getPrimaryDbTable() {
        return this.table.getDbTable();
    }

    @Override
    public org.eclipse.jpt.db.Table getDbTable(String tableName) {
        return this.getDataSource().selectDatabaseObjectForIdentifier(this.getAssociatedDbTablesIncludingInherited(), tableName);
    }

    private Iterable<org.eclipse.jpt.db.Table> getAssociatedDbTablesIncludingInherited() {
        return new FilteringIterable<org.eclipse.jpt.db.Table>(this.getAssociatedDbTablesIncludingInherited_()){

            protected boolean accept(org.eclipse.jpt.db.Table t) {
                return t != null;
            }
        };
    }

    private Iterable<org.eclipse.jpt.db.Table> getAssociatedDbTablesIncludingInherited_() {
        return new TransformationIterable<Table, org.eclipse.jpt.db.Table>(this.getAssociatedTablesIncludingInherited()){

            protected org.eclipse.jpt.db.Table transform(Table t) {
                return t.getDbTable();
            }
        };
    }

    @Override
    public Schema getDbSchema() {
        return this.table.getDbSchema();
    }

    @Override
    public JavaEntity getJavaEntity() {
        JavaPersistentType javaPersistentType = this.getJavaPersistentType();
        if (javaPersistentType != null && javaPersistentType.getMappingKey() == "entity") {
            return (JavaEntity)javaPersistentType.getMapping();
        }
        return null;
    }

    protected JavaEntity getJavaEntityForDefaults() {
        if (this.isMetadataComplete()) {
            return null;
        }
        return this.getJavaEntity();
    }

    protected JavaIdClassReference getJavaIdClassReferenceForDefaults() {
        JavaEntity entity = this.getJavaEntityForDefaults();
        return entity == null ? null : entity.getIdClassReference();
    }

    public TypeMapping getOverridableTypeMapping() {
        PersistentType superPersistentType = this.getPersistentType().getSuperPersistentType();
        return superPersistentType == null ? null : superPersistentType.getMapping();
    }

    public OrmTypeMapping getTypeMapping() {
        return this;
    }

    protected JavaAttributeOverride getJavaAttributeOverrideNamed(String attributeName) {
        if (this.getJavaEntity() != null) {
            return this.getJavaEntity().getAttributeOverrideContainer().getAttributeOverrideNamed(attributeName);
        }
        return null;
    }

    @Override
    public RelationshipReference resolveRelationshipReference(String name) {
        OrmAssociationOverride override;
        int dotIndex;
        if (this.isJpa2_0Compatible() && (dotIndex = name.indexOf(46)) != -1 && (override = this.getAssociationOverrideContainer().getAssociationOverrideNamed(name.substring(dotIndex + 1))) != null && !override.isVirtual()) {
            return override.getRelationshipReference();
        }
        return super.resolveRelationshipReference(name);
    }

    protected JavaAssociationOverride getJavaAssociationOverrideNamed(String attributeName) {
        if (this.getJavaEntity() != null) {
            return this.getJavaEntity().getAssociationOverrideContainer().getAssociationOverrideNamed(attributeName);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        ((XmlEntity)this.resourceTypeMapping).setName(newSpecifiedName);
        this.firePropertyChanged("specifiedName", oldSpecifiedName, newSpecifiedName);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        this.firePropertyChanged("defaultName", oldDefaultName, newDefaultName);
    }

    @Override
    public OrmIdClassReference getIdClassReference() {
        return this.idClassReference;
    }

    @Override
    public OrmTable getTable() {
        return this.table;
    }

    @Override
    public ListIterator<OrmSecondaryTable> secondaryTables() {
        if (this.specifiedSecondaryTablesSize() > 0) {
            return this.specifiedSecondaryTables();
        }
        return this.virtualSecondaryTables();
    }

    @Override
    public int secondaryTablesSize() {
        if (this.specifiedSecondaryTablesSize() > 0) {
            return this.specifiedSecondaryTablesSize();
        }
        return this.virtualSecondaryTablesSize();
    }

    @Override
    public ListIterator<OrmSecondaryTable> virtualSecondaryTables() {
        return new CloneListIterator(this.virtualSecondaryTables);
    }

    @Override
    public int virtualSecondaryTablesSize() {
        return this.virtualSecondaryTables.size();
    }

    protected void addVirtualSecondaryTable(OrmSecondaryTable secondaryTable) {
        this.addItemToList(secondaryTable, this.virtualSecondaryTables, "virtualSecondaryTables");
    }

    protected void removeVirtualSecondaryTable(OrmSecondaryTable secondaryTable) {
        this.removeItemFromList(secondaryTable, this.virtualSecondaryTables, "virtualSecondaryTables");
    }

    @Override
    public ListIterator<OrmSecondaryTable> specifiedSecondaryTables() {
        return new CloneListIterator(this.specifiedSecondaryTables);
    }

    @Override
    public int specifiedSecondaryTablesSize() {
        return this.specifiedSecondaryTables.size();
    }

    @Override
    public OrmSecondaryTable addSpecifiedSecondaryTable(int index) {
        if (!this.secondaryTablesDefinedInXml()) {
            throw new IllegalStateException("Virtual secondary tables exist, must first call setSecondaryTablesDefinedInXml(true)");
        }
        XmlSecondaryTable secondaryTableResource = OrmFactory.eINSTANCE.createXmlSecondaryTable();
        OrmSecondaryTable secondaryTable = this.buildSecondaryTable(secondaryTableResource);
        this.specifiedSecondaryTables.add(index, secondaryTable);
        ((XmlEntity)this.resourceTypeMapping).getSecondaryTables().add(index, (Object)secondaryTableResource);
        this.fireItemAdded("specifiedSecondaryTables", index, secondaryTable);
        return secondaryTable;
    }

    @Override
    public OrmSecondaryTable addSpecifiedSecondaryTable() {
        return this.addSpecifiedSecondaryTable(this.specifiedSecondaryTables.size());
    }

    protected void addSpecifiedSecondaryTable(int index, OrmSecondaryTable secondaryTable) {
        this.addItemToList(index, secondaryTable, this.specifiedSecondaryTables, "specifiedSecondaryTables");
    }

    protected void addSpecifiedSecondaryTable(OrmSecondaryTable secondaryTable) {
        this.addSpecifiedSecondaryTable(this.specifiedSecondaryTables.size(), secondaryTable);
    }

    @Override
    public void removeSpecifiedSecondaryTable(SecondaryTable secondaryTable) {
        this.removeSpecifiedSecondaryTable(this.specifiedSecondaryTables.indexOf(secondaryTable));
    }

    @Override
    public void removeSpecifiedSecondaryTable(int index) {
        OrmSecondaryTable removedSecondaryTable = this.specifiedSecondaryTables.remove(index);
        ((XmlEntity)this.resourceTypeMapping).getSecondaryTables().remove(index);
        this.fireItemRemoved("specifiedSecondaryTables", index, removedSecondaryTable);
    }

    protected void removeSpecifiedSecondaryTable_(OrmSecondaryTable secondaryTable) {
        this.removeItemFromList(secondaryTable, this.specifiedSecondaryTables, "specifiedSecondaryTables");
    }

    @Override
    public void moveSpecifiedSecondaryTable(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedSecondaryTables, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.resourceTypeMapping).getSecondaryTables().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedSecondaryTables", targetIndex, sourceIndex);
    }

    public boolean containsSecondaryTable(String name) {
        return this.containsSecondaryTable(name, this.secondaryTables());
    }

    public boolean containsSpecifiedSecondaryTable(String name) {
        return this.containsSecondaryTable(name, this.specifiedSecondaryTables());
    }

    public boolean containsVirtualSecondaryTable(String name) {
        return this.containsSecondaryTable(name, this.virtualSecondaryTables());
    }

    @Override
    public boolean containsVirtualSecondaryTable(OrmSecondaryTable secondaryTable) {
        return this.virtualSecondaryTables.contains(secondaryTable);
    }

    protected boolean containsSecondaryTable(String name, ListIterator<OrmSecondaryTable> secondaryTables) {
        for (OrmSecondaryTable secondaryTable : CollectionTools.iterable(secondaryTables)) {
            String secondaryTableName = secondaryTable.getName();
            if (secondaryTableName == null || !secondaryTableName.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean secondaryTablesDefinedInXml() {
        return this.virtualSecondaryTablesSize() == 0;
    }

    @Override
    public void setSecondaryTablesDefinedInXml(boolean defineInXml) {
        if (defineInXml == this.secondaryTablesDefinedInXml()) {
            return;
        }
        if (defineInXml) {
            this.specifySecondaryTablesInXml();
        } else {
            this.removeSecondaryTablesFromXml();
        }
    }

    protected void specifySecondaryTablesInXml() {
        if (this.virtualSecondaryTablesSize() != 0) {
            ArrayList virtualSecondaryTables1 = CollectionTools.list(this.virtualSecondaryTables());
            ArrayList virtualSecondaryTables2 = CollectionTools.list(this.virtualSecondaryTables());
            for (OrmSecondaryTable virtualSecondaryTable : CollectionTools.iterable(this.virtualSecondaryTables())) {
                this.virtualSecondaryTables.remove(virtualSecondaryTable);
            }
            for (OrmSecondaryTable virtualSecondaryTable : virtualSecondaryTables2) {
                XmlSecondaryTable secondaryTableResource = OrmFactory.eINSTANCE.createXmlSecondaryTable();
                OrmSecondaryTable specifiedSecondaryTable = this.buildSecondaryTable(secondaryTableResource);
                this.specifiedSecondaryTables.add(specifiedSecondaryTable);
                ((XmlEntity)this.resourceTypeMapping).getSecondaryTables().add((Object)secondaryTableResource);
                specifiedSecondaryTable.initializeFrom(virtualSecondaryTable);
            }
            this.fireItemsRemoved("virtualSecondaryTables", 0, virtualSecondaryTables1);
            this.fireItemsAdded("specifiedSecondaryTables", 0, this.specifiedSecondaryTables);
        }
    }

    protected void removeSecondaryTablesFromXml() {
        if (this.specifiedSecondaryTablesSize() != 0) {
            ArrayList specifiedSecondaryTablesCopy = CollectionTools.list(this.specifiedSecondaryTables());
            for (OrmSecondaryTable specifiedSecondaryTable : CollectionTools.iterable(this.specifiedSecondaryTables())) {
                int index = this.specifiedSecondaryTables.indexOf(specifiedSecondaryTable);
                this.specifiedSecondaryTables.remove(specifiedSecondaryTable);
                if (this.specifiedSecondaryTables.size() == 0) {
                    this.initializeVirtualSecondaryTables();
                }
                ((XmlEntity)this.resourceTypeMapping).getSecondaryTables().remove(index);
            }
            this.fireItemsRemoved("specifiedSecondaryTables", 0, specifiedSecondaryTablesCopy);
            if (this.virtualSecondaryTables.size() != 0) {
                this.fireItemsAdded("virtualSecondaryTables", 0, this.virtualSecondaryTables);
            }
        }
    }

    protected Iterator<String> tableNames(Iterator<Table> tables) {
        return new TransformationIterator<Table, String>(tables){

            protected String transform(Table t) {
                return t.getName();
            }
        };
    }

    @Override
    public Iterator<String> associatedTableNamesIncludingInherited() {
        return this.nonNullTableNames(this.associatedTablesIncludingInherited());
    }

    protected Iterator<String> nonNullTableNames(Iterator<Table> tables) {
        return new FilteringIterator<String>(this.tableNames(tables)){

            protected boolean accept(String o) {
                return o != null;
            }
        };
    }

    @Override
    public Iterator<Table> associatedTables() {
        return new CompositeIterator((Object)this.table, this.secondaryTables());
    }

    @Override
    public Iterator<Table> associatedTablesIncludingInherited() {
        return this.getAssociatedTablesIncludingInherited().iterator();
    }

    public Iterable<Table> getAssociatedTablesIncludingInherited() {
        return new CompositeIterable((Iterable)new TransformationIterable<TypeMapping, Iterable<Table>>(CollectionTools.iterable(this.inheritanceHierarchy())){

            protected Iterable<Table> transform(TypeMapping mapping) {
                return new FilteringIterable<Table>(CollectionTools.iterable(mapping.associatedTables())){

                    protected boolean accept(Table o) {
                        return true;
                    }
                };
            }
        });
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        if (this.tableIsUndefined()) {
            return false;
        }
        return !CollectionTools.contains(this.associatedTableNamesIncludingInherited(), (Object)tableName);
    }

    @Override
    public boolean shouldValidateAgainstDatabase() {
        return super.shouldValidateAgainstDatabase() && !this.isAbstractTablePerClass();
    }

    @Override
    public InheritanceType getInheritanceStrategy() {
        return this.getSpecifiedInheritanceStrategy() == null ? this.getDefaultInheritanceStrategy() : this.getSpecifiedInheritanceStrategy();
    }

    @Override
    public InheritanceType getDefaultInheritanceStrategy() {
        return this.defaultInheritanceStrategy;
    }

    protected void setDefaultInheritanceStrategy(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.defaultInheritanceStrategy;
        this.defaultInheritanceStrategy = newInheritanceType;
        this.firePropertyChanged("defaultInheritanceStrategy", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    @Override
    public InheritanceType getSpecifiedInheritanceStrategy() {
        return this.specifiedInheritanceStrategy;
    }

    @Override
    public void setSpecifiedInheritanceStrategy(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = newInheritanceType;
        if (oldInheritanceType != newInheritanceType) {
            if (this.getResourceInheritance() != null) {
                this.getResourceInheritance().setStrategy(InheritanceType.toOrmResourceModel(newInheritanceType));
                if (this.getResourceInheritance().isUnset()) {
                    this.removeResourceInheritance();
                }
            } else if (newInheritanceType != null) {
                this.addResourceInheritance();
                this.getResourceInheritance().setStrategy(InheritanceType.toOrmResourceModel(newInheritanceType));
            }
        }
        this.firePropertyChanged("specifiedInheritanceStrategy", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    protected void setSpecifiedInheritanceStrategy_(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = newInheritanceType;
        this.firePropertyChanged("specifiedInheritanceStrategy", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    protected Inheritance getResourceInheritance() {
        return ((XmlEntity)this.resourceTypeMapping).getInheritance();
    }

    protected void addResourceInheritance() {
        ((XmlEntity)this.resourceTypeMapping).setInheritance(OrmFactory.eINSTANCE.createInheritance());
    }

    protected void removeResourceInheritance() {
        ((XmlEntity)this.resourceTypeMapping).setInheritance(null);
    }

    @Override
    public OrmDiscriminatorColumn getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    @Override
    public OrmGeneratorContainer getGeneratorContainer() {
        return this.generatorContainer;
    }

    @Override
    public String getDefaultDiscriminatorValue() {
        return this.defaultDiscriminatorValue;
    }

    protected void setDefaultDiscriminatorValue(String newDefaultDiscriminatorValue) {
        String oldDefaultDiscriminatorValue = this.defaultDiscriminatorValue;
        this.defaultDiscriminatorValue = newDefaultDiscriminatorValue;
        this.firePropertyChanged("defaultDiscriminatorValue", oldDefaultDiscriminatorValue, newDefaultDiscriminatorValue);
    }

    @Override
    public String getSpecifiedDiscriminatorValue() {
        return this.specifiedDiscriminatorValue;
    }

    @Override
    public void setSpecifiedDiscriminatorValue(String newSpecifiedDiscriminatorValue) {
        String oldSpecifiedDiscriminatorValue = this.specifiedDiscriminatorValue;
        this.specifiedDiscriminatorValue = newSpecifiedDiscriminatorValue;
        ((XmlEntity)this.resourceTypeMapping).setDiscriminatorValue(newSpecifiedDiscriminatorValue);
        this.firePropertyChanged("specifiedDiscriminatorValue", oldSpecifiedDiscriminatorValue, newSpecifiedDiscriminatorValue);
    }

    @Override
    public String getDiscriminatorValue() {
        return this.getSpecifiedDiscriminatorValue() == null ? this.getDefaultDiscriminatorValue() : this.getSpecifiedDiscriminatorValue();
    }

    @Override
    public boolean specifiedDiscriminatorValueIsAllowed() {
        return this.specifiedDiscriminatorValueIsAllowed;
    }

    protected void setSpecifiedDiscriminatorValueIsAllowed(boolean specifiedDiscriminatorValueIsAllowed) {
        boolean old = this.specifiedDiscriminatorValueIsAllowed;
        this.specifiedDiscriminatorValueIsAllowed = specifiedDiscriminatorValueIsAllowed;
        this.firePropertyChanged("discriminatorValueIsAllowed", old, specifiedDiscriminatorValueIsAllowed);
    }

    @Override
    public boolean discriminatorValueIsUndefined() {
        return this.discriminatorValueIsUndefined;
    }

    protected void setDiscriminatorValueIsUndefined(boolean discriminatorValueIsUndefined) {
        boolean old = this.discriminatorValueIsUndefined;
        this.discriminatorValueIsUndefined = discriminatorValueIsUndefined;
        this.firePropertyChanged("discriminatorValueIsUndefined", old, discriminatorValueIsUndefined);
    }

    @Override
    public boolean specifiedDiscriminatorColumnIsAllowed() {
        return this.specifiedDiscriminatorColumnIsAllowed;
    }

    protected void setSpecifiedDiscriminatorColumnIsAllowed(boolean specifiedDiscriminatorColumnIsAllowed) {
        boolean old = this.specifiedDiscriminatorColumnIsAllowed;
        this.specifiedDiscriminatorColumnIsAllowed = specifiedDiscriminatorColumnIsAllowed;
        this.firePropertyChanged("specifiedDiscriminatorColumnIsAllowed", old, specifiedDiscriminatorColumnIsAllowed);
    }

    @Override
    public boolean discriminatorColumnIsUndefined() {
        return this.discriminatorColumnIsUndefined;
    }

    protected void setDiscriminatorColumnIsUndefined(boolean discriminatorColumnIsUndefined) {
        boolean old = this.discriminatorColumnIsUndefined;
        this.discriminatorColumnIsUndefined = discriminatorColumnIsUndefined;
        this.firePropertyChanged("discriminatorColumnIsUndefined", old, discriminatorColumnIsUndefined);
    }

    @Override
    public boolean specifiedTableIsAllowed() {
        return this.specifiedTableIsAllowed;
    }

    protected void setSpecifiedTableIsAllowed(boolean specifiedTableIsAllowed) {
        boolean old = this.specifiedTableIsAllowed;
        this.specifiedTableIsAllowed = specifiedTableIsAllowed;
        this.firePropertyChanged("specifiedTableIsAllowed", old, specifiedTableIsAllowed);
    }

    @Override
    public boolean tableIsUndefined() {
        return this.tableIsUndefined;
    }

    protected void setTableIsUndefined(boolean tableIsUndefined) {
        boolean old = this.tableIsUndefined;
        this.tableIsUndefined = tableIsUndefined;
        this.firePropertyChanged("tableIsUndefined", old, tableIsUndefined);
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> defaultPrimaryKeyJoinColumns() {
        return new CloneListIterator(this.defaultPrimaryKeyJoinColumns);
    }

    public int defaultPrimaryKeyJoinColumnsSize() {
        return this.defaultPrimaryKeyJoinColumns.size();
    }

    @Override
    public OrmPrimaryKeyJoinColumn getDefaultPrimaryKeyJoinColumn() {
        throw new UnsupportedOperationException("use defaultPrimaryKeyJoinColumns() instead");
    }

    protected void addDefaultPrimaryKeyJoinColumn(OrmPrimaryKeyJoinColumn defaultPkJoinColumn) {
        this.addItemToList(defaultPkJoinColumn, this.defaultPrimaryKeyJoinColumns, "defaultPrimaryKeyJoinColumns");
    }

    protected void removeDefaultPrimaryKeyJoinColumn(PrimaryKeyJoinColumn defaultPkJoinColumn) {
        this.removeItemFromList(defaultPkJoinColumn, this.defaultPrimaryKeyJoinColumns, "defaultPrimaryKeyJoinColumns");
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return this.specifiedPrimaryKeyJoinColumns.isEmpty() ? this.defaultPrimaryKeyJoinColumns() : this.specifiedPrimaryKeyJoinColumns();
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumns.isEmpty() ? this.defaultPrimaryKeyJoinColumnsSize() : this.specifiedPrimaryKeyJoinColumnsSize();
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns() {
        return new CloneListIterator(this.specifiedPrimaryKeyJoinColumns);
    }

    @Override
    public int specifiedPrimaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumns.size();
    }

    public boolean containsSpecifiedPrimaryKeyJoinColumns() {
        return !this.specifiedPrimaryKeyJoinColumns.isEmpty();
    }

    @Override
    public OrmPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn(int index) {
        if (!this.defaultPrimaryKeyJoinColumns.isEmpty()) {
            this.defaultPrimaryKeyJoinColumns.clear();
        }
        XmlPrimaryKeyJoinColumn resourcePkJoinColumn = OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumn();
        OrmPrimaryKeyJoinColumn contextPkJoinColumn = this.buildPrimaryKeyJoinColumn(resourcePkJoinColumn);
        this.specifiedPrimaryKeyJoinColumns.add(index, contextPkJoinColumn);
        ((XmlEntity)this.resourceTypeMapping).getPrimaryKeyJoinColumns().add(index, (Object)resourcePkJoinColumn);
        this.fireItemAdded("specifiedPrimaryKeyJoinColumns", index, contextPkJoinColumn);
        this.fireListCleared("defaultPrimaryKeyJoinColumns");
        return contextPkJoinColumn;
    }

    protected OrmBaseJoinColumn.Owner createPrimaryKeyJoinColumnOwner() {
        return new PrimaryKeyJoinColumnOwner();
    }

    protected void addSpecifiedPrimaryKeyJoinColumn(int index, OrmPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.addItemToList(index, primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    protected void addSpecifiedPrimaryKeyJoinColumn(OrmPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.addSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.size(), primaryKeyJoinColumn);
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(PrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.indexOf(primaryKeyJoinColumn));
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(int index) {
        OrmPrimaryKeyJoinColumn removedPrimaryKeyJoinColumn = this.specifiedPrimaryKeyJoinColumns.remove(index);
        if (!this.containsSpecifiedPrimaryKeyJoinColumns()) {
            this.initializeDefaultPrimaryKeyJoinColumns();
        }
        ((XmlEntity)this.resourceTypeMapping).getPrimaryKeyJoinColumns().remove(index);
        this.fireItemRemoved("specifiedPrimaryKeyJoinColumns", index, removedPrimaryKeyJoinColumn);
        if (!this.defaultPrimaryKeyJoinColumns.isEmpty()) {
            this.fireListChanged("defaultPrimaryKeyJoinColumns", this.defaultPrimaryKeyJoinColumns);
        }
    }

    protected void removeSpecifiedPrimaryKeyJoinColumn_(OrmPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeItemFromList(primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    @Override
    public void moveSpecifiedPrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedPrimaryKeyJoinColumns, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.resourceTypeMapping).getPrimaryKeyJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedPrimaryKeyJoinColumns", targetIndex, sourceIndex);
    }

    @Override
    public OrmAttributeOverrideContainer getAttributeOverrideContainer() {
        return this.attributeOverrideContainer;
    }

    @Override
    public OrmAssociationOverrideContainer getAssociationOverrideContainer() {
        return this.associationOverrideContainer;
    }

    @Override
    public OrmQueryContainer getQueryContainer() {
        return this.queryContainer;
    }

    @Override
    public String getDefaultTableName() {
        JavaEntity javaEntity = this.getJavaEntity();
        if (javaEntity != null) {
            JavaTable javaTable = javaEntity.getTable();
            if (!this.isMetadataComplete() && !this.table.isResourceSpecified() && javaTable.getSpecifiedName() != null) {
                return javaTable.getSpecifiedName();
            }
        }
        return this.isSingleTableDescendant() ? this.getRootEntity().getTable().getName() : (this.isAbstractTablePerClass() ? null : this.getName());
    }

    @Override
    public String getDefaultSchema() {
        JavaEntity javaEntity = this.getJavaEntity();
        if (javaEntity != null) {
            JavaTable javaTable = javaEntity.getTable();
            if (!this.isMetadataComplete() && !this.table.isResourceSpecified() && javaTable.getSpecifiedSchema() != null) {
                return javaTable.getSpecifiedSchema();
            }
        }
        return this.isSingleTableDescendant() ? this.getRootEntity().getTable().getSchema() : (this.isAbstractTablePerClass() ? null : this.getContextDefaultSchema());
    }

    @Override
    public String getDefaultCatalog() {
        JavaEntity javaEntity = this.getJavaEntity();
        if (javaEntity != null) {
            JavaTable javaTable = javaEntity.getTable();
            if (!this.isMetadataComplete() && !this.table.isResourceSpecified() && javaTable.getSpecifiedCatalog() != null) {
                return javaTable.getSpecifiedCatalog();
            }
        }
        return this.isSingleTableDescendant() ? this.getRootEntity().getTable().getCatalog() : (this.isAbstractTablePerClass() ? null : this.getContextDefaultCatalog());
    }

    protected boolean isSingleTableDescendant() {
        return this.isDescendant() && this.getInheritanceStrategy() == InheritanceType.SINGLE_TABLE;
    }

    @Override
    public Entity getParentEntity() {
        Iterator<PersistentType> stream = this.getPersistentType().ancestors();
        while (stream.hasNext()) {
            TypeMapping tm = stream.next().getMapping();
            if (!(tm instanceof Entity)) continue;
            return (Entity)tm;
        }
        return null;
    }

    @Override
    public Entity getRootEntity() {
        return this.rootEntity;
    }

    @Override
    public boolean isRoot() {
        return this == this.getRootEntity();
    }

    protected boolean isDescendant() {
        return !this.isRoot();
    }

    protected boolean isRootNoDescendantsNoStrategyDefined() {
        return this.isRoot() && !this.getPersistenceUnit().entityIsRootWithSubEntities(this.getName()) && this.getSpecifiedInheritanceStrategy() == null;
    }

    protected boolean isAbstractTablePerClass() {
        return this.isAbstract() && this.isTablePerClass();
    }

    protected boolean isTablePerClass() {
        return this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS;
    }

    protected boolean isAbstract() {
        JavaResourcePersistentType javaResourcePersistentType = this.getJavaResourcePersistentType();
        return javaResourcePersistentType == null ? false : javaResourcePersistentType.isAbstract();
    }

    @Override
    public int getXmlSequence() {
        return 1;
    }

    protected Iterator<TypeMapping> ancestors() {
        return new TransformationIterator<PersistentType, TypeMapping>(this.getPersistentType().ancestors()){

            protected TypeMapping transform(PersistentType type) {
                return type.getMapping();
            }
        };
    }

    @Override
    public Iterator<String> overridableAttributeNames() {
        if (!this.isTablePerClass()) {
            return EmptyIterator.instance();
        }
        return super.overridableAttributeNames();
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        OrmAttributeOverride override;
        int dotIndex;
        if (this.isJpa2_0Compatible() && (dotIndex = attributeName.indexOf(46)) != -1 && (override = this.getAttributeOverrideContainer().getAttributeOverrideNamed(attributeName.substring(dotIndex + 1))) != null && !override.isVirtual()) {
            return override.getColumn();
        }
        return super.resolveOverriddenColumn(attributeName);
    }

    @Override
    public Iterator<String> overridableAssociationNames() {
        if (!this.isTablePerClass()) {
            return EmptyIterator.instance();
        }
        return super.overridableAssociationNames();
    }

    @Override
    public AttributeMapping resolveAttributeMapping(String name) {
        for (AttributeMapping attributeMapping : CollectionTools.iterable(this.allAttributeMappings())) {
            AttributeMapping resolvedMapping = attributeMapping.resolveAttributeMapping(name);
            if (resolvedMapping == null) continue;
            return resolvedMapping;
        }
        return null;
    }

    protected void initializeInheritance(Inheritance inheritanceResource) {
        this.specifiedInheritanceStrategy = this.getResourceInheritanceStrategy(inheritanceResource);
    }

    protected void initializeSpecifiedSecondaryTables() {
        for (XmlSecondaryTable secondaryTable : ((XmlEntity)this.resourceTypeMapping).getSecondaryTables()) {
            this.specifiedSecondaryTables.add(this.buildSecondaryTable(secondaryTable));
        }
    }

    protected void initializeVirtualSecondaryTables() {
        if (this.isMetadataComplete()) {
            return;
        }
        if (this.getJavaEntity() == null) {
            return;
        }
        if (this.specifiedSecondaryTablesSize() > 0) {
            return;
        }
        ListIterator<JavaSecondaryTable> javaSecondaryTables = this.getJavaEntity().secondaryTables();
        while (javaSecondaryTables.hasNext()) {
            JavaSecondaryTable javaSecondaryTable = javaSecondaryTables.next();
            if (javaSecondaryTable.getName() == null) continue;
            this.virtualSecondaryTables.add(this.buildVirtualSecondaryTable(javaSecondaryTable));
        }
    }

    protected void initializeDefaultPrimaryKeyJoinColumns() {
        if (this.isMetadataComplete()) {
            return;
        }
        if (this.getJavaEntity() == null) {
            this.defaultPrimaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn(null));
            return;
        }
        if (this.specifiedPrimaryKeyJoinColumnsSize() > 0) {
            return;
        }
        ListIterator<JavaPrimaryKeyJoinColumn> javaPkJoinColumns = this.getJavaEntity().primaryKeyJoinColumns();
        while (javaPkJoinColumns.hasNext()) {
            JavaPrimaryKeyJoinColumn javaPkJoinColumn = javaPkJoinColumns.next();
            if (javaPkJoinColumn.getName() == null) continue;
            this.defaultPrimaryKeyJoinColumns.add(this.buildVirtualPrimaryKeyJoinColumn(javaPkJoinColumn));
        }
    }

    protected void initializeSpecifiedPrimaryKeyJoinColumns() {
        for (XmlPrimaryKeyJoinColumn resourcePkJoinColumn : ((XmlEntity)this.resourceTypeMapping).getPrimaryKeyJoinColumns()) {
            this.specifiedPrimaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn(resourcePkJoinColumn));
        }
    }

    @Override
    public void update() {
        super.update();
        this.setSpecifiedName(((XmlEntity)this.resourceTypeMapping).getName());
        this.setDefaultName(this.buildDefaultName());
        this.idClassReference.update(this.getJavaIdClassReferenceForDefaults());
        this.updateInheritance(this.getResourceInheritance());
        this.updateRootEntity();
        this.updateDiscriminatorColumn();
        this.updateDiscriminatorValue();
        this.setSpecifiedTableIsAllowed(this.buildSpecifiedTableIsAllowed());
        this.setTableIsUndefined(this.buildTableIsUndefined());
        this.table.update((XmlEntity)this.resourceTypeMapping);
        this.updateSpecifiedSecondaryTables();
        this.updateVirtualSecondaryTables();
        this.generatorContainer.update();
        this.updateSpecifiedPrimaryKeyJoinColumns();
        this.updateDefaultPrimaryKeyJoinColumns();
        this.getAttributeOverrideContainer().update();
        this.getAssociationOverrideContainer().update();
        this.getQueryContainer().update();
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        this.postUpdateDiscriminatorColumn();
        this.postUpdateDiscriminatorValue();
    }

    protected String buildDefaultName() {
        JavaEntity javaEntity;
        if (!this.isMetadataComplete() && (javaEntity = this.getJavaEntity()) != null) {
            return javaEntity.getName();
        }
        String className = this.getClass_();
        return StringTools.stringIsEmpty((String)className) ? null : ClassName.getSimpleName((String)className);
    }

    protected void updateDiscriminatorColumn() {
        this.setSpecifiedDiscriminatorColumnIsAllowed(this.buildSpecifiedDiscriminatorColumnIsAllowed());
        this.getDiscriminatorColumn().update((XmlEntity)this.resourceTypeMapping);
    }

    protected void postUpdateDiscriminatorColumn() {
        this.setDiscriminatorColumnIsUndefined(this.buildDiscriminatorColumnIsUndefined());
        this.getDiscriminatorColumn().postUpdate();
    }

    protected void updateDiscriminatorValue() {
        this.setSpecifiedDiscriminatorValueIsAllowed(this.buildSpecifiedDiscriminatorValueIsAllowed());
        this.setSpecifiedDiscriminatorValue(((XmlEntity)this.resourceTypeMapping).getDiscriminatorValue());
    }

    protected void postUpdateDiscriminatorValue() {
        this.setDiscriminatorValueIsUndefined(this.buildDiscriminatorValueIsUndefined());
        this.setDefaultDiscriminatorValue(this.buildDefaultDiscriminatorValue());
    }

    protected String buildDefaultDiscriminatorValue() {
        if (!this.isMetadataComplete() && this.getJavaEntity() != null) {
            return this.getJavaEntity().getDiscriminatorValue();
        }
        if (this.discriminatorValueIsUndefined()) {
            return null;
        }
        if (this.getDiscriminatorType() != DiscriminatorType.STRING) {
            return null;
        }
        return this.getName();
    }

    protected DiscriminatorType getDiscriminatorType() {
        return this.getDiscriminatorColumn().getDiscriminatorType();
    }

    protected JavaResourcePersistentType getJavaResourcePersistentType() {
        if (this.getPersistentType().getJavaPersistentType() != null) {
            return this.getPersistentType().getJavaPersistentType().getResourcePersistentType();
        }
        return null;
    }

    protected boolean buildSpecifiedDiscriminatorValueIsAllowed() {
        return !this.isTablePerClass() && !this.isAbstract();
    }

    protected boolean buildDiscriminatorValueIsUndefined() {
        return this.isTablePerClass() || this.isAbstract() || this.isRootNoDescendantsNoStrategyDefined();
    }

    protected boolean buildSpecifiedDiscriminatorColumnIsAllowed() {
        return !this.isTablePerClass() && this.isRoot();
    }

    protected boolean buildDiscriminatorColumnIsUndefined() {
        return this.isTablePerClass() || this.isRootNoDescendantsNoStrategyDefined();
    }

    protected boolean buildSpecifiedTableIsAllowed() {
        return !this.isAbstractTablePerClass() && !this.isSingleTableDescendant();
    }

    protected boolean buildTableIsUndefined() {
        return this.isAbstractTablePerClass();
    }

    protected void updateInheritance(Inheritance inheritanceResource) {
        this.setSpecifiedInheritanceStrategy_(this.getResourceInheritanceStrategy(inheritanceResource));
        this.setDefaultInheritanceStrategy(this.buildDefaultInheritanceStrategy());
    }

    protected void updateRootEntity() {
        this.rootEntity = this.calculateRootEntity();
        if (this.rootEntity != this) {
            this.rootEntity.addSubEntity(this);
        }
    }

    protected Entity calculateRootEntity() {
        Entity root = this;
        Iterator<TypeMapping> stream = this.inheritanceHierarchy();
        while (stream.hasNext()) {
            TypeMapping typeMapping = stream.next();
            if (!(typeMapping instanceof Entity)) continue;
            root = (Entity)typeMapping;
        }
        return root;
    }

    @Override
    public void addSubEntity(Entity subEntity) {
        this.getPersistenceUnit().addRootEntityWithSubEntities(this.getName());
    }

    protected void updateSpecifiedSecondaryTables() {
        CloneIterator xmlTables = new CloneIterator(((XmlEntity)this.resourceTypeMapping).getSecondaryTables());
        ListIterator<OrmSecondaryTable> contextTables = this.specifiedSecondaryTables();
        while (contextTables.hasNext()) {
            OrmSecondaryTable contextTable = (OrmSecondaryTable)contextTables.next();
            if (xmlTables.hasNext()) {
                contextTable.update((XmlSecondaryTable)xmlTables.next());
                continue;
            }
            this.removeSpecifiedSecondaryTable_(contextTable);
        }
        while (xmlTables.hasNext()) {
            this.addSpecifiedSecondaryTable(this.buildSecondaryTable((XmlSecondaryTable)xmlTables.next()));
        }
    }

    protected void updateVirtualSecondaryTables() {
        ListIterator<OrmSecondaryTable> secondaryTables = this.virtualSecondaryTables();
        ListIterator<JavaSecondaryTable> javaSecondaryTables = EmptyListIterator.instance();
        if (this.getJavaEntity() != null && !this.isMetadataComplete() && this.specifiedSecondaryTablesSize() == 0) {
            javaSecondaryTables = this.getJavaEntity().secondaryTables();
        }
        while (secondaryTables.hasNext()) {
            OrmSecondaryTable virtualSecondaryTable = secondaryTables.next();
            if (javaSecondaryTables.hasNext()) {
                JavaSecondaryTable javaSecondaryTable = javaSecondaryTables.next();
                virtualSecondaryTable.update(new VirtualXmlSecondaryTable(javaSecondaryTable));
                continue;
            }
            this.removeVirtualSecondaryTable(virtualSecondaryTable);
        }
        while (javaSecondaryTables.hasNext()) {
            JavaSecondaryTable javaSecondaryTable = (JavaSecondaryTable)javaSecondaryTables.next();
            this.addVirtualSecondaryTable(this.buildVirtualSecondaryTable(javaSecondaryTable));
        }
    }

    protected OrmSecondaryTable buildSecondaryTable(XmlSecondaryTable xmlSecondaryTable) {
        return this.getXmlContextNodeFactory().buildOrmSecondaryTable(this, xmlSecondaryTable);
    }

    protected OrmSecondaryTable buildVirtualSecondaryTable(JavaSecondaryTable javaSecondaryTable) {
        return this.buildSecondaryTable(new VirtualXmlSecondaryTable(javaSecondaryTable));
    }

    protected InheritanceType getResourceInheritanceStrategy(Inheritance inheritanceResource) {
        if (inheritanceResource == null) {
            return null;
        }
        return InheritanceType.fromOrmResourceModel(inheritanceResource.getStrategy());
    }

    protected InheritanceType buildDefaultInheritanceStrategy() {
        if (this.getResourceInheritance() == null && !this.isMetadataComplete() && this.getJavaEntity() != null) {
            return this.getJavaEntity().getInheritanceStrategy();
        }
        return this.isRoot() ? InheritanceType.SINGLE_TABLE : this.getRootEntity().getInheritanceStrategy();
    }

    protected void updateSpecifiedPrimaryKeyJoinColumns() {
        CloneIterator xmlPkJoinColumns = new CloneIterator(((XmlEntity)this.resourceTypeMapping).getPrimaryKeyJoinColumns());
        ListIterator<OrmPrimaryKeyJoinColumn> contextPkJoinColumns = this.specifiedPrimaryKeyJoinColumns();
        while (contextPkJoinColumns.hasNext()) {
            OrmPrimaryKeyJoinColumn contextPkJoinColumn = (OrmPrimaryKeyJoinColumn)contextPkJoinColumns.next();
            if (xmlPkJoinColumns.hasNext()) {
                contextPkJoinColumn.update((XmlPrimaryKeyJoinColumn)xmlPkJoinColumns.next());
                continue;
            }
            this.removeSpecifiedPrimaryKeyJoinColumn_(contextPkJoinColumn);
        }
        while (xmlPkJoinColumns.hasNext()) {
            this.addSpecifiedPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn((XmlPrimaryKeyJoinColumn)xmlPkJoinColumns.next()));
        }
    }

    protected void updateDefaultPrimaryKeyJoinColumns() {
        ListIterator<OrmPrimaryKeyJoinColumn> defaultPkJoinColumns = this.defaultPrimaryKeyJoinColumns();
        ListIterator<JavaPrimaryKeyJoinColumn> javaPkJoinColumns = EmptyListIterator.instance();
        if (this.getJavaEntity() != null && !this.isMetadataComplete() && this.specifiedPrimaryKeyJoinColumnsSize() == 0) {
            javaPkJoinColumns = this.getJavaEntity().primaryKeyJoinColumns();
        }
        while (defaultPkJoinColumns.hasNext()) {
            OrmPrimaryKeyJoinColumn defaultPkJoinColumn = defaultPkJoinColumns.next();
            if (javaPkJoinColumns.hasNext()) {
                JavaPrimaryKeyJoinColumn javaPkJoinColumn = javaPkJoinColumns.next();
                defaultPkJoinColumn.update(new VirtualXmlPrimaryKeyJoinColumn(javaPkJoinColumn));
                continue;
            }
            if (this.defaultPrimaryKeyJoinColumnsSize() == 1) {
                defaultPkJoinColumn.update(null);
                continue;
            }
            this.removeDefaultPrimaryKeyJoinColumn(defaultPkJoinColumn);
        }
        while (javaPkJoinColumns.hasNext()) {
            JavaPrimaryKeyJoinColumn javaPkJoinColumn = (JavaPrimaryKeyJoinColumn)javaPkJoinColumns.next();
            this.addDefaultPrimaryKeyJoinColumn(this.buildVirtualPrimaryKeyJoinColumn(javaPkJoinColumn));
        }
        if (this.defaultPrimaryKeyJoinColumnsSize() == 0 && this.specifiedPrimaryKeyJoinColumnsSize() == 0) {
            this.addDefaultPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn(null));
        }
    }

    protected OrmPrimaryKeyJoinColumn buildVirtualPrimaryKeyJoinColumn(JavaPrimaryKeyJoinColumn javaSecondaryTable) {
        return this.buildPrimaryKeyJoinColumn(new VirtualXmlPrimaryKeyJoinColumn(javaSecondaryTable));
    }

    protected OrmPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(XmlPrimaryKeyJoinColumn resourcePkJoinColumn) {
        return this.getXmlContextNodeFactory().buildOrmPrimaryKeyJoinColumn(this, this.createPrimaryKeyJoinColumnOwner(), resourcePkJoinColumn);
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return AbstractJavaEntity.getPrimaryKeyColumnName(this);
    }

    @Override
    public PersistentAttribute getIdAttribute() {
        Iterable<AttributeMapping> idAttributeMappings = this.getAllAttributeMappings("id");
        if (CollectionTools.size(idAttributeMappings) != 1) {
            return null;
        }
        return idAttributeMappings.iterator().next().getPersistentAttribute();
    }

    @Override
    public void addToResourceModel(XmlEntityMappings entityMappings) {
        entityMappings.getEntities().add((Object)((XmlEntity)this.resourceTypeMapping));
    }

    @Override
    public void removeFromResourceModel(XmlEntityMappings entityMappings) {
        entityMappings.getEntities().remove((Object)this.resourceTypeMapping);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validatePrimaryKey(messages, reporter);
        this.validateTable(messages, reporter);
        ListIterator<OrmSecondaryTable> stream = this.secondaryTables();
        while (stream.hasNext()) {
            ((OrmSecondaryTable)stream.next()).validate(messages, reporter);
        }
        this.validateInheritance(messages, reporter);
        this.generatorContainer.validate(messages, reporter);
        this.queryContainer.validate(messages, reporter);
        this.attributeOverrideContainer.validate(messages, reporter);
        this.associationOverrideContainer.validate(messages, reporter);
    }

    protected void validatePrimaryKey(List<IMessage> messages, IReporter reporter) {
        this.buildPrimaryKeyValidator().validate(messages, reporter);
    }

    protected PrimaryKeyValidator buildPrimaryKeyValidator() {
        return new GenericEntityPrimaryKeyValidator(this, this.buildTextRangeResolver());
    }

    protected PrimaryKeyTextRangeResolver buildTextRangeResolver() {
        return new OrmEntityTextRangeResolver(this);
    }

    protected void validateTable(List<IMessage> messages, IReporter reporter) {
        if (this.isAbstractTablePerClass()) {
            if (this.table.isResourceSpecified()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_ABSTRACT_TABLE_PER_CLASS_DEFINES_TABLE", new String[]{this.getName()}, this, this.getTable().getValidationTextRange()));
            }
            return;
        }
        if (this.isSingleTableDescendant()) {
            if (this.table.isResourceSpecified()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_SINGLE_TABLE_DESCENDANT_DEFINES_TABLE", new String[]{this.getName()}, this, this.getTable().getValidationTextRange()));
            }
            return;
        }
        this.table.validate(messages, reporter);
    }

    protected void validateInheritance(List<IMessage> messages, IReporter reporter) {
        this.validateInheritanceStrategy(messages);
        this.validateDiscriminatorColumn(messages, reporter);
        this.validateDiscriminatorValue(messages);
    }

    protected void validateDiscriminatorColumn(List<IMessage> messages, IReporter reporter) {
        if (this.specifiedDiscriminatorColumnIsAllowed() && !this.discriminatorColumnIsUndefined()) {
            this.getDiscriminatorColumn().validate(messages, reporter);
        } else if (this.getDiscriminatorColumn().isResourceSpecified()) {
            if (!this.isRoot()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NON_ROOT_DISCRIMINATOR_COLUMN_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorColumnTextRange()));
            } else if (this.isTablePerClass()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_COLUMN_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorColumnTextRange()));
            }
        }
    }

    protected void validateDiscriminatorValue(List<IMessage> messages) {
        if (this.discriminatorValueIsUndefined() && this.getSpecifiedDiscriminatorValue() != null) {
            if (this.isAbstract()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_ABSTRACT_DISCRIMINATOR_VALUE_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorValueTextRange()));
            } else if (this.isTablePerClass()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_TABLE_PER_CLASS_DISCRIMINATOR_VALUE_DEFINED", new String[]{this.getName()}, this, this.getDiscriminatorValueTextRange()));
            }
        }
    }

    protected void validateInheritanceStrategy(List<IMessage> messages) {
        JpaPlatformVariation.Supported tablePerConcreteClassInheritanceIsSupported = this.getJpaPlatformVariation().getTablePerConcreteClassInheritanceIsSupported();
        if (tablePerConcreteClassInheritanceIsSupported == JpaPlatformVariation.Supported.YES) {
            return;
        }
        if (this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS && this.isRoot()) {
            if (tablePerConcreteClassInheritanceIsSupported == JpaPlatformVariation.Supported.NO) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_TABLE_PER_CLASS_NOT_SUPPORTED_ON_PLATFORM", new String[]{this.getName()}, this, this.getInheritanceStrategyTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "ENTITY_TABLE_PER_CLASS_NOT_PORTABLE_ON_PLATFORM", new String[]{this.getName()}, this, this.getInheritanceStrategyTextRange()));
            }
        }
    }

    protected TextRange getDiscriminatorValueTextRange() {
        return ((XmlEntity)this.resourceTypeMapping).getDiscriminatorValueTextRange();
    }

    protected TextRange getDiscriminatorColumnTextRange() {
        return ((XmlEntity)this.resourceTypeMapping).getDiscriminatorColumn().getValidationTextRange();
    }

    protected TextRange getInheritanceStrategyTextRange() {
        return ((XmlEntity)this.resourceTypeMapping).getInheritanceStrategyTextRange();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AssociationOverrideContainerOwner
    implements OrmAssociationOverrideContainer.Owner {
        protected AssociationOverrideContainerOwner() {
        }

        @Override
        public OrmTypeMapping getTypeMapping() {
            return AbstractOrmEntity.this.getTypeMapping();
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractOrmEntity.this.getOverridableTypeMapping();
        }

        @Override
        public Iterator<String> allOverridableNames() {
            TypeMapping typeMapping = this.getOverridableTypeMapping();
            return typeMapping == null ? EmptyIterator.instance() : typeMapping.allOverridableAssociationNames();
        }

        @Override
        public EList<XmlAssociationOverride> getResourceAssociationOverrides() {
            return ((XmlEntity)AbstractOrmEntity.this.resourceTypeMapping).getAssociationOverrides();
        }

        @Override
        public RelationshipReference resolveRelationshipReference(String associationOverrideName) {
            RelationshipReference relationshipReference;
            JavaPersistentType javaPersistentType;
            if (!AbstractOrmEntity.this.isMetadataComplete() && (javaPersistentType = AbstractOrmEntity.this.getPersistentType().getJavaPersistentType()) != null && (relationshipReference = javaPersistentType.getMapping().resolveRelationshipReference(associationOverrideName)) != null) {
                return relationshipReference;
            }
            return MappingTools.resolveRelationshipReference(this.getOverridableTypeMapping(), associationOverrideName);
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return AbstractOrmEntity.this.tableNameIsInvalid(tableName);
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return AbstractOrmEntity.this.associatedTableNamesIncludingInherited();
        }

        @Override
        public org.eclipse.jpt.db.Table getDbTable(String tableName) {
            return AbstractOrmEntity.this.getDbTable(tableName);
        }

        @Override
        public String getDefaultTableName() {
            return AbstractOrmEntity.this.getPrimaryTableName();
        }

        @Override
        public IMessage buildColumnTableNotValidMessage(BaseOverride override, BaseColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualOverrideColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
        }

        protected IMessage buildVirtualOverrideColumnTableNotValidMessage(String overrideName, BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_TABLE_NOT_VALID", new String[]{overrideName, column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
        }

        @Override
        public IMessage buildColumnUnresolvedNameMessage(BaseOverride override, NamedColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualColumnUnresolvedNameMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualColumnUnresolvedNameMessage(String overrideName, NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_NAME", new String[]{overrideName, column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        @Override
        public IMessage buildColumnUnresolvedReferencedColumnNameMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualColumnUnresolvedReferencedColumnNameMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME", new String[]{column.getReferencedColumnName(), column.getReferencedColumnDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualColumnUnresolvedReferencedColumnNameMessage(String overrideName, BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME", new String[]{overrideName, column.getReferencedColumnName(), column.getReferencedColumnDbTable().getName()}, column, textRange);
        }

        @Override
        public IMessage buildUnspecifiedNameMultipleJoinColumnsMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualUnspecifiedNameMultipleJoinColumnsMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[0], column, textRange);
        }

        protected IMessage buildVirtualUnspecifiedNameMultipleJoinColumnsMessage(String overrideName, BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[]{overrideName}, column, textRange);
        }

        @Override
        public IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[0], column, textRange);
        }

        protected IMessage buildVirtualUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(String overrideName, BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[]{overrideName}, column, textRange);
        }

        @Override
        public TextRange getValidationTextRange() {
            return AbstractOrmEntity.this.getValidationTextRange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AttributeOverrideContainerOwner
    implements OrmAttributeOverrideContainer.Owner {
        protected AttributeOverrideContainerOwner() {
        }

        @Override
        public OrmTypeMapping getTypeMapping() {
            return AbstractOrmEntity.this.getTypeMapping();
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractOrmEntity.this.getOverridableTypeMapping();
        }

        @Override
        public Iterator<String> allOverridableNames() {
            TypeMapping typeMapping = this.getOverridableTypeMapping();
            return typeMapping == null ? EmptyIterator.instance() : this.allOverridableAttributeNames_(typeMapping);
        }

        protected Iterator allOverridableAttributeNames_(TypeMapping typeMapping) {
            HashBag mappedByRelationshipAttributes = CollectionTools.collection((Iterator)new TransformationIterator<SingleRelationshipMapping2_0, String>(this.getMapsIdRelationships()){

                protected String transform(SingleRelationshipMapping2_0 next) {
                    return next.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getValue();
                }
            });
            return new FilteringIterator<String>(typeMapping.allOverridableAttributeNames(), (Collection)mappedByRelationshipAttributes){
                private final /* synthetic */ Collection val$mappedByRelationshipAttributes;
                {
                    this.val$mappedByRelationshipAttributes = collection;
                    super($anonymous0);
                }

                protected boolean accept(String o) {
                    if (this.val$mappedByRelationshipAttributes.isEmpty()) {
                        return true;
                    }
                    String qualifier = o.indexOf(46) > 0 ? o.substring(0, o.indexOf(46)) : o;
                    return !this.val$mappedByRelationshipAttributes.contains(qualifier);
                }
            };
        }

        protected Iterable<SingleRelationshipMapping2_0> getMapsIdRelationships() {
            return new FilteringIterable<SingleRelationshipMapping2_0>((Iterable)new SubIterableWrapper((Iterable)new CompositeIterable(new Iterable[]{this.getTypeMapping().getAllAttributeMappings("oneToOne"), this.getTypeMapping().getAllAttributeMappings("manyToOne")}))){

                protected boolean accept(SingleRelationshipMapping2_0 o) {
                    return o.getDerivedIdentity().usesMapsIdDerivedIdentityStrategy();
                }
            };
        }

        @Override
        public EList<XmlAttributeOverride> getResourceAttributeOverrides() {
            return ((XmlEntity)AbstractOrmEntity.this.resourceTypeMapping).getAttributeOverrides();
        }

        @Override
        public Column resolveOverriddenColumn(String attributeOverrideName) {
            Column column;
            JavaPersistentType javaPersistentType;
            if (!AbstractOrmEntity.this.isMetadataComplete() && (javaPersistentType = AbstractOrmEntity.this.getPersistentType().getJavaPersistentType()) != null && (column = javaPersistentType.getMapping().resolveOverriddenColumn(attributeOverrideName)) != null) {
                return column;
            }
            return MappingTools.resolveOverridenColumn(this.getOverridableTypeMapping(), attributeOverrideName);
        }

        @Override
        public XmlColumn buildVirtualXmlColumn(Column overridableColumn, String attributeName, boolean isMetadataComplete) {
            JavaAttributeOverride javaAttributeOverride = null;
            if (!isMetadataComplete) {
                javaAttributeOverride = AbstractOrmEntity.this.getJavaAttributeOverrideNamed(attributeName);
            }
            if (javaAttributeOverride == null) {
                if (overridableColumn instanceof JavaColumn) {
                    return new VirtualXmlColumn(AbstractOrmEntity.this, overridableColumn);
                }
                return new VirtualXmlAttributeOverrideColumn(overridableColumn);
            }
            return new VirtualXmlColumn(AbstractOrmEntity.this, javaAttributeOverride.getColumn());
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return AbstractOrmEntity.this.tableNameIsInvalid(tableName);
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return AbstractOrmEntity.this.associatedTableNamesIncludingInherited();
        }

        @Override
        public org.eclipse.jpt.db.Table getDbTable(String tableName) {
            return AbstractOrmEntity.this.getDbTable(tableName);
        }

        @Override
        public String getDefaultTableName() {
            return AbstractOrmEntity.this.getPrimaryTableName();
        }

        @Override
        public IMessage buildColumnUnresolvedNameMessage(BaseOverride override, NamedColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualColumnUnresolvedNameMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        public IMessage buildVirtualColumnUnresolvedNameMessage(String overrideName, NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME", new String[]{overrideName, column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        @Override
        public IMessage buildColumnTableNotValidMessage(BaseOverride override, BaseColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualOverrideColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
        }

        protected IMessage buildVirtualOverrideColumnTableNotValidMessage(String overrideName, BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID", new String[]{overrideName, column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
        }

        @Override
        public TextRange getValidationTextRange() {
            return AbstractOrmEntity.this.getValidationTextRange();
        }
    }

    protected class PrimaryKeyJoinColumnOwner
    implements OrmBaseJoinColumn.Owner {
        protected PrimaryKeyJoinColumnOwner() {
        }

        public TypeMapping getTypeMapping() {
            return AbstractOrmEntity.this;
        }

        public String getDefaultTableName() {
            return AbstractOrmEntity.this.getPrimaryTableName();
        }

        public org.eclipse.jpt.db.Table getDbTable(String tableName) {
            return AbstractOrmEntity.this.getDbTable(tableName);
        }

        public org.eclipse.jpt.db.Table getReferencedColumnDbTable() {
            Entity parentEntity = AbstractOrmEntity.this.getParentEntity();
            return parentEntity == null ? null : parentEntity.getPrimaryDbTable();
        }

        public int joinColumnsSize() {
            return AbstractOrmEntity.this.primaryKeyJoinColumnsSize();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return AbstractOrmEntity.this.defaultPrimaryKeyJoinColumns.contains(joinColumn);
        }

        public String getDefaultColumnName() {
            if (this.joinColumnsSize() != 1) {
                return null;
            }
            Entity parentEntity = AbstractOrmEntity.this.getParentEntity();
            return parentEntity == null ? AbstractOrmEntity.this.getPrimaryKeyColumnName() : parentEntity.getPrimaryKeyColumnName();
        }

        public TextRange getValidationTextRange() {
            return null;
        }

        public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
            throw new UnsupportedOperationException("validation not supported yet: bug 148262");
        }

        public IMessage buildUnresolvedReferencedColumnNameMessage(BaseJoinColumn column, TextRange textRange) {
            throw new UnsupportedOperationException("validation not supported yet: bug 148262");
        }

        public IMessage buildUnspecifiedNameMultipleJoinColumnsMessage(BaseJoinColumn column, TextRange textRange) {
            throw new UnsupportedOperationException("validation not supported yet: bug 148262");
        }

        public IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(BaseJoinColumn column, TextRange textRange) {
            throw new UnsupportedOperationException("validation not supported yet: bug 148262");
        }
    }
}

