/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmAttributeOverrideContainer
extends AbstractOrmXmlContextNode
implements OrmAttributeOverrideContainer {
    protected final List<OrmAttributeOverride> specifiedAttributeOverrides;
    protected final List<OrmAttributeOverride> virtualAttributeOverrides;
    protected final OrmAttributeOverrideContainer.Owner owner;

    public GenericOrmAttributeOverrideContainer(XmlContextNode parent, OrmAttributeOverrideContainer.Owner owner) {
        super(parent);
        this.owner = owner;
        this.specifiedAttributeOverrides = new ArrayList<OrmAttributeOverride>();
        this.virtualAttributeOverrides = new ArrayList<OrmAttributeOverride>();
        this.initializeSpecifiedAttributeOverrides();
        this.initializeVirtualAttributeOverrides();
    }

    @Override
    public void initializeFromAttributeOverrideContainer(OrmAttributeOverrideContainer oldContainer) {
        int index = 0;
        for (OrmAttributeOverride attributeOverride : CollectionTools.iterable(oldContainer.specifiedAttributeOverrides())) {
            OrmAttributeOverride newAttributeOverride = this.addSpecifiedAttributeOverride(index++);
            newAttributeOverride.setName(attributeOverride.getName());
            newAttributeOverride.getColumn().initializeFrom(attributeOverride.getColumn());
        }
    }

    protected OrmAttributeOverrideContainer.Owner getOwner() {
        return this.owner;
    }

    protected EList<XmlAttributeOverride> getResourceAttributeOverrides() {
        return this.getOwner().getResourceAttributeOverrides();
    }

    @Override
    public ListIterator<OrmAttributeOverride> attributeOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAttributeOverrides(), this.virtualAttributeOverrides()});
    }

    @Override
    public int attributeOverridesSize() {
        return this.specifiedAttributeOverridesSize() + this.virtualAttributeOverridesSize();
    }

    @Override
    public ListIterator<OrmAttributeOverride> virtualAttributeOverrides() {
        return new CloneListIterator(this.virtualAttributeOverrides);
    }

    @Override
    public int virtualAttributeOverridesSize() {
        return this.virtualAttributeOverrides.size();
    }

    protected void addVirtualAttributeOverride(OrmAttributeOverride attributeOverride) {
        this.addItemToList(attributeOverride, this.virtualAttributeOverrides, "virtualAttributeOverrides");
    }

    protected void removeVirtualAttributeOverride(OrmAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.virtualAttributeOverrides, "virtualAttributeOverrides");
    }

    protected OrmAttributeOverride setAttributeOverrideVirtual(boolean virtual, OrmAttributeOverride attributeOverride) {
        if (virtual) {
            return this.setAttributeOverrideVirtual(attributeOverride);
        }
        return this.setAttributeOverrideSpecified(attributeOverride);
    }

    protected OrmAttributeOverride setAttributeOverrideVirtual(OrmAttributeOverride attributeOverride) {
        int index = this.specifiedAttributeOverrides.indexOf(attributeOverride);
        this.specifiedAttributeOverrides.remove(index);
        String attributeOverrideName = attributeOverride.getName();
        OrmAttributeOverride virtualAttributeOverride = null;
        if (attributeOverrideName != null) {
            for (String name : CollectionTools.iterable(this.allOverridableAttributeNames())) {
                if (!name.equals(attributeOverrideName)) continue;
                virtualAttributeOverride = this.buildVirtualAttributeOverride(name);
                this.virtualAttributeOverrides.add(virtualAttributeOverride);
            }
        }
        this.getResourceAttributeOverrides().remove(index);
        this.fireItemRemoved("specifiedAttributeOverrides", index, attributeOverride);
        if (virtualAttributeOverride != null) {
            this.fireItemAdded("virtualAttributeOverrides", this.virtualAttributeOverridesSize() - 1, virtualAttributeOverride);
        }
        return virtualAttributeOverride;
    }

    protected OrmAttributeOverride setAttributeOverrideSpecified(OrmAttributeOverride oldAttributeOverride) {
        int index = this.specifiedAttributeOverridesSize();
        XmlAttributeOverride xmlAttributeOverride = OrmFactory.eINSTANCE.createXmlAttributeOverride();
        OrmAttributeOverride newAttributeOverride = this.buildAttributeOverride(xmlAttributeOverride);
        this.specifiedAttributeOverrides.add(index, newAttributeOverride);
        this.getResourceAttributeOverrides().add((Object)xmlAttributeOverride);
        int defaultIndex = this.virtualAttributeOverrides.indexOf(oldAttributeOverride);
        this.virtualAttributeOverrides.remove(defaultIndex);
        newAttributeOverride.setName(oldAttributeOverride.getName());
        newAttributeOverride.getColumn().setSpecifiedName(oldAttributeOverride.getColumn().getName());
        this.fireItemRemoved("virtualAttributeOverrides", defaultIndex, oldAttributeOverride);
        this.fireItemAdded("specifiedAttributeOverrides", index, newAttributeOverride);
        return newAttributeOverride;
    }

    @Override
    public ListIterator<OrmAttributeOverride> specifiedAttributeOverrides() {
        return new CloneListIterator(this.specifiedAttributeOverrides);
    }

    @Override
    public int specifiedAttributeOverridesSize() {
        return this.specifiedAttributeOverrides.size();
    }

    protected OrmAttributeOverride addSpecifiedAttributeOverride(int index) {
        XmlAttributeOverride xmlAttributeOverride = OrmFactory.eINSTANCE.createXmlAttributeOverride();
        OrmAttributeOverride attributeOverride = this.buildAttributeOverride(xmlAttributeOverride);
        this.specifiedAttributeOverrides.add(index, attributeOverride);
        this.getResourceAttributeOverrides().add(index, (Object)xmlAttributeOverride);
        this.fireItemAdded("specifiedAttributeOverrides", index, attributeOverride);
        return attributeOverride;
    }

    protected void addSpecifiedAttributeOverride(int index, OrmAttributeOverride attributeOverride) {
        this.addItemToList(index, attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverrides");
    }

    protected void addSpecifiedAttributeOverride(OrmAttributeOverride attributeOverride) {
        this.addSpecifiedAttributeOverride(this.specifiedAttributeOverrides.size(), attributeOverride);
    }

    protected void removeSpecifiedAttributeOverride_(OrmAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverrides");
    }

    @Override
    public void moveSpecifiedAttributeOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAttributeOverrides, (int)targetIndex, (int)sourceIndex);
        this.getResourceAttributeOverrides().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedAttributeOverrides", targetIndex, sourceIndex);
    }

    @Override
    public OrmAttributeOverride getAttributeOverrideNamed(String name) {
        return (OrmAttributeOverride)this.getOverrideNamed(name, this.attributeOverrides());
    }

    public boolean containsAttributeOverride(String name) {
        return this.containsOverride(name, this.attributeOverrides());
    }

    public boolean containsDefaultAttributeOverride(String name) {
        return this.containsOverride(name, this.virtualAttributeOverrides());
    }

    public boolean containsSpecifiedAttributeOverride(String name) {
        return this.containsOverride(name, this.specifiedAttributeOverrides());
    }

    private BaseOverride getOverrideNamed(String name, ListIterator<? extends BaseOverride> overrides) {
        for (BaseOverride override : CollectionTools.iterable(overrides)) {
            String overrideName = override.getName();
            if (overrideName == null && name == null) {
                return override;
            }
            if (overrideName == null || !overrideName.equals(name)) continue;
            return override;
        }
        return null;
    }

    private boolean containsOverride(String name, ListIterator<? extends BaseOverride> overrides) {
        return this.getOverrideNamed(name, overrides) != null;
    }

    protected Iterator<String> allOverridableAttributeNames() {
        return this.getOwner().allOverridableNames();
    }

    protected void initializeVirtualAttributeOverrides() {
        for (String name : CollectionTools.iterable(this.allOverridableAttributeNames())) {
            OrmAttributeOverride ormAttributeOverride = this.getAttributeOverrideNamed(name);
            if (ormAttributeOverride != null) continue;
            this.virtualAttributeOverrides.add(this.buildVirtualAttributeOverride(name));
        }
    }

    protected void initializeSpecifiedAttributeOverrides() {
        for (XmlAttributeOverride attributeOverride : this.getResourceAttributeOverrides()) {
            this.specifiedAttributeOverrides.add(this.buildAttributeOverride(attributeOverride));
        }
    }

    @Override
    public void update() {
        this.updateSpecifiedAttributeOverrides();
        this.updateVirtualAttributeOverrides();
    }

    protected OrmAttributeOverride buildVirtualAttributeOverride(String name) {
        return this.buildAttributeOverride(this.buildVirtualXmlAttributeOverride(name));
    }

    protected XmlAttributeOverride buildVirtualXmlAttributeOverride(String name) {
        Column column = this.resolveOverriddenColumn(name);
        XmlColumn xmlColumn = this.getOwner().buildVirtualXmlColumn(column, name, this.getOwner().getTypeMapping().isMetadataComplete());
        return new VirtualXmlAttributeOverride(name, xmlColumn);
    }

    private Column resolveOverriddenColumn(String attributeOverrideName) {
        return this.getOwner().resolveOverriddenColumn(attributeOverrideName);
    }

    protected void updateSpecifiedAttributeOverrides() {
        CloneIterator xmlOverrides = new CloneIterator(this.getResourceAttributeOverrides());
        ListIterator<OrmAttributeOverride> contextOverrides = this.specifiedAttributeOverrides();
        while (contextOverrides.hasNext()) {
            OrmAttributeOverride contextOverride = (OrmAttributeOverride)contextOverrides.next();
            if (xmlOverrides.hasNext()) {
                contextOverride.update((XmlAttributeOverride)xmlOverrides.next());
                continue;
            }
            this.removeSpecifiedAttributeOverride_(contextOverride);
        }
        while (xmlOverrides.hasNext()) {
            this.addSpecifiedAttributeOverride(this.buildAttributeOverride((XmlAttributeOverride)xmlOverrides.next()));
        }
    }

    protected void updateVirtualAttributeOverrides() {
        Iterator<String> overridableAttributes = this.allOverridableAttributeNames();
        ListIterator<OrmAttributeOverride> virtualAttributeOverridesCopy = this.virtualAttributeOverrides();
        for (String name : CollectionTools.iterable(overridableAttributes)) {
            OrmAttributeOverride ormAttributeOverride = this.getAttributeOverrideNamed(name);
            if (ormAttributeOverride != null && !ormAttributeOverride.isVirtual()) continue;
            if (ormAttributeOverride != null) {
                if (virtualAttributeOverridesCopy.hasNext()) {
                    OrmAttributeOverride virtualAttributeOverride = virtualAttributeOverridesCopy.next();
                    virtualAttributeOverride.update(this.buildVirtualXmlAttributeOverride(name));
                    continue;
                }
                this.addVirtualAttributeOverride(this.buildVirtualAttributeOverride(name));
                continue;
            }
            this.addVirtualAttributeOverride(this.buildVirtualAttributeOverride(name));
        }
        for (OrmAttributeOverride virtualAttributeOverride : CollectionTools.iterable(virtualAttributeOverridesCopy)) {
            this.removeVirtualAttributeOverride(virtualAttributeOverride);
        }
    }

    protected OrmAttributeOverride buildAttributeOverride(XmlAttributeOverride attributeOverride) {
        return this.getXmlContextNodeFactory().buildOrmAttributeOverride(this, this.createAttributeOverrideOwner(), attributeOverride);
    }

    protected AttributeOverride.Owner createAttributeOverrideOwner() {
        return new AttributeOverrideOwner();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        ListIterator<OrmAttributeOverride> stream = this.attributeOverrides();
        while (stream.hasNext()) {
            ((OrmAttributeOverride)stream.next()).validate(messages, reporter);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getOwner().getValidationTextRange();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AttributeOverrideOwner
    implements AttributeOverride.Owner {
        protected AttributeOverrideOwner() {
        }

        @Override
        public Column resolveOverriddenColumn(String attributeName) {
            if (attributeName == null) {
                return null;
            }
            return GenericOrmAttributeOverrideContainer.this.resolveOverriddenColumn(attributeName);
        }

        @Override
        public boolean isVirtual(BaseOverride override) {
            return GenericOrmAttributeOverrideContainer.this.virtualAttributeOverrides.contains(override);
        }

        @Override
        public BaseOverride setVirtual(boolean virtual, BaseOverride override) {
            return GenericOrmAttributeOverrideContainer.this.setAttributeOverrideVirtual(virtual, (OrmAttributeOverride)override);
        }

        @Override
        public TypeMapping getTypeMapping() {
            return GenericOrmAttributeOverrideContainer.this.getOwner().getTypeMapping();
        }

        @Override
        public Iterator<String> allOverridableAttributeNames() {
            return GenericOrmAttributeOverrideContainer.this.allOverridableAttributeNames();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return GenericOrmAttributeOverrideContainer.this.getOwner().tableNameIsInvalid(tableName);
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return GenericOrmAttributeOverrideContainer.this.getOwner().candidateTableNames();
        }

        @Override
        public String getDefaultTableName() {
            return GenericOrmAttributeOverrideContainer.this.getOwner().getDefaultTableName();
        }

        @Override
        public Table getDbTable(String tableName) {
            return GenericOrmAttributeOverrideContainer.this.getOwner().getDbTable(tableName);
        }

        @Override
        public IMessage buildColumnTableNotValidMessage(BaseOverride override, BaseColumn column, TextRange textRange) {
            return GenericOrmAttributeOverrideContainer.this.getOwner().buildColumnTableNotValidMessage(override, column, textRange);
        }

        @Override
        public IMessage buildColumnUnresolvedNameMessage(BaseOverride override, NamedColumn column, TextRange textRange) {
            return GenericOrmAttributeOverrideContainer.this.getOwner().buildColumnUnresolvedNameMessage(override, column, textRange);
        }
    }
}

