/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.display;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptDebugUIPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.text.JavaScriptSourceViewerConfiguration;

public class JavaScriptDebugViewerConfiguration
extends JavaScriptSourceViewerConfiguration {
    public JavaScriptDebugViewerConfiguration() {
        super(JavaScriptPlugin.getDefault().getJavaTextTools().getColorManager(), (IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{PreferenceConstants.getPreferenceStore(), EditorsUI.getPreferenceStore()}), null, null);
    }

    public IPreferenceStore getTextPreferenceStore() {
        return this.fPreferenceStore;
    }

    public IContentAssistProcessor getProcessor() {
        return null;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor(this.getProcessor(), "__dftl_partition_content_type");
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        ITextDoubleClickStrategy clickStrat = new ITextDoubleClickStrategy(){

            public void doubleClicked(ITextViewer viewer) {
                try {
                    IDocument doc = viewer.getDocument();
                    int caretOffset = viewer.getSelectedRange().x;
                    int lineNum = doc.getLineOfOffset(caretOffset);
                    int start = doc.getLineOffset(lineNum);
                    int length = doc.getLineLength(lineNum);
                    viewer.setSelectedRange(start, length);
                }
                catch (BadLocationException e) {
                    JavaScriptDebugUIPlugin.log(e);
                }
            }
        };
        return clickStrat;
    }
}

