/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.WSDLSelectionConditionCommand;
import org.eclipse.wst.command.internal.env.core.common.Condition;
import org.eclipse.wst.command.internal.env.ui.common.TimedOperation;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class TimedWSDLSelectionConditionCommand
extends AbstractDataModelOperation
implements Condition {
    private final String TIMEOUT_PREFERENCE = "wsdlTimeOut";
    private WSDLSelectionConditionCommand selectionCommand = new WSDLSelectionConditionCommand();
    private int timeOutValue;

    public TimedWSDLSelectionConditionCommand() {
        IPreferenceStore prefStore = WebServiceConsumptionUIPlugin.getInstance().getPreferenceStore();
        this.timeOutValue = prefStore.getDefaultString("wsdlTimeOut").equals("") ? 10000 : prefStore.getInt("wsdlTimeOut");
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.selectionCommand.setWebServicesParser(webServicesParser);
    }

    public WebServicesParser getWebServicesParser() {
        return this.selectionCommand.getWebServicesParser();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        String timeOutMessage = ConsumptionUIMessages.bind((String)ConsumptionUIMessages.MSG_INFO_WSDL_OPERATION_TIMED_OUT, (Object)this.getWebServiceURI());
        TimedOperation timedOperation = new TimedOperation((AbstractOperation)this.selectionCommand, this.timeOutValue, timeOutMessage);
        return timedOperation.execute(monitor, adaptable);
    }

    public boolean evaluate() {
        return this.selectionCommand.evaluate();
    }

    public String getWebServiceURI() {
        return this.selectionCommand.getWebServiceURI();
    }

    public void setWebServiceURI(String webServiceURI) {
        this.selectionCommand.setWebServiceURI(webServiceURI);
    }

    public String getWsdlURI() {
        return this.getWebServiceURI();
    }

    public String getHttpBasicAuthPassword() {
        return this.selectionCommand.getHttpBasicAuthPassword();
    }

    public String getHttpBasicAuthUsername() {
        return this.selectionCommand.getHttpBasicAuthUsername();
    }
}

