/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.core.jsdi.Location;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.BreakpointRequest;
import org.eclipse.wst.jsdt.debug.internal.core.breakpoints.JavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;

public class JavaScriptLineBreakpoint
extends JavaScriptBreakpoint
implements IJavaScriptLineBreakpoint {
    public static final String CONDITION = "org.eclipse.wst.jsdt.debug.core.condition";
    public static final String CONDITION_ENABLED = "org.eclipse.wst.jsdt.debug.core.condition_enabled";
    public static final String CONDITION_SUSPEND_ON_TRUE = "org.eclipse.wst.jsdt.debug.core.condition_suspend_on_true";

    public JavaScriptLineBreakpoint() {
    }

    public JavaScriptLineBreakpoint(final IResource resource, final int linenumber, final int charstart, final int charend, final Map attributes, final boolean register) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JavaScriptLineBreakpoint.this.setMarker(resource.createMarker("org.eclipse.wst.jsdt.debug.core.line.breakpoint.marker"));
                attributes.put("org.eclipse.debug.core.id", JavaScriptLineBreakpoint.this.getModelIdentifier());
                attributes.put("org.eclipse.debug.core.enabled", true);
                attributes.put("lineNumber", new Integer(linenumber));
                attributes.put("charStart", new Integer(charstart));
                attributes.put("charEnd", new Integer(charend));
                JavaScriptLineBreakpoint.this.ensureMarker().setAttributes(attributes);
                JavaScriptLineBreakpoint.this.register(register);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    protected boolean createRequest(JavaScriptDebugTarget target, ScriptReference script) throws CoreException {
        Location loc = script.lineLocation(this.getLineNumber());
        if (loc == null) {
            this.decrementInstallCount();
            return false;
        }
        BreakpointRequest request = target.getEventRequestManager().createBreakpointRequest(loc);
        this.registerRequest(target, request);
        this.configureRequest(request);
        request.setEnabled(this.isEnabled());
        return true;
    }

    protected void configureRequest(BreakpointRequest request) throws CoreException {
        super.configureRequest(request);
        request.addConditionFilter(this.getCondition());
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public boolean isConditionEnabled() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION_ENABLED, false);
    }

    public boolean isConditionSuspendOnTrue() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION_SUSPEND_ON_TRUE, true);
    }

    public void setConditionSuspendOnTrue(boolean suspendontrue) throws CoreException {
        if (suspendontrue != this.isConditionSuspendOnTrue()) {
            this.setAttribute(CONDITION_SUSPEND_ON_TRUE, suspendontrue);
            this.handleBreakpointChange();
        }
    }

    public void setCondition(String condition) throws CoreException {
        if (condition != null && condition.length() == 0) {
            this.setAttribute(CONDITION, null);
        } else {
            this.setAttribute(CONDITION, condition);
        }
        this.handleBreakpointChange();
    }

    public String getCondition() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION, null);
    }

    public void setConditionEnabled(boolean enabled) throws CoreException {
        if (this.isConditionEnabled() != enabled) {
            this.setAttribute(CONDITION_ENABLED, enabled);
            this.handleBreakpointChange();
        }
    }
}

