/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.eval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptStackFrame;

public class EvaluationManager
implements IDebugContextListener,
IWindowListener {
    public static final String DEBUGGER_ACTIVE = "org.eclipse.wst.jsdt.debug.ui.jsdebuggerActive";
    private static EvaluationManager instance = null;
    private IWorkbenchWindow activewindow = null;
    private HashMap contextmap = null;
    static /* synthetic */ Class class$0;

    private EvaluationManager() {
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
    }

    public static synchronized EvaluationManager getManager() {
        if (instance == null) {
            instance = new EvaluationManager();
        }
        return instance;
    }

    public void start() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            instance.windowOpened(windows[i]);
            ++i;
        }
        workbench.addWindowListener((IWindowListener)this);
        EvaluationManager.instance.activewindow = workbench.getActiveWorkbenchWindow();
    }

    public void stop() {
        DebugUITools.getDebugContextManager().removeDebugContextListener((IDebugContextListener)this);
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
    }

    public IJavaScriptStackFrame getEvaluationContext(IWorkbenchWindow window) {
        ArrayList otherwindows = new ArrayList();
        if (window == null) {
            return this.getEvaluationContext(this.activewindow, otherwindows);
        }
        return this.getEvaluationContext(window, otherwindows);
    }

    public IJavaScriptStackFrame getEvaluationContext(IWorkbenchPart part) {
        IWorkbenchPage page = part.getSite().getPage();
        IJavaScriptStackFrame frame = this.getContext(page);
        if (frame == null) {
            return this.getEvaluationContext(page.getWorkbenchWindow());
        }
        return frame;
    }

    IJavaScriptStackFrame getEvaluationContext(IWorkbenchWindow window, List otherwindows) {
        IWorkbenchPage activePage = window.getActivePage();
        IJavaScriptStackFrame frame = null;
        if (activePage != null) {
            frame = this.getContext(activePage);
        }
        if (frame == null) {
            IWorkbenchPage[] pages = window.getPages();
            int i = 0;
            while (i < pages.length) {
                if (activePage != pages[i] && (frame = this.getContext(pages[i])) != null) {
                    return frame;
                }
                ++i;
            }
            otherwindows.add(window);
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i2 = 0;
            while (i2 < windows.length) {
                if (!otherwindows.contains(windows[i2]) && (frame = this.getEvaluationContext(windows[i2], otherwindows)) != null) {
                    return frame;
                }
                ++i2;
            }
            return null;
        }
        return frame;
    }

    IJavaScriptStackFrame getContext(IWorkbenchPage page) {
        if (this.contextmap != null) {
            return (IJavaScriptStackFrame)this.contextmap.get(page);
        }
        return null;
    }

    public void debugContextChanged(DebugContextEvent event) {
        IWorkbenchPart part;
        if ((event.getFlags() & 1) > 0 && (part = event.getDebugContextProvider().getPart()) != null) {
            Object element;
            IStructuredSelection ss;
            IWorkbenchPage page = part.getSite().getPage();
            ISelection selection = event.getContext();
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IAdaptable) {
                IJavaScriptStackFrame frame;
                IAdaptable iAdaptable = (IAdaptable)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.debug.core.model.IJavaScriptStackFrame");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((frame = (IJavaScriptStackFrame)iAdaptable.getAdapter((Class)clazz)) != null) {
                    this.setContext(page, frame);
                    return;
                }
            }
            this.removeContext(page);
        }
    }

    private synchronized void setContext(IWorkbenchPage page, IJavaScriptStackFrame frame) {
        if (this.contextmap == null) {
            this.contextmap = new HashMap();
        }
        this.contextmap.put(page, frame);
        System.setProperty(DEBUGGER_ACTIVE, "true");
    }

    private void removeContext(IWorkbenchPage page) {
        if (this.contextmap != null) {
            this.contextmap.remove(page);
            if (this.contextmap.isEmpty()) {
                System.setProperty(DEBUGGER_ACTIVE, "false");
            }
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
        this.activewindow = window;
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }
}

