/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPluginResourceHandler;

public class LibCopyBuilder
extends IncrementalProjectBuilder {
    static boolean DEBUG = false;
    public static final String BUILDER_ID = "org.eclipse.jst.j2ee.LibCopyBuilder";
    public static final String IMPORTED_CLASSES_PATH = "imported_classes";
    private List sourceContainers;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    private void copyAllClassFolders(IProgressMonitor monitor, IFolder[] classFolders, IFolder outputFolder) throws CoreException {
        int i = 0;
        while (i < classFolders.length) {
            if (!classFolders[i].equals((Object)outputFolder)) {
                this.copyClassFiles(classFolders[i], outputFolder, monitor);
            }
            ++i;
        }
    }

    protected void processDelta(IResourceDelta delta, final IFolder outputFolder, final IProgressMonitor monitor, final IFolder[] classesFolders) {
        if (DEBUG) {
            System.out.println(BUILDER_ID + J2EEPluginResourceHandler.__Considering_delta_INFO_ + delta);
        }
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){
            private List copiedClassFolders;
            {
                this.copiedClassFolders = new ArrayList(iFolderArray.length);
            }

            public boolean visit(IResourceDelta subdelta) throws CoreException {
                IResource resource = subdelta.getResource();
                if (resource.getType() == 1) {
                    IFolder classesFolder = LibCopyBuilder.this.retrieveClassesFolder(resource, classesFolders);
                    if (classesFolder != null && !this.copiedClassFolders.contains(classesFolder)) {
                        int kind = subdelta.getKind();
                        switch (kind) {
                            case 1: 
                            case 4: {
                                if (DEBUG) {
                                    System.out.println(LibCopyBuilder.BUILDER_ID + J2EEPluginResourceHandler.__Delta_build_INFO_ + subdelta);
                                }
                                LibCopyBuilder.this.copyClassFiles(classesFolder, outputFolder, monitor);
                                break;
                            }
                            case 2: {
                                LibCopyBuilder.this.deleteCorrespondingFile((IFile)resource, classesFolder, outputFolder, monitor);
                                break;
                            }
                            case 8: {
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else if (resource.getType() == 2 && resource.equals((Object)outputFolder)) {
                    LibCopyBuilder.this.copyAllClassFolders(null, classesFolders, outputFolder);
                    return false;
                }
                return true;
            }
        };
        if (delta != null) {
            try {
                delta.accept(visitor);
            }
            catch (CoreException coreException) {}
        }
    }

    protected void deleteCorrespondingFile(IFile file, IFolder classesFolder, IFolder outputFolder, IProgressMonitor monitor) throws CoreException {
        IPath path = file.getFullPath();
        int segCount = classesFolder.getFullPath().segmentCount();
        IFile javaFile = this.findCorrespondingJavaFile(path = path.removeFirstSegments(segCount));
        if (javaFile != null && javaFile.exists()) {
            return;
        }
        IFile outFile = outputFolder.getFile(path);
        if (outFile.exists()) {
            outFile.delete(true, false, monitor);
        }
    }

    protected IFolder retrieveClassesFolder(IResource resource, IFolder[] classesFolders) {
        int i = 0;
        while (i < classesFolders.length) {
            if (classesFolders[i].getName().equals(resource.getProjectRelativePath().segment(0))) {
                return classesFolders[i];
            }
            ++i;
        }
        return null;
    }

    private void copyClassFiles(IFolder source, IFolder dest, IProgressMonitor monitor) throws CoreException {
        if (DEBUG) {
            System.out.println("org.eclipse.jst.j2ee.LibCopyBuilder: Begin copying class files from " + source.getFullPath() + " to " + dest.getFullPath());
        }
        int sourcePathLength = source.getFullPath().segmentCount();
        try {
            class Visitor
            implements IResourceVisitor {
                private final /* synthetic */ int val$sourcePathLength;
                private final /* synthetic */ IFolder val$dest;
                private final /* synthetic */ IProgressMonitor val$monitor;

                Visitor(int n, IFolder iFolder, IProgressMonitor iProgressMonitor) {
                    this.val$sourcePathLength = n;
                    this.val$dest = iFolder;
                    this.val$monitor = iProgressMonitor;
                }

                public boolean visit(IResource res) throws CoreException {
                    if (res.getType() == 1) {
                        IFile file = (IFile)res;
                        IPath filePath = file.getFullPath();
                        IPath dpath = filePath.removeFirstSegments(this.val$sourcePathLength);
                        IFile targetFile = this.val$dest.getFile(dpath);
                        LibCopyBuilder.this.copyFile(file, targetFile, dpath, this.val$monitor);
                    }
                    return true;
                }
            }
            source.accept((IResourceVisitor)new Visitor(sourcePathLength, dest, monitor));
        }
        catch (CoreException coreException) {}
    }

    private void copyFile(IFile source, IFile dest, IPath fileRelativePath, IProgressMonitor monitor) throws CoreException {
        IContainer parent;
        if (this.pruneForJavaSource(source, fileRelativePath, monitor)) {
            return;
        }
        File sourceFile = null;
        File destFile = null;
        if (source.exists()) {
            sourceFile = source.getLocation().toFile();
        }
        if (dest.exists()) {
            destFile = dest.getLocation().toFile();
        }
        if (destFile != null && sourceFile != null) {
            if (DEBUG) {
                System.out.println("org.eclipse.jst.j2ee.LibCopyBuilder: " + dest.getFullPath() + " already exists.");
            }
            if (destFile.lastModified() == sourceFile.lastModified()) {
                return;
            }
            dest.setContents(source.getContents(false), true, false, monitor);
            this.synchronizeModificationStamps(sourceFile, destFile);
            return;
        }
        if (DEBUG) {
            System.out.println("org.eclipse.jst.j2ee.LibCopyBuilder: Creating " + dest.getFullPath());
        }
        if ((parent = dest.getParent()).getType() == 2) {
            this.mkdirs((IFolder)parent, monitor);
        }
        dest.create(source.getContents(false), false, monitor);
        destFile = dest.getLocation().toFile();
        this.synchronizeModificationStamps(sourceFile, destFile);
        dest.setDerived(true);
    }

    private boolean pruneForJavaSource(IFile classFile, IPath fileRelativePath, IProgressMonitor monitor) throws CoreException {
        IFile javaFile;
        if (classFile.exists() && (javaFile = this.findCorrespondingJavaFile(fileRelativePath)) != null && javaFile.exists()) {
            ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{javaFile}, null);
            classFile.delete(true, false, monitor);
            return true;
        }
        return false;
    }

    private IFile findCorrespondingJavaFile(IPath classFilePath) {
        IPath javaPath = this.convertToJavaPath(classFilePath);
        List sourceFolders = this.getSourceContainers();
        int i = 0;
        while (i < sourceFolders.size()) {
            IContainer cont = (IContainer)sourceFolders.get(i);
            IFile javaFile = cont.getFile(javaPath);
            if (javaFile.exists()) {
                return javaFile;
            }
            ++i;
        }
        return null;
    }

    private List getSourceContainers() {
        if (this.sourceContainers == null) {
            this.sourceContainers = JemProjectUtilities.getSourceContainers((IProject)this.getProject());
        }
        return this.sourceContainers;
    }

    private IPath convertToJavaPath(IPath classFilePath) {
        IPath javaPath = classFilePath.removeFileExtension();
        String fileName = classFilePath.lastSegment();
        int innerIndex = fileName.indexOf(36);
        if (innerIndex > -1) {
            javaPath = javaPath.removeLastSegments(1);
            javaPath = javaPath.append(fileName.substring(0, innerIndex));
        }
        javaPath = javaPath.addFileExtension("java");
        return javaPath;
    }

    private void synchronizeModificationStamps(File sourceFile, File destFile) {
        if (destFile != null && sourceFile != null) {
            destFile.setLastModified(sourceFile.lastModified());
        }
    }

    private void mkdirs(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (folder.exists()) {
            return;
        }
        IContainer parent = folder.getParent();
        if (!parent.exists() && parent.getType() == 2) {
            this.mkdirs((IFolder)parent, monitor);
        }
        folder.create(false, true, monitor);
    }
}

