/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.internal.DeleteServerDialog;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;

public class DeleteAction
extends AbstractServerAction {
    protected IServer[] servers;
    protected IFolder[] configs;

    public DeleteAction(Shell shell, ISelectionProvider sp) {
        super(shell, sp, Messages.actionDelete);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public boolean accept(IServer server) {
        this.servers = new IServer[]{server};
        ArrayList<IFolder> list = new ArrayList<IFolder>();
        int size = this.servers.length;
        int i = 0;
        while (i < size) {
            if (this.servers[i].isReadOnly()) {
                return false;
            }
            if (this.servers[i].getServerConfiguration() != null) {
                list.add(this.servers[i].getServerConfiguration());
            }
            ++i;
        }
        IServer[] servers2 = ServerCore.getServers();
        if (servers2 != null) {
            int size2 = servers2.length;
            int j = 0;
            while (j < size2) {
                IFolder folder;
                boolean found = false;
                int i2 = 0;
                while (i2 < size) {
                    if (this.servers[i2].equals(servers2[j])) {
                        found = true;
                    }
                    ++i2;
                }
                if (!found && (folder = servers2[j].getServerConfiguration()) != null && list.contains(folder)) {
                    list.remove(folder);
                }
                ++j;
            }
        }
        this.configs = new IFolder[list.size()];
        list.toArray(this.configs);
        return true;
    }

    public void perform(IServer server) {
        DeleteServerDialog dsd = new DeleteServerDialog(this.shell, this.servers, this.configs);
        dsd.open();
    }
}

