/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.hyperlink;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.hyperlink.ExternalFileHyperlink;
import org.eclipse.wst.xml.ui.internal.hyperlink.URLStorageHyperlink;
import org.eclipse.wst.xml.ui.internal.hyperlink.WorkspaceFileHyperlink;

class CatalogEntryHyperlink
implements IHyperlink {
    private IRegion fHyperlinkRegion = null;
    private ICatalogEntry fEntry = null;

    CatalogEntryHyperlink(IRegion hyperlinkRegion, ICatalogEntry entry) {
        this.fHyperlinkRegion = hyperlinkRegion;
        this.fEntry = entry;
    }

    private IHyperlink getHyperlink() {
        if (this.fEntry.getURI().startsWith("file:")) {
            return new ExternalFileHyperlink(this.fHyperlinkRegion, new File(this.fEntry.getURI().substring(5)));
        }
        if (this.fEntry.getURI().startsWith("platform:/resource/")) {
            Path path = new Path(this.fEntry.getURI().substring(20));
            if (path.segmentCount() > 1) {
                return new WorkspaceFileHyperlink(this.fHyperlinkRegion, ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path));
            }
        } else {
            try {
                if (this.fEntry.getURI().startsWith("jar:file:")) {
                    return new URLStorageHyperlink(this.fHyperlinkRegion, new URL(this.fEntry.getURI())){

                        public String getHyperlinkText() {
                            return NLS.bind((String)XMLUIMessages.Open, (Object)CatalogEntryHyperlink.this.fEntry.getKey());
                        }
                    };
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public IRegion getHyperlinkRegion() {
        return this.fHyperlinkRegion;
    }

    public String getHyperlinkText() {
        IHyperlink link = this.getHyperlink();
        if (link != null) {
            return link.getHyperlinkText();
        }
        return NLS.bind((String)XMLUIMessages.Open, (Object)this.fEntry.getKey());
    }

    public String getTypeLabel() {
        IHyperlink link = this.getHyperlink();
        if (link != null) {
            return link.getTypeLabel();
        }
        return null;
    }

    public void open() {
        IHyperlink link = this.getHyperlink();
        if (link != null) {
            link.open();
        }
    }
}

