/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.symbols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.el.AbstractDTVariableResolver;
import org.eclipse.jst.jsf.designtime.el.DefaultDTVariableResolver;
import org.eclipse.jst.jsf.designtime.el.IDecorativeResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigBasedDTVariableResolver
extends DefaultDTVariableResolver {
    @Override
    public ISymbol[] getAllVariables(DTFacesContext facesContext, IAdaptable externalContextKey) {
        HashMap<String, ISymbol> allSymbols = new HashMap<String, ISymbol>();
        ISymbol[] superSymbols = super.getAllVariables(facesContext, externalContextKey);
        ISymbol[] iSymbolArray = superSymbols;
        int n = superSymbols.length;
        int n2 = 0;
        while (n2 < n) {
            ISymbol superSymbol = iSymbolArray[n2];
            allSymbols.put(superSymbol.getName(), superSymbol);
            ++n2;
        }
        if (JSFCorePlugin.hasDecorativeVariableResolvers()) {
            IProject project = this.getProject(facesContext);
            List<AbstractDTVariableResolver> resolvers = this.retrieveDecorativeVariableResolvers(project);
            for (AbstractDTVariableResolver resolver : resolvers) {
                ISymbol[] otherSymbols;
                ISymbol[] iSymbolArray2 = otherSymbols = resolver.getAllVariables(facesContext, externalContextKey);
                int n3 = otherSymbols.length;
                int n4 = 0;
                while (n4 < n3) {
                    ISymbol otherSymbol = iSymbolArray2[n4];
                    allSymbols.put(otherSymbol.getName(), otherSymbol);
                    ++n4;
                }
            }
        }
        return allSymbols.values().toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
    }

    @Override
    public ISymbol resolveVariable(DTFacesContext context, String name, IAdaptable externalContextKey) {
        if (JSFCorePlugin.hasDecorativeVariableResolvers()) {
            IProject project = this.getProject(context);
            List<AbstractDTVariableResolver> resolvers = this.retrieveDecorativeVariableResolvers(project);
            int i = resolvers.size() - 1;
            while (i >= 0) {
                ISymbol symbol = resolvers.get(i).resolveVariable(context, name, externalContextKey);
                if (symbol != null) {
                    return symbol;
                }
                --i;
            }
        }
        ISymbol symbol = super.resolveVariable(context, name, externalContextKey);
        return symbol;
    }

    private List<AbstractDTVariableResolver> retrieveDecorativeVariableResolvers(IProject project) {
        IJSFAppConfigManager manager = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance(project);
        List<String> variableResolvers = manager.getVariableResolvers();
        ArrayList<AbstractDTVariableResolver> resolvers = new ArrayList<AbstractDTVariableResolver>();
        for (String variableResolver : variableResolvers) {
            List<String> ids = JSFCorePlugin.getVariableResolversForName(variableResolver);
            for (String id : ids) {
                AbstractDTVariableResolver resolver = JSFCorePlugin.getVariableResolvers(id).getInstance(project);
                if (resolver instanceof IDecorativeResolver) {
                    resolvers.add(resolver);
                    continue;
                }
                JSFCorePlugin.log(new Exception(), String.format("resolver %s must implement the IDecorativeResolver interface to be used", id));
            }
        }
        return resolvers;
    }

    private IProject getProject(DTFacesContext facesContext) {
        IResource res = facesContext.adaptContextObject();
        if (res != null) {
            return res.getProject();
        }
        return null;
    }
}

