/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.mapping;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.viewmapping.AttributeToPropertyMapping;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.viewmapping.TagMapping;

public class ViewMetadataLoader {
    private final IProject _project;
    private final Map<String, ITaglibDomainMetaDataModelContext> _metadataContexts;

    public ViewMetadataLoader(IProject project) {
        this._project = project;
        this._metadataContexts = new HashMap<String, ITaglibDomainMetaDataModelContext>();
    }

    public TagMapping getTagToViewMapping(TagIdentifier tagId) {
        Trait trait;
        ITaglibDomainMetaDataModelContext modelContext = this.createMetadataContext(tagId.getUri());
        Entity entity = TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)modelContext, (String)tagId.getTagName());
        if (entity != null && (trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)"viewElementMapping")) != null) {
            return (TagMapping)trait.getValue();
        }
        return null;
    }

    private ITaglibDomainMetaDataModelContext createMetadataContext(String uri) {
        ITaglibDomainMetaDataModelContext modelContext = this._metadataContexts.get(uri);
        if (modelContext == null) {
            modelContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)this._project, (String)uri);
            this._metadataContexts.put(uri, modelContext);
        }
        return modelContext;
    }

    public AttributeToPropertyMapping getAttributeMapping(TagIdentifier tagId, String name) {
        Trait trait;
        ITaglibDomainMetaDataModelContext modelContext = this.createMetadataContext(tagId.getUri());
        Entity entity = TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)modelContext, (String)(String.valueOf(tagId.getTagName()) + "/" + name));
        if (entity != null && (trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)"attributeMapping")) != null) {
            return (AttributeToPropertyMapping)trait.getValue();
        }
        return null;
    }
}

