/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import javax.wsdl.Definition;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.util.WSDLCopier;

public class CopyWSDLTreeCommand
extends AbstractDataModelOperation {
    private String wsdlURI;
    private WebServicesParser webServicesParser;
    private String destinationURI;
    private Definition def;
    private String wsdlRelPath;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        try {
            WSDLCopier copier = new WSDLCopier(this.webServicesParser);
            copier.setSourceURI(this.wsdlURI, this.def);
            copier.setTargetFolderURI(this.getBaseURI(this.destinationURI));
            copier.setTargetFilename(this.getLocalname(this.destinationURI));
            ResourceUtils.getWorkspace().run((IWorkspaceRunnable)copier, monitor);
            this.wsdlRelPath = copier.getRelativePath().toString();
            return Status.OK_STATUS;
        }
        catch (CoreException ce) {
            IStatus status = ce.getStatus();
            env.getStatusHandler().reportError(status);
            return status;
        }
    }

    private String getBaseURI(String uri) {
        int index = uri.lastIndexOf(47);
        if (index == -1) {
            index = uri.lastIndexOf(92);
        }
        if (index != -1) {
            return uri.substring(0, index + 1);
        }
        return null;
    }

    private String getLocalname(String uri) {
        int index = uri.lastIndexOf(47);
        if (index == -1) {
            index = uri.lastIndexOf(92);
        }
        if (index != -1) {
            return uri.substring(index + 1);
        }
        return uri;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public void setDestinationURI(String destinationURI) {
        this.destinationURI = destinationURI;
    }

    public void setDefinition(Definition def) {
        this.def = def;
    }

    public String getWSDLRelPath() {
        return this.wsdlRelPath;
    }
}

