/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import java.util.ListIterator;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinTable;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.details.InverseJoinColumnInJoinTableDialog;
import org.eclipse.jpt.ui.internal.details.InverseJoinColumnInJoinTableStateObject;
import org.eclipse.jpt.ui.internal.details.JoinColumnsComposite;
import org.eclipse.jpt.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.jpt.ui.internal.details.ReferenceTableComposite;
import org.eclipse.jpt.ui.internal.details.db.CatalogCombo;
import org.eclipse.jpt.ui.internal.details.db.SchemaCombo;
import org.eclipse.jpt.ui.internal.details.db.TableCombo;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.utility.internal.model.value.CachingTransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ReadOnlyWritablePropertyValueModelWrapper;
import org.eclipse.jpt.utility.internal.model.value.ValueListAdapter;
import org.eclipse.jpt.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinTableComposite
extends ReferenceTableComposite<JoinTable> {
    private Button overrideDefaultInverseJoinColumnsCheckBox;
    private JoinColumnsComposite<JoinTable> inverseJoinColumnsComposite;

    public JoinTableComposite(Pane<?> parentPane, PropertyValueModel<? extends JoinTable> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    public JoinTableComposite(PropertyValueModel<? extends JoinTable> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    @Override
    protected boolean isParentVirtual(JoinTable joinTable) {
        return joinTable.getParent().getRelationshipReference().isParentVirtual();
    }

    @Override
    protected void initializeLayout(Composite container) {
        int groupBoxMargin = this.getGroupBoxMargin();
        TableCombo tableCombo = this.addTableCombo(container);
        Composite tablePane = this.addPane(container, groupBoxMargin);
        this.addLabeledComposite(tablePane, JptUiDetailsMessages.JoinTableComposite_name, (Control)tableCombo.getControl(), "org.eclipse.jpt.ui.mapping_joinTableName");
        SchemaCombo schemaCombo = this.addSchemaCombo(container);
        this.addLabeledComposite(tablePane, JptUiDetailsMessages.JoinTableComposite_schema, (Control)schemaCombo.getControl(), "org.eclipse.jpt.ui.mapping_joinTableSchema");
        CatalogCombo catalogCombo = this.addCatalogCombo(container);
        this.addLabeledComposite(tablePane, JptUiDetailsMessages.JoinTableComposite_catalog, (Control)catalogCombo.getControl(), "org.eclipse.jpt.ui.mapping_joinTableCatalog");
        Group joinColumnGroupPane = this.addTitledGroup(container, JptUiDetailsMessages.JoinTableComposite_joinColumn);
        this.overrideDefaultJoinColumnsCheckBox = this.addCheckBox(this.addSubPane((Composite)joinColumnGroupPane, 8), JptUiDetailsMessages.JoinTableComposite_overrideDefaultJoinColumns, this.buildOverrideDefaultJoinColumnHolder(), null);
        this.joinColumnsComposite = new JoinColumnsComposite<JoinTable>(this, (Composite)joinColumnGroupPane, this.buildJoinColumnsEditor());
        this.installJoinColumnsPaneEnabler(this.joinColumnsComposite);
        Group inverseJoinColumnGroupPane = this.addTitledGroup(container, JptUiDetailsMessages.JoinTableComposite_inverseJoinColumn);
        this.overrideDefaultInverseJoinColumnsCheckBox = this.addCheckBox(this.addSubPane((Composite)inverseJoinColumnGroupPane, 8), JptUiDetailsMessages.JoinTableComposite_overrideDefaultInverseJoinColumns, this.buildOverrideDefaultInverseJoinColumnHolder(), null);
        this.inverseJoinColumnsComposite = new JoinColumnsComposite<JoinTable>(this, (Composite)inverseJoinColumnGroupPane, this.buildInverseJoinColumnsEditor());
        this.installInverseJoinColumnsPaneEnabler(this.inverseJoinColumnsComposite);
    }

    private void installInverseJoinColumnsPaneEnabler(JoinColumnsComposite<JoinTable> pane) {
        pane.installJoinColumnsPaneEnabler((PropertyValueModel<Boolean>)new InverseJoinColumnPaneEnablerHolder());
    }

    private void addInverseJoinColumn(JoinTable joinTable) {
        InverseJoinColumnInJoinTableDialog dialog = new InverseJoinColumnInJoinTableDialog(this.getShell(), joinTable, null);
        dialog.openDialog(this.buildAddInverseJoinColumnPostExecution());
    }

    private void addInverseJoinColumnFromDialog(InverseJoinColumnInJoinTableStateObject stateObject) {
        JoinTable subject = (JoinTable)this.getSubject();
        int index = subject.specifiedInverseJoinColumnsSize();
        JoinColumn joinColumn = subject.addSpecifiedInverseJoinColumn(index);
        stateObject.updateJoinColumn((BaseJoinColumn)joinColumn);
        this.setSelectedInverseJoinColumn(joinColumn);
    }

    private void setSelectedInverseJoinColumn(JoinColumn joinColumn) {
        this.inverseJoinColumnsComposite.setSelectedJoinColumn(joinColumn);
    }

    private PostExecution<InverseJoinColumnInJoinTableDialog> buildAddInverseJoinColumnPostExecution() {
        return new PostExecution<InverseJoinColumnInJoinTableDialog>(){

            @Override
            public void execute(InverseJoinColumnInJoinTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    JoinTableComposite.this.addInverseJoinColumnFromDialog((InverseJoinColumnInJoinTableStateObject)((Object)dialog.getSubject()));
                }
            }
        };
    }

    private PostExecution<InverseJoinColumnInJoinTableDialog> buildEditInverseJoinColumnPostExecution() {
        return new PostExecution<InverseJoinColumnInJoinTableDialog>(){

            @Override
            public void execute(InverseJoinColumnInJoinTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    JoinTableComposite.this.editInverseJoinColumn((InverseJoinColumnInJoinTableStateObject)((Object)dialog.getSubject()));
                }
            }
        };
    }

    private InverseJoinColumnsProvider buildInverseJoinColumnsEditor() {
        return new InverseJoinColumnsProvider();
    }

    private WritablePropertyValueModel<Boolean> buildOverrideDefaultInverseJoinColumnHolder() {
        return new OverrideDefaultInverseJoinColumnHolder();
    }

    private ListValueModel<JoinColumn> buildSpecifiedInverseJoinColumnsListHolder() {
        return new ListAspectAdapter<JoinTable, JoinColumn>(this.getSubjectHolder(), new String[]{"specifiedInverseJoinColumns"}){

            protected ListIterator<JoinColumn> listIterator_() {
                return ((JoinTable)this.subject).specifiedInverseJoinColumns();
            }

            protected int size_() {
                return ((JoinTable)this.subject).specifiedInverseJoinColumnsSize();
            }
        };
    }

    private void editInverseJoinColumn(InverseJoinColumnInJoinTableStateObject stateObject) {
        stateObject.updateJoinColumn((BaseJoinColumn)stateObject.getJoinColumn());
    }

    private void editInverseJoinColumn(JoinColumn joinColumn) {
        InverseJoinColumnInJoinTableDialog dialog = new InverseJoinColumnInJoinTableDialog(this.getShell(), (JoinTable)this.getSubject(), joinColumn);
        dialog.openDialog(this.buildEditInverseJoinColumnPostExecution());
    }

    private void updateInverseJoinColumns() {
        if (this.isPopulating()) {
            return;
        }
        JoinTable joinTable = (JoinTable)this.getSubject();
        if (joinTable == null) {
            return;
        }
        boolean selected = this.overrideDefaultInverseJoinColumnsCheckBox.getSelection();
        this.setPopulating(true);
        try {
            if (selected) {
                joinTable.convertDefaultToSpecifiedInverseJoinColumn();
                this.setSelectedInverseJoinColumn((JoinColumn)joinTable.specifiedInverseJoinColumns().next());
            } else {
                joinTable.clearSpecifiedInverseJoinColumns();
            }
        }
        finally {
            this.setPopulating(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InverseJoinColumnPaneEnablerHolder
    extends CachingTransformationPropertyValueModel<JoinTable, Boolean> {
        private StateChangeListener stateChangeListener;

        public InverseJoinColumnPaneEnablerHolder() {
            super((PropertyValueModel)new ValueListAdapter((WritablePropertyValueModel)new ReadOnlyWritablePropertyValueModelWrapper(JoinTableComposite.this.getSubjectHolder()), new String[]{"specifiedInverseJoinColumns"}));
            this.stateChangeListener = this.buildStateChangeListener();
        }

        private StateChangeListener buildStateChangeListener() {
            return new StateChangeListener(){

                public void stateChanged(StateChangeEvent event) {
                    InverseJoinColumnPaneEnablerHolder.this.valueStateChanged(event);
                }
            };
        }

        private void valueStateChanged(StateChangeEvent event) {
            Object oldValue = this.cachedValue;
            Object newValue = this.transformNew((JoinTable)this.valueHolder.getValue());
            this.firePropertyChanged("value", oldValue, newValue);
        }

        protected Boolean transform(JoinTable value) {
            if (value == null) {
                return false;
            }
            return (Boolean)super.transform((Object)value);
        }

        protected Boolean transform_(JoinTable value) {
            boolean virtual = JoinTableComposite.this.isParentVirtual(value);
            return !virtual && value.specifiedInverseJoinColumnsSize() > 0;
        }

        protected void engageModel() {
            super.engageModel();
            this.valueHolder.addStateChangeListener(this.stateChangeListener);
        }

        protected void disengageModel() {
            this.valueHolder.removeStateChangeListener(this.stateChangeListener);
            super.disengageModel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InverseJoinColumnsProvider
    implements JoinColumnsComposite.JoinColumnsEditor<JoinTable> {
        private InverseJoinColumnsProvider() {
        }

        @Override
        public void addJoinColumn(JoinTable subject) {
            JoinTableComposite.this.addInverseJoinColumn(subject);
        }

        @Override
        public JoinColumn getDefaultJoinColumn(JoinTable subject) {
            return subject.getDefaultInverseJoinColumn();
        }

        @Override
        public String getDefaultPropertyName() {
            return "defaultInverseJoinColumn";
        }

        @Override
        public void editJoinColumn(JoinTable subject, JoinColumn joinColumn) {
            JoinTableComposite.this.editInverseJoinColumn(joinColumn);
        }

        @Override
        public boolean hasSpecifiedJoinColumns(JoinTable subject) {
            return subject.hasSpecifiedInverseJoinColumns();
        }

        @Override
        public void removeJoinColumns(JoinTable subject, int[] selectedIndices) {
            int index = selectedIndices.length;
            while (--index >= 0) {
                subject.removeSpecifiedInverseJoinColumn(selectedIndices[index]);
            }
        }

        @Override
        public ListIterator<JoinColumn> specifiedJoinColumns(JoinTable subject) {
            return subject.specifiedInverseJoinColumns();
        }

        @Override
        public int specifiedJoinColumnsSize(JoinTable subject) {
            return subject.specifiedInverseJoinColumnsSize();
        }

        @Override
        public String getSpecifiedJoinColumnsListPropertyName() {
            return "specifiedInverseJoinColumns";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OverrideDefaultInverseJoinColumnHolder
    extends ListPropertyValueModelAdapter<Boolean>
    implements WritablePropertyValueModel<Boolean> {
        public OverrideDefaultInverseJoinColumnHolder() {
            super(JoinTableComposite.this.buildSpecifiedInverseJoinColumnsListHolder());
        }

        protected Boolean buildValue() {
            return this.listHolder.size() > 0;
        }

        public void setValue(Boolean value) {
            JoinTableComposite.this.updateInverseJoinColumns();
        }
    }
}

