/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.details.JpaComposite;
import org.eclipse.jpt.ui.internal.Tracing;
import org.eclipse.jpt.ui.internal.details.AbstractJpaDetailsPage;
import org.eclipse.jpt.ui.internal.util.ControlSwitcher;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.model.value.FilteringPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistentAttributeDetailsPage<T extends PersistentAttribute>
extends AbstractJpaDetailsPage<T> {
    private Map<String, JpaComposite> mappingComposites;
    private PageBook mappingPageBook;
    private PropertyValueModel<AttributeMapping> mappingHolder;

    protected PersistentAttributeDetailsPage(Composite parent, WidgetFactory widgetFactory) {
        super(parent, widgetFactory);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.mappingComposites = new HashMap<String, JpaComposite>();
    }

    protected PageBook buildMappingPageBook(Composite parent) {
        this.mappingPageBook = new PageBook(parent, 0);
        this.mappingPageBook.showPage((Control)this.addLabel((Composite)this.mappingPageBook, ""));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.mappingPageBook.setLayoutData((Object)gridData);
        this.mappingHolder = this.buildMappingHolder();
        new ControlSwitcher(this.mappingHolder, this.buildPaneTransformer(), this.mappingPageBook);
        return this.mappingPageBook;
    }

    private Transformer<AttributeMapping, Control> buildPaneTransformer() {
        return new Transformer<AttributeMapping, Control>(){

            public Control transform(AttributeMapping attributeMapping) {
                if (attributeMapping == null) {
                    return null;
                }
                return PersistentAttributeDetailsPage.this.getMappingComposite(attributeMapping.getKey()).getControl();
            }
        };
    }

    protected JpaComposite getMappingComposite(String key) {
        JpaComposite composite = this.mappingComposites.get(key);
        if (composite != null) {
            return composite;
        }
        composite = this.buildMappingComposite(this.mappingPageBook, key);
        if (composite != null) {
            this.mappingComposites.put(key, composite);
        }
        return composite;
    }

    protected JpaComposite buildMappingComposite(PageBook pageBook, String key) {
        return this.getJpaPlatformUi().buildAttributeMappingComposite(((PersistentAttribute)this.getSubject()).getResourceType(), key, (Composite)pageBook, this.buildMappingHolder(key), this.getWidgetFactory());
    }

    private PropertyValueModel<AttributeMapping> buildMappingHolder(String key) {
        return new FilteringPropertyValueModel(this.mappingHolder, this.buildMappingFilter(key));
    }

    private Filter<AttributeMapping> buildMappingFilter(String mappingKey) {
        return new MappingFilter(mappingKey);
    }

    private WritablePropertyValueModel<AttributeMapping> buildMappingHolder() {
        return new PropertyAspectAdapter<T, AttributeMapping>(this.getSubjectHolder(), new String[]{"defaultMapping", "specifiedMapping"}){

            protected AttributeMapping buildValue_() {
                return ((PersistentAttribute)this.subject).getMapping();
            }
        };
    }

    @Override
    public void dispose() {
        this.log("/debug/ui/detailsView", "PersistentAttributeDetailsPage.dispose()");
        for (JpaComposite mappingComposite : this.mappingComposites.values()) {
            mappingComposite.dispose();
        }
        this.mappingComposites.clear();
        super.dispose();
    }

    @Override
    protected void log(String flag, String message) {
        super.log(flag, message);
        if ("/debug/ui/detailsView".equals(flag) && Tracing.booleanDebugOption("/debug/ui/detailsView")) {
            Tracing.log(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MappingFilter
    implements Filter<AttributeMapping> {
        private String mappingKey;

        MappingFilter(String mappingKey) {
            this.mappingKey = mappingKey;
        }

        public boolean accept(AttributeMapping mapping) {
            return mapping == null || this.mappingKey == null || this.mappingKey.equals(mapping.getKey());
        }
    }
}

