/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.menus;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaResourceType;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.details.DefaultMappingUiDefinition;
import org.eclipse.jpt.ui.details.MappingUiDefinition;
import org.eclipse.jpt.ui.internal.jface.ImageImageDescriptor;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapAsContribution<T extends JpaStructureNode>
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    protected IContributionItem[] getContributionItems() {
        IHandlerService handlerService = (IHandlerService)this.serviceLocator.getService(IHandlerService.class);
        IStructuredSelection currentSelection = (IStructuredSelection)handlerService.getCurrentState().getVariable("selection");
        JpaStructureNode node = (JpaStructureNode)currentSelection.getFirstElement();
        return (IContributionItem[])ArrayTools.array((Iterator)new TransformationIterator<MappingUiDefinition<T, ?>, IContributionItem>(this.mappingUiDefinitions(node)){

            protected IContributionItem transform(MappingUiDefinition<T, ?> next) {
                return MapAsContribution.this.createContributionItem(next);
            }
        }, (Object[])new IContributionItem[0]);
    }

    protected Comparator<MappingUiDefinition<T, ?>> getDefinitionsComparator() {
        return new Comparator<MappingUiDefinition<T, ?>>(){

            @Override
            public int compare(MappingUiDefinition<T, ?> item1, MappingUiDefinition<T, ?> item2) {
                String displayString1 = item1.getLabel();
                String displayString2 = item2.getLabel();
                return Collator.getInstance().compare(displayString1, displayString2);
            }
        };
    }

    protected <U extends T> Iterator<? extends MappingUiDefinition<T, ?>> mappingUiDefinitions(T node) {
        JpaPlatform jpaPlatform = node.getJpaProject().getJpaPlatform();
        JpaPlatformUi jpaPlatformUi = JptUiPlugin.instance().getJpaPlatformUi(jpaPlatform);
        ListIterator sortedMappingUiDefinitions = CollectionTools.sort((Iterator)new FilteringIterator<MappingUiDefinition<T, ?>>(this.mappingUiDefinitions(jpaPlatformUi, node.getResourceType()), (JpaStructureNode)node){
            private final /* synthetic */ JpaStructureNode val$node;
            {
                this.val$node = jpaStructureNode;
                super($anonymous0);
            }

            protected boolean accept(MappingUiDefinition<T, ?> o) {
                return o.isEnabledFor(this.val$node);
            }
        }, this.getDefinitionsComparator());
        DefaultMappingUiDefinition<T, ?> defaultDefinition = this.getDefaultMappingUiDefinition(jpaPlatformUi, node);
        if (defaultDefinition != null) {
            return new CompositeIterator(defaultDefinition, (Iterator)sortedMappingUiDefinitions);
        }
        return sortedMappingUiDefinitions;
    }

    protected abstract Iterator<? extends MappingUiDefinition<T, ?>> mappingUiDefinitions(JpaPlatformUi var1, JpaResourceType var2);

    protected abstract DefaultMappingUiDefinition<T, ?> getDefaultMappingUiDefinition(JpaPlatformUi var1, T var2);

    protected IContributionItem createContributionItem(MappingUiDefinition<T, ?> mappingUiProvider) {
        return new CommandContributionItem(this.createParameter(mappingUiProvider));
    }

    protected CommandContributionItemParameter createParameter(MappingUiDefinition<T, ?> mappingUiDefinition) {
        CommandContributionItemParameter parameter = new CommandContributionItemParameter(this.serviceLocator, this.createCommandContributionItemId(mappingUiDefinition), this.getCommandId(), 32);
        parameter.label = mappingUiDefinition.getLabel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(this.getCommandParameterId(), mappingUiDefinition.getKey());
        parameter.parameters = parameters;
        parameter.icon = new ImageImageDescriptor(mappingUiDefinition.getImage());
        parameter.visibleEnabled = true;
        return parameter;
    }

    protected abstract String getCommandId();

    protected abstract String getCommandParameterId();

    protected String createCommandContributionItemId(MappingUiDefinition<T, ?> mappingUiDefinition) {
        return String.valueOf(this.getCommandId()) + "." + mappingUiDefinition.getKey();
    }
}

