/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.internal.JavaFacetDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class JavaFacetUninstallDelegate
extends JavaFacetDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        int n;
        JavaFacetDelegate.RelevantFiles files = new JavaFacetDelegate.RelevantFiles(project);
        JavaFacetUninstallDelegate.validateEdit(files);
        ArrayList<IPath> outputFolders = new ArrayList<IPath>();
        try {
            IJavaProject jproj = JavaCore.create((IProject)project);
            outputFolders.add(jproj.getOutputLocation());
            IClasspathEntry[] iClasspathEntryArray = jproj.getRawClasspath();
            n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                outputFolders.add(cpe.getOutputLocation());
                ++n2;
            }
        }
        catch (Exception exception) {}
        IProjectDescription desc = project.getDescription();
        ArrayList<String> natures = new ArrayList<String>();
        String[] stringArray = desc.getNatureIds();
        int n3 = stringArray.length;
        n = 0;
        while (n < n3) {
            String nature = stringArray[n];
            if (!nature.equals("org.eclipse.jdt.core.javanature")) {
                natures.add(nature);
            }
            ++n;
        }
        desc.setNatureIds(natures.toArray(new String[natures.size()]));
        project.setDescription(desc, null);
        files.dotClasspathFile.delete(true, null);
        files.jdtCorePrefsFile.delete(true, null);
        files.jstFacetCorePrefsFile.delete(true, null);
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        for (IPath path : outputFolders) {
            if (path == null) continue;
            JavaFacetUninstallDelegate.delete(ws.getRoot().getFolder(path));
        }
    }

    private static final void delete(IFolder folder) throws CoreException {
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder && parent.members(11).length == 1) {
            JavaFacetUninstallDelegate.delete((IFolder)parent);
        } else if (folder.exists()) {
            folder.delete(true, null);
        }
    }
}

