/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.gen;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.ui.internal.wizards.gen.GenerateEntitiesFromSchemaWizard;
import org.eclipse.jpt.ui.internal.wizards.gen.JptUiEntityGenMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class PromptJPAProjectWizardPage
extends WizardPage {
    private static String SELECT_PROJECT_PAGE_NAME = "SelectJPAProject";
    private Table projTable;
    private TableViewer projTableViewer;
    private static int PROJECT_NAME_COLUMN_INDEX = 0;
    private final String helpContextId;

    protected PromptJPAProjectWizardPage(String helpContextId) {
        super(SELECT_PROJECT_PAGE_NAME);
        this.setTitle(JptUiEntityGenMessages.GenerateEntitiesWizard_selectJPAProject);
        this.setMessage(JptUiEntityGenMessages.GenerateEntitiesWizard_selectJPAProject_msg);
        this.helpContextId = helpContextId;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int nColumns = 1;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_selectJPAProject);
        this.projTableViewer = new TableViewer(composite, 268438020);
        this.projTable = this.projTableViewer.getTable();
        GridData gd = new GridData(4, 4, true, true);
        this.projTable.setLayoutData((Object)gd);
        this.projTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromptJPAProjectWizardPage.this.handleJpaProjectSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.projTableViewer = new TableViewer(this.projTable);
        this.projTableViewer.setLabelProvider((IBaseLabelProvider)new ProjectTableLabelProvider());
        this.projTableViewer.setContentProvider((IContentProvider)new ProjectTableContentProvider());
        this.fillJpaProjectList();
        this.setControl((Control)composite);
        this.validate();
    }

    private void handleJpaProjectSelection() {
        if (this.projTable.getSelectionIndex() != -1) {
            TableItem item = this.projTable.getItem(this.projTable.getSelectionIndex());
            String projName = item.getText(0);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
            JpaProject jpaProj = JptCorePlugin.getJpaProject((IProject)project);
            ((GenerateEntitiesFromSchemaWizard)this.getWizard()).setJpaProject(jpaProj);
            this.validate();
        }
    }

    private void fillJpaProjectList() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<String> projNames = new ArrayList<String>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            JpaProject jpaProj = JptCorePlugin.getJpaProject((IProject)project);
            if (jpaProj != null) {
                projNames.add(project.getName());
            }
            ++n2;
        }
        this.projTableViewer.setInput(projNames);
    }

    private void validate() {
        if (this.projTable.getSelectionIndex() != -1) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    public final void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContextId);
    }

    private final class ProjectTableContentProvider
    implements IStructuredContentProvider {
        private ProjectTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class ProjectTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ProjectTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == PROJECT_NAME_COLUMN_INDEX) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            assert (element instanceof String);
            String projectName = (String)element;
            if (columnIndex == PROJECT_NAME_COLUMN_INDEX) {
                return projectName;
            }
            return null;
        }
    }
}

