/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.Map;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceNamedColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.NestablePrimaryKeyJoinColumnAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourcePrimaryKeyJoinColumnAnnotation
extends SourceNamedColumnAnnotation
implements NestablePrimaryKeyJoinColumnAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.PrimaryKeyJoinColumn");
    private DeclarationAnnotationElementAdapter<String> referencedColumnNameDeclarationAdapter = this.buildReferencedColumnNameDeclarationAdapter();
    private AnnotationElementAdapter<String> referencedColumnNameAdapter = this.buildReferencedColumnNameAdapter();
    private String referencedColumnName;

    public SourcePrimaryKeyJoinColumnAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
    }

    public SourcePrimaryKeyJoinColumnAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        this(parent, member, daa, (AnnotationAdapter)new ElementAnnotationAdapter((AnnotatedElement)member, daa));
    }

    public SourcePrimaryKeyJoinColumnAnnotation(JavaResourceNode parent, Member member, IndexedDeclarationAnnotationAdapter idaa) {
        this(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter((AnnotatedElement)member, idaa));
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.PrimaryKeyJoinColumn";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.referencedColumnName = this.buildReferencedColumnName(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncReferencedColumnName(this.buildReferencedColumnName(astRoot));
    }

    @Override
    protected String getNameElementName() {
        return "name";
    }

    @Override
    protected String getColumnDefinitionElementName() {
        return "columnDefinition";
    }

    @Override
    public String getReferencedColumnName() {
        return this.referencedColumnName;
    }

    @Override
    public void setReferencedColumnName(String referencedColumnName) {
        if (this.attributeValueHasChanged(this.referencedColumnName, referencedColumnName)) {
            this.referencedColumnName = referencedColumnName;
            this.referencedColumnNameAdapter.setValue((Object)referencedColumnName);
        }
    }

    private void syncReferencedColumnName(String astReferencedColumnName) {
        String old = this.referencedColumnName;
        this.referencedColumnName = astReferencedColumnName;
        this.firePropertyChanged("referencedColumnName", old, astReferencedColumnName);
    }

    private String buildReferencedColumnName(CompilationUnit astRoot) {
        return (String)this.referencedColumnNameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getReferencedColumnNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.referencedColumnNameDeclarationAdapter, astRoot);
    }

    @Override
    public boolean referencedColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.referencedColumnNameDeclarationAdapter, pos, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildReferencedColumnNameDeclarationAdapter() {
        return this.buildStringElementAdapter("referencedColumnName");
    }

    private AnnotationElementAdapter<String> buildReferencedColumnNameAdapter() {
        return this.buildStringElementAdapter(this.referencedColumnNameDeclarationAdapter);
    }

    @Override
    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.referencedColumnName == null;
    }

    @Override
    protected void rebuildAdapters() {
        super.rebuildAdapters();
        this.referencedColumnNameDeclarationAdapter = this.buildReferencedColumnNameDeclarationAdapter();
        this.referencedColumnNameAdapter = this.buildReferencedColumnNameAdapter();
    }

    @Override
    public void storeOn(Map<String, Object> map) {
        super.storeOn(map);
        map.put("referencedColumnName", this.referencedColumnName);
        this.referencedColumnName = null;
    }

    @Override
    public void restoreFrom(Map<String, Object> map) {
        super.restoreFrom(map);
        this.setReferencedColumnName((String)map.get("referencedColumnName"));
    }

    public static SourcePrimaryKeyJoinColumnAnnotation createPrimaryKeyJoinColumn(JavaResourceNode parent, Member member) {
        return new SourcePrimaryKeyJoinColumnAnnotation(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    static SourcePrimaryKeyJoinColumnAnnotation createNestedPrimaryKeyJoinColumn(JavaResourceNode parent, Member member, int index, DeclarationAnnotationAdapter pkJoinColumnsAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = SourcePrimaryKeyJoinColumnAnnotation.buildNestedDeclarationAnnotationAdapter(index, pkJoinColumnsAdapter, "javax.persistence.PrimaryKeyJoinColumn");
        ElementIndexedAnnotationAdapter annotationAdapter = new ElementIndexedAnnotationAdapter((AnnotatedElement)member, idaa);
        return new SourcePrimaryKeyJoinColumnAnnotation(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }

    static NestablePrimaryKeyJoinColumnAnnotation createSecondaryTablePrimaryKeyJoinColumn(DeclarationAnnotationAdapter secondaryTableAdapter, JavaResourceNode parent, Member member, int index) {
        return new SourcePrimaryKeyJoinColumnAnnotation(parent, member, SourcePrimaryKeyJoinColumnAnnotation.buildSecondaryTableAnnotationAdapter(secondaryTableAdapter, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildSecondaryTableAnnotationAdapter(DeclarationAnnotationAdapter secondaryTableAdapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(secondaryTableAdapter, "pkJoinColumns", index, "javax.persistence.PrimaryKeyJoinColumn");
    }
}

