/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NodeIteratorImpl
implements NodeIterator {
    private NodeFilter filter = null;
    private Node nextNode = null;
    private Node rootNode = null;
    private int whatToShow = -1;

    NodeIteratorImpl(Node rootNode, int whatToShow, NodeFilter filter) {
        this.rootNode = rootNode;
        this.nextNode = rootNode;
        this.whatToShow = whatToShow;
        this.filter = filter;
    }

    private final boolean acceptNode(Node node) {
        if (this.whatToShow != -1) {
            if (node == null) {
                return false;
            }
            short nodeType = node.getNodeType();
            switch (this.whatToShow) {
                case 1: {
                    if (nodeType == 1) break;
                    return false;
                }
                case 2: {
                    if (nodeType == 2) break;
                    return false;
                }
                case 4: {
                    if (nodeType == 3) break;
                    return false;
                }
                case 8: {
                    if (nodeType == 4) break;
                    return false;
                }
                case 16: {
                    if (nodeType == 5) break;
                    return false;
                }
                case 32: {
                    if (nodeType == 6) break;
                    return false;
                }
                case 64: {
                    if (nodeType == 7) break;
                    return false;
                }
                case 128: {
                    if (nodeType == 8) break;
                    return false;
                }
                case 256: {
                    if (nodeType == 9) break;
                    return false;
                }
                case 512: {
                    if (nodeType == 10) break;
                    return false;
                }
                case 1024: {
                    if (nodeType == 11) break;
                    return false;
                }
                case 2048: {
                    if (nodeType == 12) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        if (this.filter != null) {
            return this.filter.acceptNode(node) == 1;
        }
        return true;
    }

    public void detach() {
        this.rootNode = null;
        this.nextNode = null;
        this.filter = null;
    }

    public boolean getExpandEntityReferences() {
        return false;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    private final Node getNextNode() {
        if (this.nextNode == null) {
            return null;
        }
        Node oldNext = this.nextNode;
        Node child = this.nextNode.getFirstChild();
        if (child != null) {
            this.nextNode = child;
            return oldNext;
        }
        Node node = this.nextNode;
        while (node != null && node != this.rootNode) {
            Node next = node.getNextSibling();
            if (next != null) {
                this.nextNode = next;
                return oldNext;
            }
            node = node.getParentNode();
        }
        this.nextNode = null;
        return oldNext;
    }

    private final Node getPreviousNode() {
        if (this.nextNode == this.rootNode) {
            return null;
        }
        Node prev = null;
        if (this.nextNode == null) {
            prev = this.rootNode;
        } else {
            prev = this.nextNode.getPreviousSibling();
            if (prev == null) {
                this.nextNode = this.nextNode.getParentNode();
                return this.nextNode;
            }
        }
        Node last = prev.getLastChild();
        while (last != null) {
            prev = last;
            last = prev.getLastChild();
        }
        this.nextNode = prev;
        return this.nextNode;
    }

    public Node getRoot() {
        return this.rootNode;
    }

    public int getWhatToShow() {
        return this.whatToShow;
    }

    public Node nextNode() throws DOMException {
        Node node = this.getNextNode();
        while (node != null) {
            if (this.acceptNode(node)) {
                return node;
            }
            node = this.getNextNode();
        }
        return null;
    }

    public Node previousNode() throws DOMException {
        Node node = this.getPreviousNode();
        while (node != null) {
            if (this.acceptNode(node)) {
                return node;
            }
            node = this.getPreviousNode();
        }
        return null;
    }
}

