/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.resource.persistence;

import org.eclipse.core.resources.IFolder;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jpt.common.core.internal.utility.translators.SimpleTranslator;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistencePackage;
import org.eclipse.jpt.jpa.core.resource.xml.AbstractJpaEObject;
import org.eclipse.jpt.jpa.core.resource.xml.JpaEObject;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.common.internal.emf.resource.Translator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class XmlJarFileRef
extends AbstractJpaEObject
implements JpaEObject {
    protected static final String FILE_NAME_EDEFAULT = "";
    protected String fileName = "";

    protected XmlJarFileRef() {
    }

    protected EClass eStaticClass() {
        return PersistencePackage.Literals.XML_JAR_FILE_REF;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String newFileName) {
        String oldFileName = this.fileName;
        this.fileName = newFileName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldFileName, (Object)this.fileName));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getFileName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setFileName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setFileName(FILE_NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return FILE_NAME_EDEFAULT == null ? this.fileName != null : !FILE_NAME_EDEFAULT.equals(this.fileName);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (fileName: ");
        result.append(this.fileName);
        result.append(')');
        return result.toString();
    }

    public TextRange getValidationTextRange() {
        return !StringTools.stringIsEmpty((String)this.fileName) ? this.getTextTextRange() : super.getValidationTextRange();
    }

    public static Translator buildTranslator(String elementName, EStructuralFeature structuralFeature) {
        return new SimpleTranslator(elementName, structuralFeature, 8, XmlJarFileRef.buildTranslatorChildren());
    }

    private static Translator[] buildTranslatorChildren() {
        return new Translator[]{XmlJarFileRef.buildFileNameTranslator()};
    }

    private static Translator buildFileNameTranslator() {
        return new Translator("$TEXT_ATTRIBUTE_VALUE", (EStructuralFeature)PersistencePackage.eINSTANCE.getXmlJarFileRef_FileName());
    }

    public ReplaceEdit createReplaceFolderEdit(IFolder originalFolder, String newName) {
        IDOMNode domNode = this.getTextNode();
        String originalName = originalFolder.getName();
        int nameIndex = this.fileName.indexOf(originalName);
        int offset = domNode.getStartOffset();
        return new ReplaceEdit(offset + nameIndex, originalName.length(), newName);
    }
}

