/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.jst.ws.internal.ui.dialog.DialogUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddHandlerDialog
extends Dialog
implements Listener {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private boolean validateOn_;
    private boolean isClient_;
    private boolean isMultipleServices_;
    private String className;
    private String name;
    private String selectedPortName;
    private Text classNameText;
    private Text nameText;
    private Combo portNameCombo;
    private final String INFOPOP_TEXT_HANDLER_NAME = "AHDL0001";
    private final String INFOPOP_TEXT_HANDLER_CLASS = "AHDL0002";
    private final String INFOPOP_TEXT_HANDLER_PORT = "AHDL0003";
    private Button beanClassBrowseButton_;
    private String INFOPOP_PBCL_BUTTON_BEAN_CLASS_BROWSE = "PBCL0003";

    public AddHandlerDialog(Shell shell, boolean isClientHandler) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.isClient_ = isClientHandler;
    }

    protected Control createContents(Composite parent) {
        Composite comp = (Composite)super.createContents(parent);
        parent.getShell().pack();
        return comp;
    }

    protected Control createDialogArea(Composite parent) {
        this.validateOn_ = false;
        UIUtils uiUtils = new UIUtils(this.pluginId_);
        Shell thisShell = parent.getShell();
        if (thisShell == null) {
            thisShell = this.createShell();
        }
        thisShell.setText(ConsumptionUIMessages.DIALOG_TITLE_WS_ADD_HANDLER);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite sourceLocationComp = uiUtils.createComposite(composite, 3);
        this.classNameText = uiUtils.createText(sourceLocationComp, ConsumptionUIMessages.LABEL_TEXT_HANDLER_CLASS, ConsumptionUIMessages.TOOLTIP_TEXT_HANDLER_CLASS, "AHDL0002", 2052);
        this.classNameText.addListener(24, (Listener)this);
        this.beanClassBrowseButton_ = uiUtils.createPushButton(sourceLocationComp, ConsumptionUIMessages.BUTTON_BROWSE_CLASSES, ConsumptionUIMessages.TOOLTIP_PBCL_BUTTON_BEAN_CLASS_BROWSE, this.INFOPOP_PBCL_BUTTON_BEAN_CLASS_BROWSE);
        this.beanClassBrowseButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AddHandlerDialog.this.handleBrowseClasses();
            }
        });
        this.nameText = uiUtils.createText(sourceLocationComp, ConsumptionUIMessages.LABEL_TEXT_HANDLER_NAME, ConsumptionUIMessages.TOOLTIP_TEXT_HANDLER_NAME, "AHDL0001", 2052);
        this.nameText.addListener(24, (Listener)this);
        new Label(sourceLocationComp, 0);
        if (!this.isClient_ && !this.isMultipleServices_) {
            this.portNameCombo = uiUtils.createCombo(sourceLocationComp, ConsumptionUIMessages.LABEL_TEXT_HANDLER_PORT, ConsumptionUIMessages.TOOLTIP_TEXT_HANDLER_PORT, "AHDL0003", 2052);
            this.portNameCombo.addListener(24, (Listener)this);
            new Label(sourceLocationComp, 0);
        }
        this.validateOn_ = true;
        return composite;
    }

    private void handleBrowseClasses() {
        Shell shell = this.getShell();
        IType itype = DialogUtils.browseClassesAsIType((Shell)shell, (IResource[])ResourcesPlugin.getWorkspace().getRoot().getProjects(), (IRunnableContext)new ProgressMonitorDialog(shell));
        if (itype != null) {
            this.classNameText.setText(itype.getFullyQualifiedName());
        }
    }

    public void handleEvent(Event event) {
        if (!this.validateOn_) {
            return;
        }
        if (this.classNameText == event.widget) {
            this.handleClassNameTextEvent();
            this.validateTextFieldEntries();
            return;
        }
        if (this.nameText == event.widget) {
            this.handleNameTextEvent();
            this.validateTextFieldEntries();
            return;
        }
        if (this.portNameCombo == event.widget) {
            this.handlePortNameTextEvent();
            this.validateTextFieldEntries();
            return;
        }
    }

    private void handleClassNameTextEvent() {
        this.className = this.classNameText.getText();
        if (this.className.lastIndexOf(".java") != -1) {
            this.nameText.setText(this.className.substring(0, this.className.lastIndexOf(".java")));
        } else {
            this.nameText.setText(this.className);
        }
        if (this.className.lastIndexOf(".") != -1) {
            this.nameText.setText(this.className.substring(this.className.lastIndexOf(".") + 1, this.className.length()));
        }
        this.name = this.nameText.getText();
    }

    private void handleNameTextEvent() {
        this.name = this.nameText.getText();
    }

    private void handlePortNameTextEvent() {
        this.selectedPortName = this.portNameCombo.getText();
    }

    private void disableOKButton() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(false);
        }
    }

    private void enableOKButton() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
    }

    private void validateTextFieldEntries() {
        if (this.classNameText.getText().equals("")) {
            this.disableOKButton();
            return;
        }
        if (this.nameText.getText().equals("")) {
            this.disableOKButton();
            return;
        }
        if (!this.isClient_ && !this.isMultipleServices_) {
            if (this.portNameCombo.getText() != null && this.portNameCombo.getText().equals("")) {
                this.disableOKButton();
                return;
            }
            if (this.portNameCombo.getText() == null) {
                this.disableOKButton();
                return;
            }
        }
        this.enableOKButton();
    }

    public String getClassName() {
        if (this.className.lastIndexOf(".java") != -1) {
            return this.className.substring(0, this.className.lastIndexOf(".java"));
        }
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPortName() {
        return this.selectedPortName;
    }

    public void setPortNames(String[] portNames) {
        this.portNameCombo.setItems(portNames);
        this.portNameCombo.select(0);
    }

    public void setIsMultipleServices(boolean isMultipleServices) {
        this.isMultipleServices_ = isMultipleServices;
    }
}

