/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.refactor.listeners;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.refactor.RefactorResourceHandler;
import org.eclipse.jst.j2ee.refactor.listeners.RefactorMessages;
import org.eclipse.jst.j2ee.refactor.operations.OptionalRefactorHandler;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRefactorMetadata;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRenameDataModelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraph;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class ProjectRefactoringListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public static final String PROJECT_REFACTORING_JOB_FAMILY = "org.eclipse.jst.j2ee.refactor.project";
    private final Map deletedProjectMetadata = new HashMap();

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getType() == 4) {
                IProject project = (IProject)event.getResource();
                if (ModuleCoreNature.isFlexibleProject((IProject)project) && ProjectFacetsManager.create((IProject)project) != null) {
                    this.cacheDeletedProjectMetadata(project);
                }
            } else {
                event.getDelta().accept((IResourceDeltaVisitor)this);
            }
        }
        catch (CoreException ce) {
            J2EEPlugin.logError(ce);
        }
    }

    private synchronized void cacheDeletedProjectMetadata(IProject project) {
        ProjectRefactorMetadata metadata = new ProjectRefactorMetadata(project, ProjectRefactorMetadata.REFERER_CACHING);
        metadata.computeMetadata();
        metadata.computeServers();
        Set dotComponentReferences = IDependencyGraph.INSTANCE.getReferencingComponents(project);
        HashSet<IProject> modulesAlreadyChecked = new HashSet<IProject>();
        modulesAlreadyChecked.add(project);
        modulesAlreadyChecked.addAll(dotComponentReferences);
        HashSet<IProject> allReferences = new HashSet<IProject>();
        for (IProject earProject : dotComponentReferences) {
            IVirtualReference[] earRefs;
            allReferences.add(earProject);
            if (!EarUtilities.isEARProject(earProject)) continue;
            IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProject);
            IVirtualReference[] iVirtualReferenceArray = earRefs = earComponent.getReferences();
            int n = earRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualReference earRef = iVirtualReferenceArray[n2];
                IVirtualComponent moduleComponent = earRef.getReferencedComponent();
                IProject moduleProject = moduleComponent.getProject();
                if (!moduleComponent.isBinary() && !modulesAlreadyChecked.contains(moduleProject)) {
                    IVirtualReference[] moduleRefs;
                    modulesAlreadyChecked.add(moduleProject);
                    IVirtualReference[] iVirtualReferenceArray2 = moduleRefs = moduleComponent.getReferences();
                    int n3 = moduleRefs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IVirtualReference moduleRef = iVirtualReferenceArray2[n4];
                        IVirtualComponent manifestComponent = moduleRef.getReferencedComponent();
                        if (manifestComponent.getProject().equals((Object)project)) {
                            allReferences.add(moduleProject);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        IProject[] referencingProjects = allReferences.toArray(new IProject[allReferences.size()]);
        metadata.computeDependentMetadata(ProjectRefactorMetadata.REF_CACHING, referencingProjects);
        this.deletedProjectMetadata.put(project.getName(), metadata);
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource instanceof IWorkspaceRoot) {
            return true;
        }
        if (resource instanceof IProject) {
            this.processProjectDelta((IProject)resource, delta);
        }
        return false;
    }

    private synchronized void processProjectDelta(IProject project, IResourceDelta delta) throws CoreException {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (kind == 1 && this.hasRenamedAddedFlags(flags)) {
            String originalName = delta.getMovedFromPath().lastSegment();
            ProjectRefactorMetadata originalMetadata = (ProjectRefactorMetadata)this.deletedProjectMetadata.remove(originalName);
            ProjectRefactorMetadata newMetadata = new ProjectRefactorMetadata(project);
            if (originalMetadata != null && OptionalRefactorHandler.getInstance().shouldRefactorRenamedProject(originalMetadata)) {
                newMetadata.computeMetadata(originalMetadata.getProject());
                this.processRename(originalMetadata, newMetadata, delta);
            }
        }
    }

    private boolean hasRenamedAddedFlags(int flags) {
        return (flags & 0x80000) > 0 && (flags & 0x1000) > 0;
    }

    private void processRename(final ProjectRefactorMetadata originalMetadata, final ProjectRefactorMetadata newMetadata, final IResourceDelta delta) {
        WorkspaceJob job = new WorkspaceJob(RefactorMessages.ProjectRefactoringListener_J2EE_Project_Rename_){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new ProjectRenameDataModelProvider());
                dataModel.setProperty("ProjectRefactoringProperties.PROJECT_METADATA", (Object)newMetadata);
                dataModel.setProperty("ProjectRefactoringProperties.ORIGINAL_PROJECT_METADATA", (Object)originalMetadata);
                dataModel.setProperty("ProjectRefactoringProperties.RESOURCE_DELTA", (Object)delta);
                try {
                    dataModel.getDefaultOperation().execute(monitor, null);
                }
                catch (Exception e) {
                    String msg = RefactorResourceHandler.getString("error_updating_project_on_rename", new Object[]{originalMetadata.getProjectName()});
                    J2EEPlugin.logError(msg);
                    J2EEPlugin.logError(e);
                    return new Status(4, "org.eclipse.jst.j2ee", 0, msg, (Throwable)e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return ProjectRefactoringListener.PROJECT_REFACTORING_JOB_FAMILY.equals(family);
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }
}

