/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.extensions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.ValidationUtils;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.RuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class ClientExtensionDefaultingCommand
extends AbstractDataModelOperation {
    private boolean developClient_;
    private boolean assembleClient_;
    private boolean deployClient_;
    private TypeRuntimeServer clientIds_;
    private String clientRuntimeId_;
    private boolean testService;
    private Boolean installClient;
    private boolean startClient;
    private boolean runTestClient;
    private ResourceContext resourceContext;
    private String clientProjectName_;
    private String clientEarProjectName_;
    private String clientComponentType_;
    private boolean clientNeedEAR_;
    private String serviceServerFactoryId_;
    private String serviceServerInstanceId_;
    private boolean genWSIL;
    private String wsilURI;
    private WebServicesParser webServicesParser;
    private String wsdlURI;
    private boolean isClientScenario_;
    private boolean genProxy_ = true;
    private String launchedServiceTestName;
    private String serverInstId_;

    public ClientExtensionDefaultingCommand(boolean isClientScenario) {
        this.isClientScenario_ = isClientScenario;
    }

    public boolean getIsClientScenario() {
        return this.isClientScenario_;
    }

    public void setClientTypeRuntimeServer(TypeRuntimeServer ids) {
        this.clientIds_ = ids;
    }

    public TypeRuntimeServer getClientTypeRuntimeServer() {
        if ((this.clientIds_.getServerInstanceId() == null || this.clientIds_.getServerInstanceId().length() == 0) && this.serviceServerInstanceId_ != null && this.serviceServerInstanceId_.length() > 0 && this.serviceServerFactoryId_ != null && this.serviceServerFactoryId_.length() > 0 && this.serviceServerFactoryId_.equals(this.clientIds_.getServerId())) {
            this.clientIds_.setServerInstanceId(this.serviceServerInstanceId_);
        }
        return this.clientIds_;
    }

    public void setClientRuntimeId(String id) {
        this.clientRuntimeId_ = id;
    }

    public String getClientRuntimeId() {
        return this.clientRuntimeId_;
    }

    public void setServiceExistingServerInstId(String serverInstId) {
        this.serverInstId_ = serverInstId;
    }

    public String getServiceExistingServerInstId() {
        return this.serverInstId_;
    }

    public boolean isClientIsExistingServer() {
        return this.clientIds_.getServerInstanceId() != null;
    }

    public String getClientProject() {
        return String.valueOf(this.clientProjectName_) + "/" + this.clientProjectName_;
    }

    public String getClientProjectEAR() {
        if (this.clientEarProjectName_ != null && this.clientEarProjectName_.length() > 0) {
            return String.valueOf(this.clientEarProjectName_) + "/" + this.clientEarProjectName_;
        }
        return "";
    }

    public String getClientProjectType() {
        return this.clientComponentType_;
    }

    public String getClientRuntime() {
        return this.clientIds_.getRuntimeId();
    }

    public String getClientServer() {
        return this.clientIds_.getServerId();
    }

    public String getClientServerInstance() {
        return this.clientIds_.getServerInstanceId();
    }

    public void setClientExistingServerInstanceId(String serverInstId) {
        if (this.clientIds_.getServerInstanceId() == null) {
            this.clientIds_.setServerInstanceId(serverInstId);
        }
    }

    public boolean isGenWSIL() {
        return this.genWSIL;
    }

    public void setGenWSIL(boolean genWSIL) {
        this.genWSIL = genWSIL;
    }

    public ResourceContext getResourceContext() {
        return this.resourceContext;
    }

    public void setResourceContext(ResourceContext resourceContext) {
        this.resourceContext = resourceContext;
    }

    public boolean getTestService() {
        return this.testService;
    }

    public void setTestService(boolean testService) {
        this.testService = testService;
    }

    public boolean getRunTestClient() {
        return this.runTestClient;
    }

    public void setRunTestClient(boolean runTestClient) {
        this.runTestClient = runTestClient;
    }

    public boolean getDevelopClient() {
        return this.developClient_;
    }

    public void setDevelopClient(boolean developClient) {
        this.developClient_ = developClient;
    }

    public boolean getAssembleClient() {
        return this.assembleClient_;
    }

    public void setAssembleClient(boolean assembleClient) {
        this.assembleClient_ = assembleClient;
    }

    public boolean getDeployClient() {
        return this.deployClient_;
    }

    public void setDeployClient(boolean deployClient) {
        this.deployClient_ = deployClient;
    }

    public Boolean getInstallClient() {
        return this.installClient;
    }

    public void setInstallClient(Boolean installClient) {
        this.installClient = installClient;
    }

    public boolean getStartClient() {
        return this.startClient;
    }

    public void setStartClient(boolean startClient) {
        this.startClient = startClient;
    }

    public String getWsdlURI() {
        return this.wsdlURI;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public String getWsilURI() {
        return this.wsilURI;
    }

    public void setWsilURI(String wsilURI) {
        this.wsilURI = wsilURI;
    }

    public WebServicesParser getWebServicesParser() {
        if (this.webServicesParser != null) {
            return this.webServicesParser;
        }
        return new WebServicesParserExt();
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public String getClientJ2EEVersion() {
        return "14";
    }

    public boolean getGenerateProxy() {
        return this.genProxy_;
    }

    public void setGenerateProxy(boolean genProxy) {
        this.genProxy_ = genProxy;
    }

    public void setLaunchedServiceTestName(String launchedServiceTestName) {
        this.launchedServiceTestName = launchedServiceTestName;
    }

    public String getLaunchedServiceTestName() {
        return this.launchedServiceTestName;
    }

    public boolean getClientNeedEAR() {
        return this.clientNeedEAR_;
    }

    public void setClientNeedEAR(boolean clientNeedEAR) {
        this.clientNeedEAR_ = clientNeedEAR;
    }

    public void setClientComponentType(String clientComponentType) {
        this.clientComponentType_ = clientComponentType;
    }

    public void setClientProjectName(String clientProjectName) {
        this.clientProjectName_ = clientProjectName;
    }

    public void setClientEarProjectName(String clientEarProjectName) {
        this.clientEarProjectName_ = clientEarProjectName;
    }

    public String getClientEarProjectName() {
        return this.clientEarProjectName_;
    }

    public void setServiceServerFactoryId(String id) {
        this.serviceServerFactoryId_ = id;
    }

    public void setServiceServerInstanceId(String id) {
        this.serviceServerInstanceId_ = id;
    }

    public boolean getCanRunTestClient() {
        return this.clientIds_.getServerInstanceId() != null;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        String scenario = ConsumptionUIMessages.MSG_CLIENT_SUB;
        String runtimeId = this.clientIds_.getRuntimeId();
        String serverId = this.clientIds_.getServerId();
        String typeId = this.clientIds_.getTypeId();
        if (runtimeId == null || runtimeId.length() == 0) {
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_NO_RUNTIME, (Object[])new String[]{scenario}));
            env.getStatusHandler().reportError(status);
        }
        if (serverId == null || serverId.length() == 0) {
            IProject clientProject = ProjectUtilities.getProject((String)this.clientProjectName_);
            if (!clientProject.exists()) {
                String runtimeLabel = WebServiceRuntimeExtensionUtils2.getRuntimeLabelById(runtimeId);
                status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_PROJECT_MUST_EXIST, (Object[])new String[]{this.clientProjectName_, runtimeLabel}));
                env.getStatusHandler().reportError(status);
            } else {
                RuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getRuntimeById(runtimeId);
                if (desc.getServerRequired()) {
                    status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_NO_SERVER, (Object[])new String[]{scenario}));
                    env.getStatusHandler().reportError(status);
                } else {
                    this.deployClient_ = false;
                    this.installClient = Boolean.FALSE;
                    this.startClient = false;
                }
            }
        }
        boolean noRuntimeInstalled = true;
        if (serverId != null) {
            String[] runtimes = WebServiceRuntimeExtensionUtils2.getAllServerFactoryIdsWithRuntimes();
            int i = 0;
            while (i < runtimes.length) {
                if (runtimes[i].equals(serverId)) {
                    noRuntimeInstalled = false;
                    break;
                }
                ++i;
            }
            if (noRuntimeInstalled) {
                String serverLabel = WebServiceRuntimeExtensionUtils2.getServerLabelById(serverId);
                if (serverLabel == null) {
                    serverLabel = serverId;
                }
                status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_NO_SERVER_RUNTIME_INSTALLED, (Object[])new String[]{serverLabel}));
                env.getStatusHandler().reportError(status);
            }
        }
        if (!noRuntimeInstalled && serverId != null && serverId.length() > 0) {
            IRuntime nonStubRuntime;
            ValidationUtils vUtil;
            if (!WebServiceRuntimeExtensionUtils2.isServerClientRuntimeTypeSupported(serverId, runtimeId, typeId)) {
                String serverLabel = WebServiceRuntimeExtensionUtils2.getServerLabelById(serverId);
                String runtimeLabel = WebServiceRuntimeExtensionUtils2.getRuntimeLabelById(runtimeId);
                status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_INVALID_SRT_SELECTIONS, (Object[])new String[]{serverLabel, runtimeLabel}));
                env.getStatusHandler().reportError(status);
            }
            if (this.clientProjectName_ != null && ProjectUtilities.getProject((String)this.clientProjectName_).exists() && !(vUtil = new ValidationUtils()).doesServerSupportProject(serverId, this.clientProjectName_)) {
                status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_CLIENT_SERVER_DOES_NOT_SUPPORT_PROJECT, (Object[])new String[]{WebServiceRuntimeExtensionUtils2.getServerLabelById(serverId), this.clientProjectName_}));
                env.getStatusHandler().reportError(status);
            }
            if ((nonStubRuntime = ServerUtils.getNonStubRuntime((String)serverId)) == null && this.clientIds_.getServerInstanceId() == null) {
                this.installClient = Boolean.FALSE;
                this.startClient = false;
            }
        }
        this.clientRuntimeId_ = WebServiceRuntimeExtensionUtils2.getClientRuntimeId(this.clientIds_, this.clientProjectName_, this.clientComponentType_);
        return status;
    }
}

