/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.wst.sse.core.internal.IExecutionDelegate;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;

class EditorExecutionContext
implements IExecutionDelegate {
    StructuredTextEditor fEditor;
    private ReusableUIRunner fReusableRunner;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public EditorExecutionContext(StructuredTextEditor editor) {
        this.fEditor = editor;
        this.fReusableRunner = new ReusableUIRunner(this.fEditor);
    }

    public void execute(ISafeRunnable runnable) {
        IWorkbench workbench = SSEUIPlugin.getInstance().getWorkbench();
        Display display = workbench.getDisplay();
        if (display.getThread() == Thread.currentThread()) {
            SafeRunner.run((ISafeRunnable)runnable);
        } else {
            this.fReusableRunner.setRunnable(runnable);
            display.syncExec((Runnable)this.fReusableRunner);
        }
    }

    private static class ReusableUIRunner
    implements Runnable,
    IRunnableWithProgress {
        private StructuredTextEditor editor;
        private ISafeRunnable fRunnable = null;

        ReusableUIRunner(StructuredTextEditor part) {
            this.editor = part;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object;
            IWorkbenchWindow workbenchWindow;
            IWorkbenchPartSite site = this.editor.getEditorPart().getSite();
            IWorkbenchWindow iWorkbenchWindow = workbenchWindow = site == null ? null : site.getWorkbenchWindow();
            if (site == null) {
                object = null;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                object = site.getAdapter((Class)clazz);
            }
            IWorkbenchSiteProgressService jobService = (IWorkbenchSiteProgressService)object;
            if (workbenchWindow != null && jobService != null) {
                try {
                    IEditorInput iEditorInput = this.editor.getEditorPart().getEditorInput();
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        Class<?> clazz3;
                        try {
                            clazz3 = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$1 = clazz3;
                    }
                    jobService.runInUI((IRunnableContext)workbenchWindow, (IRunnableWithProgress)this, (ISchedulingRule)iEditorInput.getAdapter((Class)clazz));
                    return;
                }
                catch (InvocationTargetException e) {
                    Logger.logException(e);
                    return;
                }
                catch (InterruptedException e) {
                    Logger.logException(e);
                    return;
                }
            }
            IWorkbench workbench = SSEUIPlugin.getInstance().getWorkbench();
            Display display = workbench.getDisplay();
            if (display != null && !display.isDisposed()) {
                this.editor.beginBackgroundOperation();
                try {
                    SafeRunner.run((ISafeRunnable)this.fRunnable);
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    this.editor.endBackgroundOperation();
                    throw throwable;
                }
                {
                    Object var6_10 = null;
                    this.editor.endBackgroundOperation();
                }
            }
            this.fRunnable = null;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (this.fRunnable != null) {
                SafeRunner.run((ISafeRunnable)this.fRunnable);
            }
        }

        void setRunnable(ISafeRunnable r) {
            this.fRunnable = r;
        }
    }
}

