/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project.facet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.common.project.facet.core.IClasspathProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.IRuntimeChangedEvent;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class J2EEFacetRuntimeChangedDelegate
implements IDelegate {
    public static final String LEGACY_METADATA_FILE_NAME = ".settings/org.eclipse.jst.common.project.facet.core.prefs";
    private static final String OWNER_PROJECT_FACETS_ATTR = "owner.project.facets";

    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 11);
        }
        try {
            IRuntimeChangedEvent event = (IRuntimeChangedEvent)cfg;
            this.removeClasspathEntries(project, fv, event.getOldRuntime());
            ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
            if (monitor != null) {
                monitor.worked(1);
            }
            HashSet<IProject> childProjects = new HashSet<IProject>();
            IVirtualComponent projectVC = ComponentCore.createComponent((IProject)project);
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("REQUESTED_REFERENCE_TYPE", "HARD_REFERENCES");
            IVirtualReference[] vrefs = projectVC.getReferences(options);
            int i = 0;
            while (i < vrefs.length) {
                IVirtualReference vref = vrefs[i];
                IVirtualComponent vc = vref.getReferencedComponent();
                childProjects.add(vc.getProject());
                ++i;
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            J2EEFacetRuntimeChangedDelegate.updateProjectRuntime(project, childProjects, J2EEFacetRuntimeChangedDelegate.submon(monitor, 9));
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void removeClasspathEntries(IProject project, IProjectFacetVersion fv, IRuntime oldRuntime) throws CoreException {
        IJavaProject jproj = JavaCore.create((IProject)project);
        List cp = this.getClasspath(jproj);
        boolean hasPrefs = this.hasClasspathPreferencesNode(project);
        if (!hasPrefs) {
            this.removeOnlyCPEntries(project, fv, jproj, cp, oldRuntime);
        } else {
            ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
        }
    }

    private boolean hasClasspathPreferencesNode(IProject project) {
        IProject pj = project.getProject();
        IFile legacyMetadataFile = pj.getFile(LEGACY_METADATA_FILE_NAME);
        if (legacyMetadataFile.exists()) {
            ProjectScope scope = new ProjectScope(project);
            IEclipsePreferences pluginRoot = scope.getNode("org.eclipse.jst.common.project.facet.core");
            try {
                return pluginRoot.nodeExists("classpath.helper");
            }
            catch (BackingStoreException e) {
                J2EEPlugin.logError(e);
            }
        }
        IJavaProject jproj = JavaCore.create((IProject)project);
        return this.hasClasspathPreferencesNode(jproj);
    }

    private boolean hasClasspathPreferencesNode(IJavaProject jproj) {
        boolean attributeFound = false;
        IClasspathEntry[] entries = null;
        try {
            entries = jproj.getRawClasspath();
        }
        catch (JavaModelException e) {
            J2EEPlugin.logError((CoreException)((Object)e));
        }
        int i = 0;
        if (entries != null) {
            while (!attributeFound && i < entries.length) {
                IClasspathEntry cpe = entries[i];
                attributeFound = this.hasOwnerAttribute(cpe);
                ++i;
            }
        }
        return attributeFound;
    }

    private boolean hasOwnerAttribute(IClasspathEntry cpe) {
        if (cpe != null) {
            IClasspathAttribute[] iClasspathAttributeArray = cpe.getExtraAttributes();
            int n = iClasspathAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathAttribute attr = iClasspathAttributeArray[n2];
                if (attr.getName().equals(OWNER_PROJECT_FACETS_ATTR)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void removeOnlyCPEntries(IProject project, IProjectFacetVersion fv, IJavaProject jproj, List cp, IRuntime oldRuntime) throws CoreException {
        IRuntime runtime;
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        IRuntime iRuntime = runtime = oldRuntime != null ? oldRuntime : fproj.getPrimaryRuntime();
        if (runtime != null) {
            IClasspathProvider cpprov = (IClasspathProvider)runtime.getAdapter(IClasspathProvider.class);
            List cpentries = cpprov.getClasspathEntries(fv);
            boolean realCPChanged = false;
            if (cpentries != null) {
                block0: for (IClasspathEntry cpentry : cpentries) {
                    IPath path = cpentry.getPath();
                    boolean contains = cp.contains(cpentry);
                    if (!contains) continue;
                    Iterator itr2 = cp.iterator();
                    while (itr2.hasNext()) {
                        IClasspathEntry realEntry = (IClasspathEntry)itr2.next();
                        if (!realEntry.getPath().equals((Object)path)) continue;
                        itr2.remove();
                        realCPChanged = true;
                        continue block0;
                    }
                }
            }
            if (realCPChanged) {
                IClasspathEntry[] newcp = cp.toArray(new IClasspathEntry[cp.size()]);
                jproj.setRawClasspath(newcp, null);
            }
        }
    }

    private List getClasspath(IJavaProject jproj) throws CoreException {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] cp = jproj.getRawClasspath();
        int i = 0;
        while (i < cp.length) {
            list.add(cp[i]);
            ++i;
        }
        return list;
    }

    private static IProgressMonitor submon(IProgressMonitor parent, int ticks) {
        return parent == null ? null : new SubProgressMonitor(parent, ticks);
    }

    public static void updateProjectRuntime(IProject project, IProject childProject, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            IRuntime projectRuntime = facetedProject.getRuntime();
            IFacetedProject childFacetedProject = ProjectFacetsManager.create((IProject)childProject);
            if (childFacetedProject != null && !J2EEFacetRuntimeChangedDelegate.equals(projectRuntime, childFacetedProject.getRuntime())) {
                boolean supports = true;
                if (projectRuntime != null) {
                    for (IProjectFacetVersion fver : childFacetedProject.getProjectFacets()) {
                        if (projectRuntime.supports(fver)) continue;
                        supports = false;
                        break;
                    }
                }
                if (supports) {
                    childFacetedProject.setRuntime(projectRuntime, J2EEFacetRuntimeChangedDelegate.submon(monitor, 1));
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static void updateProjectRuntime(IProject project, Set<IProject> childProjects, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", childProjects.size());
        }
        try {
            for (IProject childProject : childProjects) {
                J2EEFacetRuntimeChangedDelegate.updateProjectRuntime(project, childProject, J2EEFacetRuntimeChangedDelegate.submon(monitor, 1));
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }
}

