/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.fixups;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class CheckAndFixConsistency {
    private static final String ANY_NONEOL_WHITESPACE = "[ \\t]*";
    private static final String ANY_END = ".*$";
    private static final String ONE_PROPERTY_DELIMITER = "[=:]";
    private static final String START_OF_LINE = "^";
    private static final String KEY_WORD = "license";
    private static final String CONTINUATION = "\\\\ *$";
    int CR = 13;
    int LF = 10;
    String LICENSE_KEY = "^license[ \\t]*[=:].*$";
    private static final String PLUGINID = "org.eclipse.wtp.releng.fixups";
    private static final String CONSOLE_NAME = "Releng Console";
    private static boolean DEBUG = false;
    private String standardlicense = null;
    private ArrayList featureProjects = new ArrayList();
    private ArrayList featureProjectsMissingProperties = new ArrayList();
    private ArrayList featureProjectsMissingLicense = new ArrayList();
    private ArrayList featuresModified = new ArrayList();
    private ArrayList featuresOkNotModified = new ArrayList();
    private ArrayList featuresCouldNotBeModified = new ArrayList();
    private int nFeatures;
    private long starttime;

    private String getStandardLicense() throws IOException {
        if (this.standardlicense == null) {
            InputStream propstream = null;
            Properties standardproperties = new Properties();
            try {
                propstream = this.getClass().getResourceAsStream("standard.properties");
                standardproperties.load(propstream);
                this.standardlicense = standardproperties.getProperty(KEY_WORD);
            }
            finally {
                if (propstream != null) {
                    propstream.close();
                }
            }
        }
        return this.standardlicense;
    }

    public Object checkAndFixConsistency() throws ExecutionException {
        Object returnobject = 0;
        this.starttime = System.currentTimeMillis();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.initCounterArrays();
        int j = 0;
        while (j < projects.length) {
            IProject project = projects[j];
            IFile file = project.getFile("feature.xml");
            if (file != null && file.exists()) {
                ++this.nFeatures;
                returnobject = this.processProjectDirectory(project);
                IFolder sourceTemplate = project.getFolder("sourceTemplateFeature");
                if (sourceTemplate != null && sourceTemplate.exists()) {
                    ++this.nFeatures;
                    SourceTemplateProject sourceTemplateProject = new SourceTemplateProject(project);
                    returnobject = this.processProjectDirectory(sourceTemplateProject);
                }
            }
            ++j;
        }
        this.reportSummaryOfResults();
        return returnobject;
    }

    private Object processProjectDirectory(IProject project) {
        Integer returnobject = 0;
        String propNamePath = "feature.properties";
        IFile propfile = project.getFile(propNamePath);
        if (propfile != null && propfile.exists()) {
            this.featureProjects.add(project);
            try {
                this.fixup(propfile, project);
            }
            catch (IOException e) {
                returnobject = new Status(0, PLUGINID, e.getMessage());
            }
            catch (CoreException e) {
                returnobject = new Status(0, PLUGINID, e.getMessage());
            }
        } else {
            this.featureProjectsMissingProperties.add(project);
        }
        return returnobject;
    }

    private Object processProjectDirectory(SourceTemplateProject project) {
        Integer returnobject = 0;
        String propNamePath = "feature.properties";
        IFile propfile = project.getFile(propNamePath);
        if (propfile != null && propfile.exists()) {
            this.featureProjects.add(project);
            try {
                this.fixup(propfile, project);
            }
            catch (IOException e) {
                returnobject = new Status(0, PLUGINID, e.getMessage());
            }
            catch (CoreException e) {
                returnobject = new Status(0, PLUGINID, e.getMessage());
            }
        } else {
            this.featureProjectsMissingProperties.add(project);
        }
        return returnobject;
    }

    private void reportSummaryOfResults() {
        MessageConsole myConsole = this.findConsole(CONSOLE_NAME);
        MessageConsoleStream out = myConsole.newMessageStream();
        myConsole.activate();
        out.println();
        out.println("\tTotal number of features found: " + this.nFeatures);
        out.println();
        this.report(out, this.featureProjectsMissingProperties, "The following feature(s) contained no feature.properties file");
        this.report(out, this.featureProjectsMissingLicense, "The following feature(s) contained no license property");
        this.report(out, this.featuresOkNotModified, "The following feature(s) were found ok, and not modified");
        this.report(out, this.featuresModified, "The following feature(s) were modified");
        this.report(out, this.featuresCouldNotBeModified, "The following feature(s) needed to be modified, but for some reason could not be. \n\tThis is likely due to a non-standard (but legal) way of writing property keys and values");
        out.println();
        long elapsedTime = System.currentTimeMillis() - this.starttime;
        out.println("\tElapsed processing time : " + elapsedTime + " ms");
        out.println();
    }

    private void initCounterArrays() {
        this.featureProjects.clear();
        this.featureProjectsMissingProperties.clear();
        this.featureProjectsMissingLicense.clear();
        this.featuresModified.clear();
        this.featuresOkNotModified.clear();
        this.featuresCouldNotBeModified.clear();
    }

    private void fixup(IFile propfile, IProject project) throws IOException, CoreException {
        Properties featureproperties = new Properties();
        featureproperties.load(propfile.getContents());
        String license = featureproperties.getProperty(KEY_WORD);
        if (license == null) {
            this.featureProjectsMissingLicense.add(project);
        } else if (this.notequiv(license, this.getStandardLicense())) {
            if (this.rewrite(propfile, project)) {
                this.featuresModified.add(project);
                this.copyLicenseHtml(project);
            } else {
                this.featuresCouldNotBeModified.add(project);
            }
        } else {
            this.featuresOkNotModified.add(project);
        }
    }

    private String inferEOL(IFile featureProperties) throws CoreException, IOException {
        InputStream contentToPeekForEOL = featureProperties.getContents();
        String likelyEOL = this.computeEOL(contentToPeekForEOL);
        contentToPeekForEOL.close();
        return likelyEOL;
    }

    private String computeEOL(InputStream contentToPeekForEOL) throws IOException {
        int linuxLF = 0;
        int windowsCRLF = 0;
        int macCR = 0;
        int MAX = 1000;
        int count = 0;
        while (contentToPeekForEOL.available() > 0 && count < MAX) {
            int c1;
            int c = contentToPeekForEOL.read();
            if (c == -1) continue;
            ++count;
            if (c == this.LF) {
                ++linuxLF;
                continue;
            }
            if (c != this.CR || (c1 = contentToPeekForEOL.read()) == -1) continue;
            ++count;
            if (c1 == this.LF) {
                ++windowsCRLF;
                continue;
            }
            if (c1 == this.CR) {
                ++macCR;
                ++macCR;
                continue;
            }
            ++macCR;
        }
        if (DEBUG) {
            System.out.println("linuxLF: " + linuxLF);
            System.out.println("windowsCRLF: " + windowsCRLF);
            System.out.println("macCR: " + macCR);
        }
        String result = null;
        result = linuxLF > windowsCRLF ? (linuxLF > macCR ? "" + (char)this.LF : "" + (char)this.CR) : (windowsCRLF > macCR ? "" + (char)this.CR + (char)this.LF : "" + (char)this.CR);
        return result;
    }

    private void closereader(BufferedReader br) {
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean copyLicenseHtml(IProject project) {
        boolean result;
        block12: {
            result = false;
            IFile license = project.getFile("license.html");
            InputStream licenseStream = this.getClass().getResourceAsStream("license.html");
            try {
                try {
                    license.setContents(licenseStream, true, true, null);
                    result = true;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    result = false;
                    if (licenseStream == null) break block12;
                    try {
                        licenseStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (licenseStream != null) {
                    try {
                        licenseStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    private boolean notequiv(String license, String standard) {
        String licensecleaned = license.trim().replaceAll("\\s+", " ");
        String standardcleaned = standard.trim().replaceAll("\\s+", " ");
        int diff = licensecleaned.compareTo(standardcleaned);
        if (DEBUG && diff != 0) {
            System.out.println("difference compare result: " + diff);
        }
        return diff != 0;
    }

    private void report(MessageConsoleStream out, ArrayList tocheck, String message) {
        if (tocheck != null && tocheck.size() > 0) {
            out.println();
            out.println("\t" + message);
            out.println("\t\tCount: " + tocheck.size());
            for (Object object : tocheck) {
                String name = null;
                name = object instanceof IProject ? ((IProject)object).getName() : ((SourceTemplateProject)object).getName();
                out.println("\t\t" + name);
            }
            out.println();
        }
    }

    private MessageConsole findConsole(String name) {
        MessageConsole myConsole = null;
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                myConsole = (MessageConsole)existing[i];
            }
            ++i;
        }
        if (myConsole == null) {
            myConsole = new MessageConsole(name, null);
            conMan.addConsoles(new IConsole[]{myConsole});
        }
        return myConsole;
    }

    private void fixup(IFile propfile, SourceTemplateProject project) throws IOException, CoreException {
        Properties featureproperties = new Properties();
        featureproperties.load(propfile.getContents());
        String license = featureproperties.getProperty(KEY_WORD);
        if (license == null) {
            this.featureProjectsMissingLicense.add(project);
        } else if (this.notequiv(license, this.getStandardLicense())) {
            if (this.rewrite(propfile, project)) {
                this.featuresModified.add(project);
                this.copyLicenseHtml(project);
            } else {
                this.featuresCouldNotBeModified.add(project);
            }
        } else {
            this.featuresOkNotModified.add(project);
        }
    }

    private boolean rewrite(IFile propfile, IProject project) throws CoreException, IOException {
        IFile featureProperties = project.getFile("feature.properties");
        return this.rewritecommon(featureProperties);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean rewritecommon(IFile featureProperties) throws CoreException, IOException {
        boolean result = false;
        InputStream standardInputStream = this.getClass().getResourceAsStream("standard.properties");
        String inferredEOL = this.inferEOL(featureProperties);
        BufferedReader br = null;
        StringWriter bw = null;
        boolean foundKey = false;
        try {
            File featurePropertiesFile = new File(featureProperties.getLocationURI());
            br = new BufferedReader(new FileReader(featurePropertiesFile));
            bw = new StringWriter();
            String oneline = null;
            do {
                if ((oneline = br.readLine()) == null) continue;
                if (oneline.matches(this.LICENSE_KEY)) {
                    foundKey = true;
                    while (oneline != null && oneline.matches(".*\\\\ *$")) {
                        oneline = br.readLine();
                    }
                    while (standardInputStream.available() > 0) {
                        int onechar = standardInputStream.read();
                        bw.write(onechar);
                    }
                } else {
                    bw.write(String.valueOf(oneline) + inferredEOL);
                }
            } while (oneline != null);
            this.closereader(br);
            if (!foundKey) {
                System.out.println("ERROR: Key/value was known to need rewrite, but we did not find key while trying to rewrite.");
                System.out.println("       This is likely due to non-standard (but legal) way of writing property keys and values");
                System.out.println("       Check file " + featureProperties.getLocation());
                result = false;
            } else {
                StringBufferInputStream newcontent = new StringBufferInputStream(bw.toString());
                featureProperties.setContents((InputStream)newcontent, true, true, null);
                result = true;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            result = false;
            this.closereader(br);
            if (standardInputStream == null) return result;
            try {
                standardInputStream.close();
                return result;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            result = false;
            return result;
        }
        catch (CoreException e) {
            e.printStackTrace();
            result = false;
            this.closereader(br);
            if (standardInputStream == null) return result;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            try {
                standardInputStream.close();
                return result;
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
            return result;
        }
        {
            finally {
                this.closereader(br);
                if (standardInputStream != null) {
                    try {
                        standardInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.closereader(br);
        if (standardInputStream == null) return result;
        try {
            standardInputStream.close();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean rewrite(IFile propfile, SourceTemplateProject project) throws CoreException, IOException {
        IFile featureProperties = project.getFile("feature.properties");
        return this.rewritecommon(featureProperties);
    }

    private boolean copyLicenseHtml(SourceTemplateProject project) {
        boolean result;
        block12: {
            result = false;
            IFile license = project.getFile("license.html");
            InputStream licenseStream = this.getClass().getResourceAsStream("license.html");
            try {
                try {
                    license.setContents(licenseStream, true, true, null);
                    result = true;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    result = false;
                    if (licenseStream == null) break block12;
                    try {
                        licenseStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (licenseStream != null) {
                    try {
                        licenseStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    class SourceTemplateProject {
        public String sourceTemplateDirectory = "sourceTemplateFeature/";
        IProject project;

        public SourceTemplateProject(IProject project) {
            this.project = project;
        }

        public IFile getFile(String filename) {
            return this.project.getFile(String.valueOf(this.sourceTemplateDirectory) + filename);
        }

        public String getName() {
            return String.valueOf(this.project.getName()) + "[sourceTemplateFeature]";
        }
    }
}

