/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import org.mortbay.log.Log;
import org.mortbay.log.StdErrLog;

public class Logger
extends StdErrLog {
    private static int DEBUG = 0;
    private static int INFO = 1;
    private static int WARN = 2;
    private static int ERROR = 3;
    private static int OFF = 4;
    private static volatile int threshold = WARN;
    private static Logger root;
    private String localName;
    static /* synthetic */ Class class$0;

    public static synchronized Logger getRootLogger() {
        if (root != null) {
            return root;
        }
        root = new Logger(null);
        return root;
    }

    public static void setThresholdLogger(String property) {
        threshold = Logger.parseThresholdProperty(property);
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        Thread thread = Thread.currentThread();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.slf4j.Logger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        thread.setContextClassLoader(clazz.getClassLoader());
        try {
            Log.getLog();
            if (root != null) {
                Log.setLog((org.mortbay.log.Logger)root);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    private static int parseThresholdProperty(String property) {
        if (property == null) {
            return WARN;
        }
        if (property.equals("debug")) {
            return DEBUG;
        }
        if (property.equals("info")) {
            return INFO;
        }
        if (property.equals("warn")) {
            return WARN;
        }
        if (property.equals("error")) {
            return ERROR;
        }
        if (property.equals("none")) {
            return OFF;
        }
        return WARN;
    }

    public Logger(String name) {
        super(name);
        this.localName = name;
        if (threshold == DEBUG) {
            this.setDebugEnabled(true);
        }
    }

    public org.mortbay.log.Logger getLogger(String name) {
        if (name == null && this.localName == null || name != null && name.equals(this.localName)) {
            return this;
        }
        return new Logger(name);
    }

    public void debug(String msg, Object arg0, Object arg1) {
        if (threshold > DEBUG) {
            return;
        }
        super.debug(msg, arg0, arg1);
    }

    public void debug(String msg, Throwable th) {
        if (threshold > DEBUG) {
            return;
        }
        super.debug(msg, th);
    }

    public void info(String msg, Object arg0, Object arg1) {
        if (threshold > INFO) {
            return;
        }
        super.info(msg, arg0, arg1);
    }

    public void warn(String msg, Object arg0, Object arg1) {
        if (threshold > WARN) {
            return;
        }
        super.warn(msg, arg0, arg1);
    }

    public void warn(String msg, Throwable th) {
        if (threshold > WARN) {
            return;
        }
        if (th instanceof RuntimeException || th instanceof Error) {
            super.warn("ERROR:  " + msg, th);
        } else if (threshold != ERROR) {
            super.warn(msg, th);
        }
    }

    public void error(String msg, Throwable th) {
        if (threshold > ERROR) {
            return;
        }
        super.warn("ERROR:  " + msg, th);
    }
}

