/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;

public class LaunchConfigurationTabGroupExtension {
    private IConfigurationElement fConfig = null;
    private List fModes = null;
    private Map fDescriptions = null;
    private Map fPerspectives = null;

    public LaunchConfigurationTabGroupExtension(IConfigurationElement element) {
        this.setConfigurationElement(element);
    }

    private void setConfigurationElement(IConfigurationElement element) {
        this.fConfig = element;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.fConfig;
    }

    protected List getModes() {
        if (this.fModes == null) {
            this.fModes = new ArrayList();
            this.fPerspectives = new Hashtable();
            IConfigurationElement[] modes = this.fConfig.getChildren("launchMode");
            if (modes.length > 0) {
                IConfigurationElement element = null;
                String perspective = null;
                String mode = null;
                HashSet<String> mset = null;
                int i = 0;
                while (i < modes.length) {
                    element = modes[i];
                    mode = element.getAttribute("mode");
                    mset = new HashSet<String>();
                    mset.add(mode);
                    this.fModes.add(mset);
                    perspective = element.getAttribute("perspective");
                    if (perspective != null) {
                        this.fPerspectives.put(mset, perspective);
                    }
                    ++i;
                }
            }
        }
        return this.fModes;
    }

    protected String getPerspective(Set modes) {
        this.getModes();
        return (String)this.fPerspectives.get(modes);
    }

    protected String getTypeIdentifier() {
        return this.getConfigurationElement().getAttribute("type");
    }

    protected String getHelpContextId() {
        return this.getConfigurationElement().getAttribute("helpContextId");
    }

    protected String getIdentifier() {
        return this.getConfigurationElement().getAttribute("id");
    }

    public ILaunchConfigurationTabGroup newTabGroup() throws CoreException {
        return (ILaunchConfigurationTabGroup)this.getConfigurationElement().createExecutableExtension("class");
    }

    public String getDescription(Set modes) {
        String description = null;
        if (this.fDescriptions == null) {
            this.fDescriptions = new HashMap();
            IConfigurationElement[] children = this.fConfig.getChildren("launchMode");
            IConfigurationElement child = null;
            String mode = null;
            HashSet<String> set = null;
            int i = 0;
            while (i < children.length) {
                child = children[i];
                mode = child.getAttribute("mode");
                if (mode != null) {
                    set = new HashSet<String>();
                    set.add(mode);
                }
                if ((description = child.getAttribute("description")) != null) {
                    this.fDescriptions.put(set, description);
                }
                ++i;
            }
        }
        if ((description = (String)this.fDescriptions.get(modes)) == null) {
            description = this.fConfig.getAttribute("description");
        }
        return description == null ? "" : description;
    }
}

