//-------------------------------------------------------------------------------
// abasic.h
//-------------------------------------------------------------------------------

#if !defined(__ABASIC_)
#define __ABASIC_

#include "./common.h"
#include "./calc.h"
#include "./vari.h"
#include "./variant.h"
#include "./variant_io.h"
#include "./st_inst.h"


#define EVAL			0x80000000
#define IF				0x20000000

//MAX 0xFF ʂɂ荶8Vtg
#define NOTHING		0x01

#define FOR				0x10
#define NEXT			0x11
#define GOTO			0x12
#define FUNC			0x13
#define RETURN			0x14
#define INPUT			0x15
#define OUTPUT			0x16
#define PRINT			0x17
#define CLR				0x18
#define LOCATION		0x19
#define WAIT			0x1A
#define ABS				0x1B
#define SHELL			0x1C
#define LEN				0x1D
#define MID				0x1E
#define VAL				0x1F
#define STR				0x20
#define CSV				0x21
#define CHOP			0x22
#define REPLACE			0x23
#define MATCH			0x24
#define VSC				0x25
#define ABASIC_FREAD	0x26
#define ABASIC_FWRITE	0x27
#define IF2				0x28
#define ELSE			0x29
#define TRIM			0x2A
#define LTRIM			0x2B
#define RTRIM			0x2C
#define LCASE			0x2D
#define UCASE			0x2E
#define LEFT			0x2F
#define RIGHT			0x30
#define JIS				0x31
#define ASC				0x32
#define INSTR			0x33
#define BLOCK_			0x34
#define _BLOCK			0x35
#define FORMAT			0x36

#define EXP				0xFE
#define MASK			0xFF


extern unsigned int p_counter; //vOJE^
extern std::map<std::string,std::string> variable_table;//̃}bv
extern std::vector<std::string> source; //basic̃vOi[z

int basic_init(char*filename);
void basic_setup();
void basic_start(int);
void basic_end();

#endif

//-------------------------------------------------------------------------------
