-----------------------------------------------------------------------------
-- Copyright 2004 The Apache Software Foundation
-- 
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
-- 
-- http://www.apache.org/licenses/LICENSE-2.0
-- 
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
-----------------------------------------------------------------------------

------------------------------------------------
-- JETSPEED_USER_PROFILE
------------------------------------------------
DROP TABLE JETSPEED_USER_PROFILE CASCADE CONSTRAINTS;
DROP SEQUENCE JETSPEED_USER_PROFILE_SEQ;

CREATE TABLE JETSPEED_USER_PROFILE
(
         USER_ID INT NOT NULL,
         LOGIN_NAME VARCHAR2 (32) NOT NULL,
         MEDIA_TYPE VARCHAR2(99),
         LANGUAGE VARCHAR2(99),
         COUNTRY  VARCHAR2(99),
         PAGE VARCHAR2(99),
         PROFILE LONG RAW,
         UNIQUE (LOGIN_NAME)
);

ALTER TABLE JETSPEED_USER_PROFILE
         ADD CONSTRAINT JETSPEED_USER_PROFILE_PK
PRIMARY KEY (USER_ID);

CREATE SEQUENCE JETSPEED_USER_PROFILE_SEQ;

------------------------------------------------
-- JETSPEED_GROUP_PROFILE
------------------------------------------------
DROP TABLE JETSPEED_GROUP_PROFILE CASCADE CONSTRAINTS;
DROP SEQUENCE JETSPEED_GROUP_PROFILE_SEQ;

CREATE TABLE JETSPEED_GROUP_PROFILE
(
         GROUP_ID INT NOT NULL,
         GROUP_NAME VARCHAR2 (99) NOT NULL,
         MEDIA_TYPE VARCHAR2(99),
         LANGUAGE VARCHAR2(99),
         COUNTRY  VARCHAR2(99),
         PAGE VARCHAR2(99),
         PROFILE LONG RAW,
         UNIQUE (GROUP_NAME)
);

ALTER TABLE JETSPEED_GROUP_PROFILE
         ADD CONSTRAINT JETSPEED_GROUP_PROFILE_PK
PRIMARY KEY (GROUP_ID);

CREATE SEQUENCE JETSPEED_GROUP_PROFILE_SEQ;

------------------------------------------------
-- JETSPEED_ROLE_PROFILE
------------------------------------------------
DROP TABLE JETSPEED_ROLE_PROFILE CASCADE CONSTRAINTS;
DROP SEQUENCE JETSPEED_ROLE_PROFILE_SEQ;

CREATE TABLE JETSPEED_ROLE_PROFILE
(
         ROLE_ID INT NOT NULL,
         ROLE_NAME VARCHAR2 (99) NOT NULL,
         MEDIA_TYPE VARCHAR2(99),
         LANGUAGE VARCHAR2(99),
         COUNTRY  VARCHAR2(99),
         PAGE VARCHAR2(99),
         PROFILE LONG RAW,
         UNIQUE (ROLE_NAME)
);

ALTER TABLE JETSPEED_ROLE_PROFILE
         ADD CONSTRAINT JETSPEED_ROLE_PROFILE_PK
PRIMARY KEY (ROLE_ID);

CREATE SEQUENCE JETSPEED_ROLE_PROFILE_SEQ;