/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jetspeed.services.search;

import java.net.URL;

import junit.awtui.TestRunner;
import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.test.HeadlessBaseTest;

/**
 * Test Search Service 
 *
 * @author <a href="paulsp@apache.org">Paul Spencer</a>
 * @author <a href="taylor@apache.org">David Sean Taylor</a>
 * 
 * @version $Id: TestSearch.java,v 1.1 2004/04/07 22:02:42 jford Exp $
 */
public class TestSearch extends HeadlessBaseTest
{
        
    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestSearch(String name)
    {
        super(name);
    }
    
    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[])
    {
        TestRunner.main(new String[] { TestSearch.class.getName() });
    }
    
    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite(TestSearch.class);
    }

    public void testRemoveWebPage() throws Exception
    {
        System.out.println("search home = " + JetspeedResources.getString("services.SearchService.directory"));
        URL jetspeedHomePage = new URL("http://jakarta.apache.org/jetspeed/");
        assertNotNull("Created URL to Jetspeed Home Page",  jetspeedHomePage);
        assertTrue("Removing non-existent index entry", Search.remove(jetspeedHomePage) == false);
        assertTrue("Adding to index", Search.add(jetspeedHomePage));
        assertTrue("Removing from index", Search.remove(jetspeedHomePage));
    }
    
    public void testPutWebPage() throws Exception
    {
        System.out.println("search home = " + JetspeedResources.getString("services.SearchService.directory"));
        URL jetspeedHomePage = new URL("http://jakarta.apache.org/jetspeed");
        assertNotNull("Created URL to Jetspeed Home Page",  jetspeedHomePage);
        assertTrue("Adding to index", Search.add(jetspeedHomePage));
        assertTrue("Adding to index", Search.add(new URL("http://www.google.com")));
        assertTrue("Adding to index", Search.add(new URL("http://jakarta.apache.org")));
    }
    
    /**
     *
     * @throws Exception
     */
    public void testVerifyJetspeedSearch() throws Exception
    {
        ParsedObject result = null;
        SearchResults results  = Search.search("rss");
        System.out.println("Query 'rss' hits = " + results.size());
        assertTrue(" Hit count > 0", results.size() > 0);
        for (int i = 0; i < results.size(); i++)
        {
            result = results.get(i);
            System.out.println("Score = " + result.getScore());
            System.out.println("title = " + result.getTitle());
            System.out.println("summary = " + result.getDescription());
            System.out.println("url = " + result.getURL());
        }
    }
    
    public void testVerifyJetspeedSearch1() throws Exception
    {
        ParsedObject result = null;
        SearchResults results  = Search.search("Jetspeed");
        System.out.println("Query 'Jetspeed' hits = " + results.size());
        assertTrue(" Hit count > 0", results.size() > 0);
        for (int i = 0; i < results.size(); i++)
        {
            result = results.get(i);
            System.out.println("Score = " + result.getScore());
            System.out.println("title = " + result.getTitle());
            System.out.println("summary = " + result.getDescription());
            System.out.println("url = " + result.getURL());
        }
    }
    
    public void testVerifyJetspeedSearch2() throws Exception
    {
        ParsedObject result = null;
        SearchResults results  = Search.search("google");
        System.out.println("Query 'goggle' hits = " + results.size());
        assertTrue(" Hit count > 0", results.size() > 0);
        for (int i = 0; i < results.size(); i++)
        {
            result = results.get(i);
            System.out.println("Score = " + result.getScore());
            System.out.println("title = " + result.getTitle());
            System.out.println("summary = " + result.getDescription());
            System.out.println("url = " + result.getURL());
        }
    }

}
