/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.util.rewriter;

import junit.framework.Test;
import junit.framework.TestSuite;
import java.io.Reader;
import java.io.StringReader;
import java.io.FileReader;
import java.io.BufferedReader;

// Jetspeed imports
import org.apache.jetspeed.test.JetspeedTestCase;

public class TestFrameRewriter extends JetspeedTestCase 
{
    static public Test suite()
    {
        TestSuite suite = new TestSuite(TestFrameRewriter.class);
        return(suite);
    }

    public TestFrameRewriter(String name)
    {
        super(name);
    }

    ///////////////////////////////////////////////////////////////////////////
            
    private String HTML = "";

    protected void setUp()
    {
        StringBuffer buffer = new StringBuffer("");
        try
        {
            FileReader fr = new FileReader("test/testdata/html/frameTest.html");
            BufferedReader br = new BufferedReader(fr);
            buffer = new StringBuffer();          //Create the Buffer to store the HTML
            String currentLine = br.readLine();
            buffer.append( currentLine );
            while (currentLine != null) 
            {
                currentLine = br.readLine();
                if ( currentLine == null )
                    continue;
                buffer.append( currentLine );       //Add the incoming lines to the buffer
            }
            br.close();            //Close the connection                
        } catch (Exception e)
        {
            System.err.println("Exception reading test data:" + e);
        }
        HTML = buffer.toString();
    }

    protected void tearDown()
    {
    }


    ///////////////////////////////////////////////////////////////////////////

    public void testFrames()
    {
        Reader reader = null;

        try 
        {
                    
            reader = new StringReader(HTML);                                           
            HTMLRewriter rewriter = new HTMLRewriter();
            String result = rewriter.rewrite(reader, null);
            System.out.println(result);
            reader.close();
            reader = null;

        } catch (Exception e) 
        {
            System.err.println("Exception occurred:" + e.toString());
            e.printStackTrace();
        }
        finally
        {
            try
            {
                if (null != reader)
                    reader.close();
            }
            catch (Exception e)
            {}
        }
    }

    ///////////////////////////////////////////////////////////////////////////

    static public void main(String[] argv)
    {
        String[] testCaseName = {TestFrameRewriter.class.getName()};
        junit.swingui.TestRunner.main(testCaseName);
    }

}