/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.tutorial.modules.actions.portlets;

import java.io.Serializable;
/**
 * Use this class to store extended info for your browser object
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: ExampleBrowserItem.java,v 1.1 2004/04/08 17:03:54 taylor Exp $
 */
public class ExampleBrowserItem implements Serializable
{
    boolean expanded = false;
    int checked = -1;
    int index = -1;
    int type = -3;
    int level = 0;
    ExampleBrowserItem parent = null;
    int oldChecked = -1;
        

    public ExampleBrowserItem()
    {
    }

    public void init(int type, 
                     int index, 
                     int level, 
                     boolean expanded, 
                     ExampleBrowserItem parent, 
                     int checked)
    {
        this.index = index;
        this.expanded = expanded;
        this.type = type;
        this.level = level;
        this.parent = parent;
        this.checked= checked;
        this.oldChecked = checked;
    }

    public boolean isExpanded()
    {
        return this.expanded;
    }

    public boolean isChecked()
    {
        return (this.checked > -1);
    }

    public boolean isOldChecked()
    {
        return (this.oldChecked > -1);
    }

    public void toggleExpanded()
    {
        this.expanded = !this.expanded;
    }

    public void setExpanded(boolean expanded)
    {
        this.expanded = expanded;
    }

    public boolean getExpanded()
    {
        return this.expanded;
    }

    public int getIndex()
    {
        return this.index;
    }

    public int getType()
    {
        return this.type;
    }

    public void setChecked(int checked)
    {
        this.checked = checked;
    }

    public void setOldChecked(int oldChecked)
    {
        this.oldChecked = oldChecked;
    }

    public int getLevel()
    {
        return this.level;
    }

    public ExampleBrowserItem getParent()
    {
        return this.parent;
    }

    public void setLevel(int level)
    {
        this.level = level;
    }
}


