#!/bin/sh

if [ $# -eq 1 ]; then
if [ -d $1 ]; then
if [ -e $1/tomcat/webapps/aipo/WEB-INF/conf/AipoResources.properties ]; then
parent_dir=$1

. /etc/sysconfig/network-scripts/ifcfg-eth0
addr=$IPADDR
if [ "$addr" = "" ]; then
	addr=`ifconfig eth0 | grep "inet addr" | cut -f 2 -d :| cut -f 1 -d " "`
fi

#///////////////////////////////////////////////
# 設定に必要な変数をセット
#///////////////////////////////////////////////
#Aipoバージョン
aipo_version="5.1.1.0"
aipo_version_int="5110"
# 最大ループ回数
Max_Loop="100"

#ユーザ確認
current_user=`whoami`
if [ "${current_user}" != "root" ]; then
    echo "Aipo$aipo_versionのインストールはroot権限で行ってください。"
    exit 0
fi

#Old Version
tmp_str=`cat ${parent_dir}/tomcat/webapps/aipo/WEB-INF/conf/AipoResources.properties | grep aipo.version=`
old_version=`echo "$tmp_str" | cut -f 2 -d "="`
isCR=`expr match $old_version .*[0-9]$ `
if [ "$isCR" = "0" ]; then
    len=`expr length $old_version`
    len=`expr $len - 1`
    old_version=`expr substr $old_version 1 $len`
fi
echo $old_version

#バックアップフォルダ作成
mkdir -p ${script_path}/backup
bk_dir=${script_path}/backup

#///////////////////////////////////////////////
#復元
#///////////////////////////////////////////////
function restorefunc
{
    alias cp='cp'
    if [ -d $bk_dir/tomcat/ ]; then
       if [ -e $parent_dir/tomcat/webapps ]; then
            mv $parent_dir/tomcat/webapps $parent_dir/tomcat/webappsbk${date_str}
       fi
       cp -rf  $bk_dir/tomcat/webapps $parent_dir/tomcat/
    fi

    #起動スクリプト差し戻し
    if [ -d $bk_dir/bin ]; then
       cp -rf  $bk_dir/bin/* $parent_dir/bin/
    fi

    sudo -u $postgres_user $parent_dir/postgres/bin/pg_ctl -D $parent_dir/postgres/data -o "-S -i" stop

    echo "Aipo$aipo_versionへのアップデートに失敗しました。"
    alias cp='cp -i'
    exit 1
}

function restoreDBfunc
{
    echo "データベースの復元を開始します。"
    #org001をリネームしてorg001failedを作成
    sudo -u $postgres_user $parent_dir/postgres/bin/psql -p $port_num -d org001bk${date_str} -c "ALTER DATABASE org001 RENAME TO org001failed${date_str};"
    #org001bk${date_str}をコピーしてorg001を復元
    sudo -u $postgres_user $parent_dir/postgres/bin/psql -p $port_num -d org001bk${date_str} -c "CREATE DATABASE org001 TEMPLATE org001bk${date_str};"
    if [ $? != 0 ]; then
       echo "データベースの復元に失敗しました。"
       restorefunc
    fi
    echo "データベースの復元を終了しました。"
    restorefunc
}

#///////////////////////////////////////////////
# Aipoバージョン確認
#///////////////////////////////////////////////
if [ "$old_version" = "$aipo_version" ]; then
	echo "既にAipo$aipo_versionがインストールされています。"
	exit 0
fi

if [  "${old_version}" = "5.0.0.0" -o  "${old_version}" = "5.0.1.0" -o  "${old_version}" = "5.0.2.0" -o  "${old_version}" = "5.1.0.0" -o  "${old_version}" = "5.1.0.1" -o  1 = 2 ]; then

tmp_str=`cat $parent_dir/bin/startup.sh | grep "s_port_num="`
s_port_num=`echo "$tmp_str" | cut -f 2 -d "="`

#以前のバージョンのPostgreSQLユーザー情報を取得
echo "PostgreSQLのユーザー情報を取得しています"
tmp_str=`cat $parent_dir/tomcat/webapps/aipo/WEB-INF/conf/postgres/Org001DomainNode.driver.xml | grep login`
postgres_user=`echo "$tmp_str" | cut -f 2 -d " " | cut -f 2 -d = | cut -f 2 -d \"`
echo user:$postgres_user
pass=`echo "$tmp_str" | cut -f 3 -d " " | cut -f 2 -d = | cut -f 1 -d \\/ | cut -f 2 -d \"`
echo passwd:$pass

tmp_str=`cat $parent_dir/tomcat/webapps/aipo/WEB-INF/conf/postgres/Org001DomainNode.driver.xml | grep url`
port_num=`echo "$tmp_str" | cut -f 4 -d ":" | cut -f 1 -d \\/ `
echo port:$port_num

unset tmp_str

sh $parent_dir/bin/shutdown.sh

#PostgreSQLの起動
sudo -u $postgres_user $parent_dir/postgres/bin/postmaster -p $port_num -D $parent_dir/postgres/data -S -i
#wait
prc_name="$parent_dir/postgres/bin/postmaster"
count=0
while [ $count -lt $Max_Loop ]; do
    tmp_str=`ps auxww | grep $prc_name`
    tmp_str=`echo $tmp_str`
    pid_str=`echo "$tmp_str" | cut -f 2 -d " "`
    tmp_str=`netstat -nap | grep "ESTABLISHED $pid_str"`
    if [ "$tmp_str" != "" ]; then
        echo $tmp_str
        break
    fi
    count=`expr $count + 1`
done

#バックアップ
mkdir -p $bk_dir/tomcat/
cp -rf $parent_dir/tomcat/webapps $bk_dir/tomcat/
#データベースのコピー
date_str=`date +"%Y%m%d%H%M"`
sudo -u $postgres_user $parent_dir/postgres/bin/psql -p $port_num -d org001 -c "CREATE DATABASE org001bk${date_str} TEMPLATE org001;"
#pgpassの更新
sudo -u ${postgres_user} echo "localhost:$port_num:org001bk${date_str}:${postgres_user}:$pass" >> /home/${postgres_user}/.pgpass
chown ${postgres_user}:${postgres_user} /home/${postgres_user}/.pgpass
sudo -u ${postgres_user} chmod 0600 /home/${postgres_user}/.pgpass

#コピー用意
alias cp='cp'
tmp_version=$old_version

else

#アップデート対象外
echo "Aipo$old_versionはこのアップデータには対応しておりません。"
exit 1

fi



#///////////////////////////////////////////////
# 5.0.0.0 to 5.0.1.0
#///////////////////////////////////////////////

if [  "${old_version}" = "5.0.0.0" -o  1 = 2 ]; then


    #///////////////////////////////////////////////
    # データベースの更新
    #///////////////////////////////////////////////

    #UPDATE DATA BASE By PSQL
    cd ${script_path}/sql
    sudo -u $postgres_user ${parent_dir}/postgres/bin/psql -p $port_num -d org001 -f aipo5010update.sql

    if [ $? != 0 ]; then
       restorefunc
    fi

    #テーブル構造検証
    echo "テーブル構造の検証を開始します。"
    sudo -u $postgres_user ${parent_dir}/postgres/bin/psql -p $port_num -d org001 -f ${script_path}/sql/select_tables.sql > ${script_path}/check_table.txt

    if [ $? != 0 ] || [ ! -e ${script_path}/check_table.txt ]; then
        echo "テーブル構造の検証に失敗しました。"
        restoreDBfunc
    fi

    diff_result=`diff -Bw ${script_path}/table_dump/table_dump5010 ${script_path}/check_table.txt`
    if [ "$diff_result" != "" ]; then
        echo "データベースの更新に失敗した可能性があります。"
        restoreDBfunc
    fi
    echo "テーブル構造の検証を完了しました。"
    rm ${script_path}/check_table.txt

    # UPDATE PSML
    cd ${script_path}/webapps/aipo/WEB-INF/lib
    ${parent_dir}/jre/bin/java -cp "${script_path}/lib/aipo-update-1.0-SNAPSHOT.jar":"./aipo-core-5.1.1.jar":"./aipo-jetspeed-5.1.1.jar":"./turbine-2.2-al1.jar":"./cayenne-2.0.4.jar":"./castor-0.9.3.jar":"./xercesImpl-2.0.2.jar":"./log4j-1.2.9.jar" com.aimluck.eip.update.Migration5000to5010 ${parent_dir}/tomcat/webapps "" ${script_path}/webapps
    if [ $? != 0 ]; then
        restorefunc
    fi

    tmp_version="5.0.1.0"


fi


#///////////////////////////////////////////////
# 5.0.1.0 to 5.0.2.0
#///////////////////////////////////////////////

if [  "${old_version}" = "5.0.0.0" -o  "${old_version}" = "5.0.1.0" -o  1 = 2 ]; then


    #///////////////////////////////////////////////
    # データベースの更新
    #///////////////////////////////////////////////

    #UPDATE DATA BASE By PSQL
    cd ${script_path}/sql
    sudo -u $postgres_user ${parent_dir}/postgres/bin/psql -p $port_num -d org001 -f aipo5020update.sql

    if [ $? != 0 ]; then
       restorefunc
    fi

    #テーブル構造検証
    echo "テーブル構造の検証を開始します。"
    sudo -u $postgres_user ${parent_dir}/postgres/bin/psql -p $port_num -d org001 -f ${script_path}/sql/select_tables.sql > ${script_path}/check_table.txt

    if [ $? != 0 ] || [ ! -e ${script_path}/check_table.txt ]; then
        echo "テーブル構造の検証に失敗しました。"
        restoreDBfunc
    fi

    diff_result=`diff -Bw ${script_path}/table_dump/table_dump5020 ${script_path}/check_table.txt`
    if [ "$diff_result" != "" ]; then
        echo "データベースの更新に失敗した可能性があります。"
        restoreDBfunc
    fi
    echo "テーブル構造の検証を完了しました。"
    rm ${script_path}/check_table.txt

    # UPDATE PSML
    cd ${script_path}/webapps/aipo/WEB-INF/lib
    ${parent_dir}/jre/bin/java -cp "${script_path}/lib/aipo-update-1.0-SNAPSHOT.jar":"./aipo-core-5.1.1.jar":"./aipo-jetspeed-5.1.1.jar":"./turbine-2.2-al1.jar":"./cayenne-2.0.4.jar":"./castor-0.9.3.jar":"./xercesImpl-2.0.2.jar":"./log4j-1.2.9.jar" com.aimluck.eip.update.Migration5010to5020 ${parent_dir}/tomcat/webapps "" ${script_path}/webapps
    if [ $? != 0 ]; then
        restorefunc
    fi

    tmp_version="5.0.2.0"


fi


#///////////////////////////////////////////////
# 5.0.2.0 to 5.1.0.0
#///////////////////////////////////////////////

if [  "${old_version}" = "5.0.0.0" -o  "${old_version}" = "5.0.1.0" -o  "${old_version}" = "5.0.2.0" -o  1 = 2 ]; then


    #///////////////////////////////////////////////
    # データベースの更新
    #///////////////////////////////////////////////

    #UPDATE DATA BASE By PSQL
    cd ${script_path}/sql
    sudo -u $postgres_user ${parent_dir}/postgres/bin/psql -p $port_num -d org001 -f aipo5100update.sql

    if [ $? != 0 ]; then
       restorefunc
    fi

    #テーブル構造検証
    echo "テーブル構造の検証を開始します。"
    sudo -u $postgres_user ${parent_dir}/postgres/bin/psql -p $port_num -d org001 -f ${script_path}/sql/select_tables.sql > ${script_path}/check_table.txt

    if [ $? != 0 ] || [ ! -e ${script_path}/check_table.txt ]; then
        echo "テーブル構造の検証に失敗しました。"
        restoreDBfunc
    fi

    diff_result=`diff -Bw ${script_path}/table_dump/table_dump5100 ${script_path}/check_table.txt`
    if [ "$diff_result" != "" ]; then
        echo "データベースの更新に失敗した可能性があります。"
        restoreDBfunc
    fi
    echo "テーブル構造の検証を完了しました。"
    rm ${script_path}/check_table.txt

    # UPDATE PSML
    cd ${script_path}/webapps/aipo/WEB-INF/lib
    ${parent_dir}/jre/bin/java -cp "${script_path}/lib/aipo-update-1.0-SNAPSHOT.jar":"./aipo-core-5.1.1.jar":"./aipo-jetspeed-5.1.1.jar":"./turbine-2.2-al1.jar":"./cayenne-2.0.4.jar":"./castor-0.9.3.jar":"./xercesImpl-2.0.2.jar":"./log4j-1.2.9.jar" com.aimluck.eip.update.Migration5020to5100 ${parent_dir}/tomcat/webapps "" ${script_path}/webapps
    if [ $? != 0 ]; then
        restorefunc
    fi

    tmp_version="5.1.0.0"


fi


#///////////////////////////////////////////////
# 5.1.0.0 to 5.1.0.1
#///////////////////////////////////////////////

if [  "${old_version}" = "5.0.0.0" -o  "${old_version}" = "5.0.1.0" -o  "${old_version}" = "5.0.2.0" -o  "${old_version}" = "5.1.0.0" -o  1 = 2 ]; then


    #///////////////////////////////////////////////
    # データベースの更新
    #///////////////////////////////////////////////

    #UPDATE DATA BASE By PSQL
    cd ${script_path}/sql
    sudo -u $postgres_user ${parent_dir}/postgres/bin/psql -p $port_num -d org001 -f aipo5101update.sql

    if [ $? != 0 ]; then
       restorefunc
    fi

    #テーブル構造検証
    echo "テーブル構造の検証を開始します。"
    sudo -u $postgres_user ${parent_dir}/postgres/bin/psql -p $port_num -d org001 -f ${script_path}/sql/select_tables.sql > ${script_path}/check_table.txt

    if [ $? != 0 ] || [ ! -e ${script_path}/check_table.txt ]; then
        echo "テーブル構造の検証に失敗しました。"
        restoreDBfunc
    fi

    diff_result=`diff -Bw ${script_path}/table_dump/table_dump5101 ${script_path}/check_table.txt`
    if [ "$diff_result" != "" ]; then
        echo "データベースの更新に失敗した可能性があります。"
        restoreDBfunc
    fi
    echo "テーブル構造の検証を完了しました。"
    rm ${script_path}/check_table.txt

    # UPDATE PSML
    cd ${script_path}/webapps/aipo/WEB-INF/lib
    ${parent_dir}/jre/bin/java -cp "${script_path}/lib/aipo-update-1.0-SNAPSHOT.jar":"./aipo-core-5.1.1.jar":"./aipo-jetspeed-5.1.1.jar":"./turbine-2.2-al1.jar":"./cayenne-2.0.4.jar":"./castor-0.9.3.jar":"./xercesImpl-2.0.2.jar":"./log4j-1.2.9.jar" com.aimluck.eip.update.Migration5100to5101 ${parent_dir}/tomcat/webapps "" ${script_path}/webapps
    if [ $? != 0 ]; then
        restorefunc
    fi

    tmp_version="5.1.0.1"


fi


#///////////////////////////////////////////////
# 5.1.0.1 to 5.1.1.0
#///////////////////////////////////////////////

if [  "${old_version}" = "5.0.0.0" -o  "${old_version}" = "5.0.1.0" -o  "${old_version}" = "5.0.2.0" -o  "${old_version}" = "5.1.0.0" -o  "${old_version}" = "5.1.0.1" -o  1 = 2 ]; then

    #///////////////////////////////////////////////
    # ファイルのコピー
    #///////////////////////////////////////////////

    # ワークスペースpsmlをバックアップする
    cp -rf $parent_dir/tomcat/webapps/aipo/WEB-INF/psml ${script_path}/tmp_psml

    rm -rf $parent_dir/tomcat/webapps/aipo
    mkdir $parent_dir/tomcat/webapps/aipo
    cp -rf ${script_path}/webapps/aipo/* $parent_dir/tomcat/webapps/aipo/

    rm -rf $parent_dir/backup/xreg
    mkdir $parent_dir/backup/xreg
    cp -rf ${script_path}/webapps/aipo/WEB-INF/conf/*.xreg $parent_dir/backup/xreg/

    # 旧ファイルから、必要なファイルだけを戻す
    cp -rf $bk_dir/tomcat/webapps/aipo/WEB-INF/conf/postgres/Org001DomainNode.driver.xml $parent_dir/tomcat/webapps/aipo/WEB-INF/conf/postgres/Org001DomainNode.driver.xml
    mkdir -p $parent_dir/tomcat/webapps/aipo/WEB-INF/files/
    cp -rf $bk_dir/tomcat/webapps/aipo/WEB-INF/files/* $parent_dir/tomcat/webapps/aipo/WEB-INF/files/

    # psmlはワークスペースのバックアップから行い、その後新しいpsmlを上書きする
    mkdir -p $parent_dir/tomcat/webapps/aipo/WEB-INF/psml/
    cp -rf ${script_path}/tmp_psml/* $parent_dir/tomcat/webapps/aipo/WEB-INF/psml/
    cp -rf ${script_path}/webapps/aipo/WEB-INF/psml/* $parent_dir/tomcat/webapps/aipo/WEB-INF/psml/

    mkdir -p $parent_dir/tomcat/webapps/aipo/WEB-INF/mail/
    cp -rf $bk_dir/tomcat/webapps/aipo/WEB-INF/mail/* $parent_dir/tomcat/webapps/aipo/WEB-INF/mail/

    # 休日設定のファイルを上書きする
    cp -f $bk_dir/tomcat/webapps/aipo/WEB-INF/conf/holidays_user.properties $parent_dir/tomcat/webapps/aipo/WEB-INF/conf/

    #///////////////////////////////////////////////
    # データベースの更新
    #///////////////////////////////////////////////

    #UPDATE DATA BASE By PSQL
    cd ${script_path}/sql
    sudo -u $postgres_user ${parent_dir}/postgres/bin/psql -p $port_num -d org001 -f aipo5110update.sql

    if [ $? != 0 ]; then
       restorefunc
    fi

    #テーブル構造検証
    echo "テーブル構造の検証を開始します。"
    sudo -u $postgres_user ${parent_dir}/postgres/bin/psql -p $port_num -d org001 -f ${script_path}/sql/select_tables.sql > ${script_path}/check_table.txt

    if [ $? != 0 ] || [ ! -e ${script_path}/check_table.txt ]; then
        echo "テーブル構造の検証に失敗しました。"
        restoreDBfunc
    fi

    diff_result=`diff -Bw ${script_path}/table_dump/table_dump5110 ${script_path}/check_table.txt`
    if [ "$diff_result" != "" ]; then
        echo "データベースの更新に失敗した可能性があります。"
        restoreDBfunc
    fi
    echo "テーブル構造の検証を完了しました。"
    rm ${script_path}/check_table.txt

    # UPDATE PSML
    cd ${script_path}/webapps/aipo/WEB-INF/lib
    ${parent_dir}/jre/bin/java -cp "${script_path}/lib/aipo-update-1.0-SNAPSHOT.jar":"./aipo-core-5.1.1.jar":"./aipo-jetspeed-5.1.1.jar":"./turbine-2.2-al1.jar":"./cayenne-2.0.4.jar":"./castor-0.9.3.jar":"./xercesImpl-2.0.2.jar":"./log4j-1.2.9.jar" com.aimluck.eip.update.Migration5101to5110 ${parent_dir}/tomcat/webapps "" ${script_path}/webapps
    if [ $? != 0 ]; then
        restorefunc
    fi

    tmp_version="5.1.1.0"

    #///////////////////////////////////////////////
    # ライセンスファイル更新
    #///////////////////////////////////////////////

    cp -rf ${script_path}/license/license.txt ${parent_dir}/license/

    #///////////////////////////////////////////////
    # 実行用スクリプト生成
    #///////////////////////////////////////////////

    echo "${parent_dir}" | sed s/'\/'/'\\\/'/g > temp.txt
    tmp_str=`cat temp.txt`
    rm -rf temp.txt
    echo $tmp_str

    mkdir -p $bk_dir/bin
    cp -rf ${parent_dir}/bin/*.sh $bk_dir/bin/

    cd ${script_path}/src/bin/${enc_str}
    for FILE in *.sh; do
    	mv -f ${parent_dir}/bin/$FILE $bk_dir/bin/$FILE
    	sed "s/default_folder/$tmp_str/g" ${parent_dir}/src/bin/${enc_str}/$FILE | sed "s/default_user/$postgres_user/g" | sed "s/default_server_port/$s_port_num/g" | sed "s/default_db_port/$port_num/g" | sed "s/postgres_pass/$pass/g" | sed "s/Aipo_Version/$aipo_version/g" > ${parent_dir}/bin/$FILE
    done

    chmod +x ${parent_dir}/bin/*.sh

fi


alias cp='cp -i'

if [ "$tmp_version" != "$aipo_version" ]; then
    restorefunc
fi

#///////////////////////////////////////////////
# 終了処理
#///////////////////////////////////////////////

sudo -u $postgres_user ${parent_dir}/postgres/bin/pg_ctl -D ${parent_dir}/postgres/data -o "-S -i" stop
#wait

#///////////////////////////////////////////////
# 結果表示
#///////////////////////////////////////////////
echo ==Aipo"$aipo_version"アップデート終了==
echo user:$postgres_user
echo pass:$pass
echo directory:${parent_dir}
echo port:$port_num
echo "Aipo URL: http://$addr:$s_port_num/aipo/"

else
 echo "The input directory is wrong."
fi

else
 echo "No folder."
fi

else
 echo "Please input the directory of aipo."
fi