-----------------------------------------------------------------------------
-- 5.0.2.0 --> 5.1.0.0
-----------------------------------------------------------------------------

-----------------------------------------------------------------------------
-- EIP_T_MAIL_FOLDER
-----------------------------------------------------------------------------
CREATE TABLE EIP_T_MAIL_FOLDER
(
    FOLDER_ID serial,
    ACCOUNT_ID INTEGER,
    FOLDER_NAME varchar,
    CREATE_DATE DATE,
    UPDATE_DATE TIMESTAMP,
    PRIMARY KEY (FOLDER_ID)
);


-----------------------------------------------------------------------------
-- EIP_T_MAIL_FILTER
-----------------------------------------------------------------------------
CREATE TABLE EIP_T_MAIL_FILTER
(
    FILTER_ID serial,
    ACCOUNT_ID INTEGER,
    DST_FOLDER_ID INTEGER,
    FILTER_NAME varchar,
    FILTER_STRING varchar,
    FILTER_TYPE char(1),
    SORT_ORDER INTEGER,
    CREATE_DATE DATE,
    UPDATE_DATE TIMESTAMP,
    PRIMARY KEY (FILTER_ID)
);


ALTER TABLE EIP_M_MAIL_ACCOUNT ADD SMTP_ENCRYPTION_FLG smallint;
ALTER TABLE EIP_M_MAIL_ACCOUNT ADD POP3_ENCRYPTION_FLG smallint;
ALTER TABLE EIP_M_MAIL_ACCOUNT ADD DEFAULT_FOLDER_ID INTEGER;

ALTER TABLE EIP_T_MAIL ADD FOLDER_ID INTEGER;

INSERT INTO EIP_T_MAIL_FOLDER ( ACCOUNT_ID ) ( SELECT ACCOUNT_ID FROM EIP_M_MAIL_ACCOUNT );

UPDATE EIP_T_MAIL_FOLDER SET FOLDER_NAME = '受信トレイ', CREATE_DATE = NOW() , UPDATE_DATE = NOW();

UPDATE EIP_T_MAIL SET FOLDER_ID = ( SELECT EIP_T_MAIL_FOLDER.FOLDER_ID FROM EIP_T_MAIL_FOLDER WHERE EIP_T_MAIL_FOLDER.ACCOUNT_ID = EIP_T_MAIL.ACCOUNT_ID);

ALTER TABLE EIP_T_MAIL ALTER COLUMN FOLDER_ID SET NOT NULL;

UPDATE EIP_M_MAIL_ACCOUNT SET DEFAULT_FOLDER_ID = ( SELECT EIP_T_MAIL_FOLDER.FOLDER_ID FROM EIP_T_MAIL_FOLDER WHERE EIP_T_MAIL_FOLDER.ACCOUNT_ID = EIP_M_MAIL_ACCOUNT.ACCOUNT_ID);

UPDATE EIP_M_MAIL_ACCOUNT SET SMTP_ENCRYPTION_FLG = 0, POP3_ENCRYPTION_FLG = 0;
