select  c.relname
       ,a.attname
       ,format_type(a.atttypid, a.atttypmod) AS dataname
  from pg_class     as c
      ,pg_attribute as a
      ,pg_namespace as n
 where
       c.oid = a.attrelid
   and n.nspname='public'
   and c.relnamespace = n.oid
   and a.attnum > 0
   and c.relkind = 'r' 
   and a.attname not like '%pg.dropped%'
 order by c.relname, a.attname
