/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

class TabBorder
extends TitleBarBorder {
    private Rectangle tabRect;

    TabBorder() {
        this.setBackgroundColor(ColorConstants.button);
        this.setTextColor(ColorConstants.black);
        this.setPadding(4);
    }

    protected Insets calculateInsets(IFigure figure) {
        return new Insets(this.getTextExtents((IFigure)figure).height + this.getPadding().getHeight() - 2, 0, 0, 0);
    }

    public boolean containsPoint(int x, int y) {
        if (this.tabRect == null) {
            return false;
        }
        return this.tabRect.contains(x, y);
    }

    public Dimension getPreferredSize(IFigure fig) {
        return super.getPreferredSize(fig).expand(this.getPadding().getWidth(), this.getPadding().getHeight() - 2);
    }

    public void paint(IFigure figure, Graphics g, Insets insets) {
        Rectangle paintRect = TabBorder.getPaintRectangle(figure, insets);
        Insets padding = this.getPadding();
        Dimension textExtents = this.getTextExtents(figure);
        Rectangle rec = paintRect.getCopy();
        rec.height = Math.min(rec.height, textExtents.height + padding.getHeight());
        rec.width = Math.min(rec.width, textExtents.width + padding.getWidth());
        rec.x = paintRect.x + paintRect.width - rec.width;
        this.setTabRectangle(rec);
        PointList list = new PointList();
        list.addPoint(rec.x, rec.y + rec.height);
        list.addPoint(rec.x, rec.y + 2);
        list.addPoint(rec.x + 2, rec.y);
        list.addPoint(rec.x + rec.width - 3, rec.y);
        list.addPoint(rec.x + rec.width - 1, rec.y + 2);
        list.addPoint(rec.x + rec.width - 1, rec.y + rec.height);
        g.setBackgroundColor(this.getBackgroundColor());
        g.fillPolygon(list);
        int x = rec.x + padding.left;
        int y = rec.y + padding.top;
        g.setFont(this.getFont(figure));
        g.setForegroundColor(this.getTextColor());
        g.drawString(this.getLabel(), x, y);
        g.setForegroundColor(ColorConstants.buttonLightest);
        g.setLineStyle(1);
        PointList whiteLineList = new PointList();
        Point pt = list.getPoint(0);
        --pt.y;
        whiteLineList.addPoint(pt);
        pt = new Point(pt);
        ++pt.x;
        whiteLineList.addPoint(pt);
        pt = list.getPoint(1);
        ++pt.x;
        whiteLineList.addPoint(pt);
        pt = list.getPoint(2);
        ++pt.y;
        whiteLineList.addPoint(pt);
        pt = list.getPoint(3);
        ++pt.y;
        whiteLineList.addPoint(pt);
        g.drawPolyline(whiteLineList);
        g.setForegroundColor(ColorConstants.buttonDarkest);
        list.removePoint(2);
        list.removePoint(1);
        list.removePoint(0);
        g.drawPolyline(list);
    }

    private void setTabRectangle(Rectangle r) {
        this.tabRect = new Rectangle(r);
    }
}

