/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.text.BlockBox;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.CompositeBox;
import org.eclipse.draw2d.text.FlowContainerLayout;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.LineRoot;

public class BlockFlowLayout
extends FlowContainerLayout {
    BlockBox blockBox;
    boolean blockInvalid = false;
    private boolean continueOnSameLine = false;
    private CompositeBox previousLine = null;

    public BlockFlowLayout(BlockFlow blockFlow) {
        super(blockFlow);
    }

    private void addBelowPreviousLine(CompositeBox line) {
        if (this.previousLine == null) {
            line.setLineTop(line.getTopMargin());
        } else {
            line.setLineTop(this.previousLine.getBaseline() + this.previousLine.getDescent() + Math.max(this.previousLine.getBottomMargin(), line.getTopMargin()));
        }
        int alignment = this.getBlockFlow().getHorizontalAligment();
        if (alignment == 1 || alignment == 4) {
            int orientation = this.getBlockFlow().getOrientation();
            if (alignment == 1) {
                alignment = orientation == 0x2000000 ? 64 : 128;
            } else {
                int n = alignment = orientation == 0x2000000 ? 128 : 64;
            }
        }
        if (alignment != 2 && this.getBlockFlow().isMirrored()) {
            alignment = 0xC0 & ~alignment;
        }
        switch (alignment) {
            case 128: {
                line.setX(this.blockBox.getRecommendedWidth() - line.getWidth());
                break;
            }
            case 2: {
                line.setX((this.blockBox.getRecommendedWidth() - line.getWidth()) / 2);
                break;
            }
            case 64: {
                line.setX(0);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected state");
            }
        }
        this.blockBox.add(line);
        this.previousLine = line;
    }

    protected void addCurrentLine() {
        this.addBelowPreviousLine(this.currentLine);
        ((LineRoot)this.currentLine).commit();
    }

    public void addLine(CompositeBox box) {
        this.endLine();
        this.addBelowPreviousLine(box);
    }

    public void blockContentsChanged() {
        this.blockInvalid = true;
    }

    protected void cleanup() {
        super.cleanup();
        this.previousLine = null;
    }

    protected void createNewLine() {
        this.currentLine = new LineRoot(this.getBlockFlow().isMirrored());
        this.currentLine.setRecommendedWidth(this.blockBox.getRecommendedWidth());
    }

    protected void endBlock() {
        if (this.blockInvalid) {
            Insets insets = this.getBlockFlow().getInsets();
            this.blockBox.height += insets.getHeight();
            this.blockBox.width += insets.getWidth();
        }
        if (this.getContext() != null) {
            this.getContext().addLine(this.blockBox);
        }
        if (this.blockInvalid) {
            this.blockInvalid = false;
            List v = this.getFlowFigure().getChildren();
            int i = 0;
            while (i < v.size()) {
                ((FlowFigure)v.get(i)).postValidate();
                ++i;
            }
        }
    }

    public void endLine() {
        if (this.currentLine == null || !this.currentLine.isOccupied()) {
            return;
        }
        this.addCurrentLine();
        this.currentLine = null;
    }

    protected void flush() {
        this.endLine();
        this.endBlock();
    }

    boolean forceChildInvalidation(Figure f) {
        return this.blockInvalid;
    }

    protected final BlockFlow getBlockFlow() {
        return (BlockFlow)this.getFlowFigure();
    }

    int getContextWidth() {
        return this.getContext().getRemainingLineWidth();
    }

    public boolean getContinueOnSameLine() {
        return this.continueOnSameLine;
    }

    public void getWidthLookahead(FlowFigure child, int[] result) {
        List children = this.getFlowFigure().getChildren();
        int index = -1;
        if (child != null) {
            index = children.indexOf(child);
        }
        int i = index + 1;
        while (i < children.size()) {
            if (((FlowFigure)children.get(i)).addLeadingWordRequirements(result)) {
                return;
            }
            ++i;
        }
    }

    protected void preLayout() {
        this.setContinueOnSameLine(false);
        this.blockBox = this.getBlockFlow().getBlockBox();
        this.setupBlock();
    }

    public void setContinueOnSameLine(boolean value) {
        this.continueOnSameLine = value;
    }

    protected void setupBlock() {
        int recommended = this.getContextWidth();
        if (recommended == Integer.MAX_VALUE) {
            recommended = -1;
        }
        BlockFlow bf = this.getBlockFlow();
        if (recommended > 0) {
            int borderCorrection = bf.getInsets().getWidth() + bf.getLeftMargin() + bf.getRightMargin();
            recommended = Math.max(0, recommended - borderCorrection);
        }
        if (recommended != this.blockBox.recommendedWidth) {
            this.blockInvalid = true;
            this.blockBox.setWidth(Math.max(0, recommended));
            this.blockBox.setRecommendedWidth(recommended);
        }
        if (this.blockInvalid) {
            this.blockBox.height = 0;
        }
    }
}

