/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.security;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Security;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.security.KeystoreHandle;

public class KeyStores {
    private static final String JAVA_POLICY_URL = "policy.url.";
    private static final String DEFAULT_KEYSTORE_TYPE = "keystore.type";
    private List listOfKeyStores;
    private Iterator iterator;

    public KeyStores() {
        this.initializeDefaultKeyStores();
    }

    private Iterator getIterator() {
        if (this.iterator == null) {
            this.iterator = this.listOfKeyStores.iterator();
        }
        return this.iterator;
    }

    public boolean hasNext() {
        return this.getIterator().hasNext();
    }

    private void initializeDefaultKeyStores() {
        URL url;
        this.listOfKeyStores = new ArrayList(5);
        try {
            url = new URL("file", null, 0, String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts");
            this.listOfKeyStores.add(new KeystoreHandle(url, Security.getProperty(DEFAULT_KEYSTORE_TYPE)));
        }
        catch (MalformedURLException malformedURLException) {}
        try {
            url = new URL("file", null, 0, String.valueOf(System.getProperty("user.home")) + File.separator + ".keystore");
            this.listOfKeyStores.add(new KeystoreHandle(url, Security.getProperty(DEFAULT_KEYSTORE_TYPE)));
        }
        catch (MalformedURLException malformedURLException) {}
        int index = 1;
        String java_policy = Security.getProperty(JAVA_POLICY_URL + index);
        while (java_policy != null) {
            KeystoreHandle keystore = this.getKeystoreFromLocation(java_policy);
            if (keystore != null) {
                this.listOfKeyStores.add(keystore);
            }
            java_policy = Security.getProperty(JAVA_POLICY_URL + ++index);
        }
    }

    public KeystoreHandle next() {
        return (KeystoreHandle)this.getIterator().next();
    }

    /*
     * Exception decompiling
     */
    private KeystoreHandle getKeystoreFromLocation(String location) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 310->313)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private KeystoreHandle getKeystoreFromString(String content, URL rootURL) {
        KeystoreHandle handle = null;
        String keyStoreType = Security.getProperty(DEFAULT_KEYSTORE_TYPE);
        int indexOfSpace = content.indexOf(32);
        if (indexOfSpace == -1) {
            return null;
        }
        int secondSpace = content.lastIndexOf(44);
        if (secondSpace == -1) {
            secondSpace = content.length();
        } else {
            keyStoreType = content.substring(secondSpace + 1, content.length()).trim();
        }
        URL url = null;
        try {
            url = new URL(content.substring(indexOfSpace, secondSpace));
        }
        catch (MalformedURLException e) {
            this.log(e);
            try {
                url = new URL(rootURL, content.substring(indexOfSpace, secondSpace));
            }
            catch (MalformedURLException e1) {
                this.log(e1);
            }
        }
        if (url != null) {
            handle = new KeystoreHandle(url, keyStoreType);
        }
        return handle;
    }

    private void log(Exception e) {
        UpdateCore.warn("Cannot retrieve a KeyStore", e);
    }
}

