/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.ViewerActionBuilder;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class PopupMenuExtender
implements IMenuListener,
IRegistryChangeListener {
    private static final int STATIC_ACTION_READ = 1;
    private static final int INCLUDE_EDITOR_INPUT = 2;
    private final Set menuIds = new HashSet();
    private final MenuManager menu;
    private SubMenuManager menuWrapper;
    private final ISelectionProvider selProvider;
    private final IWorkbenchPart part;
    private ViewerActionBuilder staticActionBuilder;
    private int bitSet = 0;

    public PopupMenuExtender(String id, MenuManager menu, ISelectionProvider prov, IWorkbenchPart part) {
        this(id, menu, prov, part, true);
    }

    public PopupMenuExtender(String id, MenuManager menu, ISelectionProvider prov, IWorkbenchPart part, boolean includeEditorInput) {
        this.menu = menu;
        this.selProvider = prov;
        this.part = part;
        if (includeEditorInput) {
            this.bitSet |= 2;
        }
        this.menuIds.add(id);
        menu.addMenuListener((IMenuListener)this);
        if (!menu.getRemoveAllWhenShown()) {
            this.menuWrapper = new SubMenuManager((IMenuManager)menu);
            this.menuWrapper.setVisible(true);
        }
        this.readStaticActions();
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public Set getMenuIds() {
        return this.menuIds;
    }

    public final void addMenuId(String menuId) {
        this.menuIds.add(menuId);
    }

    public final boolean matches(MenuManager menuManager, ISelectionProvider selectionProvider, IWorkbenchPart part) {
        return this.menu == menuManager && this.selProvider == selectionProvider && this.part == part;
    }

    private void addEditorActions(IMenuManager mgr) {
        ISelectionProvider activeEditor = new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }

            public ISelection getSelection() {
                if (PopupMenuExtender.this.part instanceof IEditorPart) {
                    IEditorPart editorPart = (IEditorPart)PopupMenuExtender.this.part;
                    return new StructuredSelection(new Object[]{editorPart.getEditorInput()});
                }
                return new StructuredSelection(new Object[0]);
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }

            public void setSelection(ISelection selection) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }
        };
        if (ObjectActionContributorManager.getManager().contributeObjectActions(this.part, mgr, activeEditor)) {
            mgr.add((IContributionItem)new Separator());
        }
    }

    private void addObjectActions(IMenuManager mgr) {
        if (this.selProvider != null && ObjectActionContributorManager.getManager().contributeObjectActions(this.part, mgr, this.selProvider)) {
            mgr.add((IContributionItem)new Separator());
        }
    }

    private void addStaticActions(IMenuManager mgr) {
        if (this.staticActionBuilder != null) {
            this.staticActionBuilder.contribute(mgr, null, true);
        }
    }

    public void menuAboutToShow(IMenuManager mgr) {
        this.readStaticActions();
        this.testForAdditions();
        if (this.menuWrapper != null) {
            mgr = this.menuWrapper;
            this.menuWrapper.removeAll();
        }
        if ((this.bitSet & 2) != 0) {
            this.addEditorActions(mgr);
        }
        this.addObjectActions(mgr);
        this.addStaticActions(mgr);
    }

    private void readStaticActions() {
        if ((this.bitSet & 1) != 0) {
            return;
        }
        this.bitSet |= 1;
        if (this.menuIds.isEmpty()) {
            return;
        }
        Iterator menuIdItr = this.menuIds.iterator();
        while (menuIdItr.hasNext()) {
            String menuId = (String)menuIdItr.next();
            if (menuId == null || menuId.length() < 1) continue;
            this.staticActionBuilder = new ViewerActionBuilder();
            if (this.staticActionBuilder.readViewerContributions(menuId, this.selProvider, this.part)) continue;
            this.staticActionBuilder = null;
        }
    }

    private void testForAdditions() {
        IContributionItem item = this.menu.find("additions");
        if (item == null) {
            WorkbenchPlugin.log("Context menu missing standard group 'org.eclipse.ui.IWorkbenchActionConstants.MB_ADDITIONS'. (menu ids = " + this.menuIds.toString() + ")  part id = " + (this.part == null ? "???" : this.part.getSite().getId()) + ")");
        }
    }

    public void dispose() {
        if (this.staticActionBuilder != null) {
            this.staticActionBuilder.dispose();
        }
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
        this.menu.removeMenuListener((IMenuListener)this);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        Display display = Display.getDefault();
        if (this.part != null) {
            display = this.part.getSite().getPage().getWorkbenchWindow().getWorkbench().getDisplay();
        }
        IExtensionDelta[] deltas = event.getExtensionDeltas();
        int i = 0;
        while (i < deltas.length) {
            IExtensionDelta delta = deltas[i];
            IExtensionPoint extensionPoint = delta.getExtensionPoint();
            if (extensionPoint.getNamespace().equals(WorkbenchPlugin.PI_WORKBENCH) && extensionPoint.getSimpleIdentifier().equals("popupMenus")) {
                boolean clearPopups = false;
                IConfigurationElement[] elements = delta.getExtension().getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals("viewerContribution")) {
                        clearPopups = true;
                        break;
                    }
                    ++j;
                }
                if (clearPopups) {
                    display.syncExec(new Runnable(){

                        public void run() {
                            PopupMenuExtender popupMenuExtender = PopupMenuExtender.this;
                            popupMenuExtender.bitSet = popupMenuExtender.bitSet & 0xFFFFFFFE;
                            if (PopupMenuExtender.this.staticActionBuilder != null) {
                                PopupMenuExtender.this.staticActionBuilder.dispose();
                                PopupMenuExtender.this.staticActionBuilder = null;
                            }
                        }
                    });
                }
            }
            ++i;
        }
    }
}

