/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.flvtools.explorer;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.FilePlayer;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.flvtools.basic.FLVUtil;
import jp.sourceforge.akjrcp.flvtools.basic.OpenDirectable;
import jp.sourceforge.akjrcp.flvtools.basic.SimpleView;
import jp.sourceforge.akjrcp.flvtools.explorer.FlowPlayerShell;
import jp.sourceforge.akjrcp.flvtools.explorer.ThumbnailManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class ExplorerView
extends ViewPart
implements OpenDirectable {
    public static Log log;
    public static final String ID;
    private String currentDir;
    private String[] assistantNames;
    private Text directoryPath;
    protected static Image noImage;
    protected static Image loadingImage;
    protected static Image moveUpImage;
    protected static Image folderImage;
    private File currentFile = null;
    private boolean firstPaint = true;
    Menu canvasPopup;
    private String[] folders;
    ArrayList actionValueList = new ArrayList();
    private FigureCanvas canvas;
    private Figure rootFigure;
    private FlowPlayerShell flowPlayerShell;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.flvtools.explorer.ExplorerView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("jp.sourceforge.akjrcp.flvtools.explorer.ExplorerView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID = clazz2.getName();
        Display display = Display.getCurrent();
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("jp.sourceforge.akjrcp.ui.DirectoryList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        noImage = new Image((Device)display, clazz3.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/flvtools/resource/noimage.png"));
        Display display2 = Display.getCurrent();
        Class<?> clazz4 = class$1;
        if (clazz4 == null) {
            try {
                clazz4 = class$1 = Class.forName("jp.sourceforge.akjrcp.ui.DirectoryList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        loadingImage = new Image((Device)display2, clazz4.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/flvtools/resource/loading.png"));
        Display display3 = Display.getCurrent();
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("jp.sourceforge.akjrcp.ui.DirectoryList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        moveUpImage = new Image((Device)display3, clazz5.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/flvtools/resource/moveup.png"));
        Display display4 = Display.getCurrent();
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("jp.sourceforge.akjrcp.ui.DirectoryList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        folderImage = new Image((Device)display4, clazz6.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/flvtools/resource/folder_large.png"));
    }

    public void initAssistantName(File file) {
        String[] list = file.list();
        FLVFilter filter = new FLVFilter();
        ArrayList<String> tmpNames = new ArrayList<String>();
        int i = 0;
        while (i < list.length) {
            File tmp = new File(file, list[i]);
            if (tmp.isDirectory()) {
                String[] flvList = tmp.list(filter);
                int j = 0;
                while (j < flvList.length) {
                    String flvKey = this.trimNumberName(flvList[j].substring(0, flvList[j].length() - ".flv".length()));
                    tmpNames.remove(flvKey);
                    tmpNames.add(flvKey);
                    ++j;
                }
            }
            ++i;
        }
        this.assistantNames = tmpNames.toArray(new String[0]);
    }

    private String trimNumberName(String name) {
        int x;
        String newName = name;
        if (name.endsWith(")") && (x = name.lastIndexOf("(")) != -1) {
            String digi = name.substring(x + 1, name.length() - 1);
            boolean isDigit = true;
            int i = 0;
            while (i < digi.length()) {
                if (!Character.isDigit(digi.charAt(i))) {
                    isDigit = false;
                    break;
                }
                ++i;
            }
            if (isDigit) {
                newName = name.substring(0, x);
            }
        }
        return newName;
    }

    public static File getEmptyFileName(File file) {
        String fileName;
        if (!file.exists()) {
            return file;
        }
        String head = fileName = file.getName();
        int e = fileName.lastIndexOf(".");
        String ext = "";
        if (e != -1) {
            ext = fileName.substring(e);
            head = fileName.substring(0, e);
        }
        int index = 1;
        File newFile = null;
        while (newFile == null || newFile.exists()) {
            String newName = String.valueOf(head) + "(" + index + ")" + ext;
            newFile = new File(file.getParentFile(), newName);
            ++index;
        }
        return newFile;
    }

    public String findBaseDir() {
        String baseDir = SimpleView.findBaseDir();
        return baseDir;
    }

    public void createPartControl(Composite root) {
        ThumbnailManager.clearThumbnails();
        root.setLayout((Layout)new GridLayout(1, false));
        Composite controler = new Composite(root, 0);
        controler.setLayoutData((Object)new GridData(768));
        controler.setLayout((Layout)new GridLayout(2, false));
        Button reloadButton = new Button(controler, 0);
        reloadButton.setText(Messages.getString("reload"));
        reloadButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.openDirectory(ExplorerView.this.currentDir);
                ExplorerView.this.canvas.forceFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.directoryPath = new Text(controler, 12);
        GridData datax = new GridData(768);
        this.directoryPath.setLayoutData((Object)datax);
        this.canvas = new FigureCanvas(root);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.rootFigure = new Figure();
        this.canvas.setContents((IFigure)this.rootFigure);
        this.rootFigure.setLayoutManager((LayoutManager)new StackLayout());
        this.canvas.addControlListener((ControlListener)new ResizeMonitor(this.rootFigure));
        this.canvasPopup = new Menu((Control)this.canvas);
        this.canvas.setMenu(this.canvasPopup);
        MenuItem player = new MenuItem(this.canvasPopup, 64);
        player.setText("Play");
        Menu playMenu = new Menu(player);
        player.setMenu(playMenu);
        MenuItem systemPlayItem = new MenuItem(playMenu, 8);
        systemPlayItem.setText("System-Player");
        systemPlayItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FilePlayer.play(ExplorerView.this.currentFile, "flv");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem flowPlayItem = new MenuItem(playMenu, 8);
        flowPlayItem.setText("FlowPlayer");
        flowPlayItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.playFlowPlayer(ExplorerView.this.currentFile);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem enableseek = new MenuItem(this.canvasPopup, 8);
        enableseek.setText(Messages.getString("enable_seek"));
        enableseek.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.callFLVTool2();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        root.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ExplorerView.this.firstPaint) {
                    ExplorerView.this.firstPaint = false;
                    ExplorerView.this.openDirectory(ExplorerView.this.findBaseDir());
                }
            }
        });
    }

    public void callFLVTool2() {
        File file;
        Runtime runtime = Runtime.getRuntime();
        String path = Akj_betasPlugin.getDefault().getPreferenceStore().getString("flvtool2_path");
        if (path.endsWith("flvtool2.exe") && (file = new File(path)).exists()) {
            String[] args = path.indexOf("akj_friends") != -1 ? new String[]{path, "-U", this.currentFile.getAbsolutePath()} : new String[]{path, "u", this.currentFile.getAbsolutePath()};
            try {
                WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IProgressMonitor convertMonitor = workbenchWindow.getStatusLineManager().getProgressMonitor();
                Process p = runtime.exec(args);
                try {
                    p.waitFor();
                    convertMonitor.done();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void playFile(File file) {
        log.info((Object)("playFile:" + file));
        boolean primaryFlowPlayer = Akj_betasPlugin.getDefault().getPreferenceStore().getBoolean("primary_flowplayer");
        if (primaryFlowPlayer) {
            this.playFlowPlayer(file);
        } else if (!FilePlayer.play(file)) {
            this.playFlowPlayer(file);
        }
    }

    public void playFlowPlayer(File file) {
        if (this.isFLVExtension(file)) {
            if (this.flowPlayerShell == null || this.flowPlayerShell.getShell().isDisposed()) {
                this.flowPlayerShell = new FlowPlayerShell(this.getSite().getShell());
            }
            this.flowPlayerShell.openFLVFile(file);
        }
    }

    public boolean isFLVExtension(File file) {
        return file.getName().toLowerCase().endsWith(".flv");
    }

    public void openDirectory(String path) {
        log.info((Object)("path:" + path));
        this.directoryPath.setText(path);
        this.currentDir = path;
        File file = new File(path);
        this.initAssistantName(file);
        this.initFolder(file);
        this.initList(file);
        this.updatePopupMenu(file);
        if (!this.isEveryFLVOK(file)) {
            MessageDialog dialog = new MessageDialog(this.getSite().getShell(), Messages.getString("confirm_rename"), null, Messages.getString("confirm_rename_message"), 2, new String[]{"OK", "Cancell"}, 1);
            int value = dialog.open();
            log.info((Object)("dialog:" + value));
            if (value == 0) {
                String[] flvs = this.getFLVFiles(file);
                int i = 0;
                while (i < flvs.length) {
                    if (!flvs[i].toLowerCase().endsWith(".flv")) {
                        File flv = new File(flvs[i]);
                        File newFile = new File(SimpleView.getChangedExtensionName(flv, "flv"));
                        boolean result = flv.renameTo(newFile);
                        log.info((Object)("result:" + result + " " + newFile));
                    }
                    ++i;
                }
                this.initList(file);
            }
        }
    }

    public void updatePopupMenu(File file) {
    }

    public boolean isEveryFLVOK(File file) {
        String[] files = this.getFLVFiles(file);
        int i = 0;
        while (i < files.length) {
            if (!files[i].toLowerCase().endsWith(".flv")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String[] getFLVFiles(File baseDir) {
        String[] list = baseDir.list();
        ArrayList<String> array = new ArrayList<String>();
        int i = 0;
        while (i < list.length) {
            File file2 = new File(baseDir, list[i]);
            if (FLVUtil.isFLV(file2)) {
                array.add(file2.getAbsolutePath());
            }
            ++i;
        }
        return array.toArray(new String[0]);
    }

    public String trimTitle(String name) {
        return name.substring(0, Math.min(16, name.length()));
    }

    public void initList(File file) {
        this.actionValueList.removeAll(this.actionValueList);
        this.rootFigure.removeAll();
        String[] flvfiles = this.getFLVFiles(file);
        Panel p2 = new Panel();
        p2.setBackgroundColor(ColorConstants.white);
        p2.add((IFigure)new MoveUpFigure("", moveUpImage));
        p2.setLayoutManager((LayoutManager)new CustomLayout(this.rootFigure));
        ImageLoader imageLoader = new ImageLoader();
        int i = 0;
        while (i < flvfiles.length) {
            File f = new File(flvfiles[i]);
            String name = this.trimExtension(f.getName());
            ThumbnailFigure th = new ThumbnailFigure(this.trimTitle(name), loadingImage);
            if (!f.getName().toLowerCase().endsWith(".flv")) {
                log.info((Object)"no extension");
                th.setHasExtension(false);
            }
            p2.add((IFigure)th);
            imageLoader.add(th, f);
            ++i;
        }
        String[] list = file.list();
        int i2 = 0;
        while (i2 < list.length) {
            if (new File(file, list[i2]).isDirectory()) {
                p2.add((IFigure)new FolderFigure(this.trimTitle(list[i2]), folderImage));
            }
            ++i2;
        }
        this.rootFigure.add((IFigure)p2);
        Thread t = new Thread(imageLoader);
        t.start();
    }

    private String trimExtension(String name) {
        int e = name.toLowerCase().lastIndexOf(".flv");
        if (e != -1) {
            return name.substring(0, e);
        }
        return name;
    }

    private void initFolder(File file) {
        String[] list = file.list();
        ArrayList<String> array = new ArrayList<String>();
        int i = 0;
        while (i < list.length) {
            if (new File(file, list[i]).isDirectory()) {
                array.add(list[i]);
            }
            ++i;
        }
        this.folders = array.toArray(new String[0]);
    }

    private CCombo makeComboBox(Composite panel) {
        CCombo box = new CCombo(panel, 8);
        box.add("");
        int i = 0;
        while (i < this.folders.length) {
            box.add(this.folders[i]);
            ++i;
        }
        return box;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ExplorerView.this.fillContextMenu(manager);
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillContextMenu(IMenuManager manager) {
    }

    private void fillLocalToolBar(IToolBarManager manager) {
    }

    public void openDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        String path = dialog.open();
        if (path != null) {
            this.openDirectory(path);
        }
    }

    public void setFocus() {
        this.canvas.forceFocus();
    }

    public class ImageLoader
    implements Runnable {
        ArrayList list = new ArrayList();

        public void run() {
            Object[] figure_file = this.list.toArray();
            int i = 0;
            while (i < figure_file.length) {
                Object[] th_file = (Object[])figure_file[i];
                ThumbnailFigure figure = (ThumbnailFigure)((Object)th_file[0]);
                Image img = ThumbnailManager.loadThumbnail((File)th_file[1], noImage);
                if (ExplorerView.this.getSite().getShell().getDisplay() != null) {
                    ExplorerView.this.getSite().getShell().getDisplay().asyncExec((Runnable)new SetImage(img, figure));
                } else {
                    log.warn((Object)"display null");
                }
                ++i;
            }
        }

        public void add(ThumbnailFigure figure, File file) {
            this.list.add(new Object[]{figure, file});
        }
    }

    public class SetImage
    implements Runnable {
        Image img;
        ThumbnailFigure figure;

        public SetImage(Image img, ThumbnailFigure figure) {
            this.img = img;
            this.figure = figure;
        }

        public void run() {
            this.figure.setImage(this.img);
        }
    }

    public class FLVFilter
    implements FilenameFilter {
        public boolean accept(File arg0, String arg1) {
            return arg1.toLowerCase().endsWith(".flv");
        }
    }

    public class MoveAction
    extends Thread {
        public void run() {
            ActionValues[] values = ExplorerView.this.actionValueList.toArray(new ActionValues[0]);
            int i = 0;
            while (i < values.length) {
                values[i].setEnabled(false);
                ++i;
            }
            i = 0;
            while (i < values.length) {
                this.execMove(values[i]);
                ++i;
            }
            ExplorerView.this.openDirectory(ExplorerView.this.currentDir);
        }

        private void execMove(ActionValues values) {
            File parent = values.getFile().getParentFile();
            String path = parent.getAbsolutePath();
            String dir = values.getNewDirectory();
            if (dir.length() > 0) {
                path = String.valueOf(path) + "\\" + dir;
            }
            path = String.valueOf(path) + "\\" + this.trim(values.getNewName());
            path = String.valueOf(path) + ".flv";
            if (!values.getFile().getAbsolutePath().equals(path)) {
                log.info((Object)("rename to:" + path));
                File renameFile = new File(path);
                File emptyName = ExplorerView.getEmptyFileName(renameFile);
                boolean result = values.getFile().renameTo(emptyName);
                if (!result) {
                    log.warn((Object)("rename faild:" + emptyName.getAbsolutePath()));
                }
            }
        }

        private String trim(String name) {
            if (name.toLowerCase().endsWith(".flv")) {
                name = name.substring(0, name.length() - 4);
            }
            return name;
        }
    }

    public class ExecExecuter
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new MoveAction());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class DoneProgressMonitor
    implements Runnable {
        IProgressMonitor monitor;

        public DoneProgressMonitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void run() {
            this.monitor.done();
        }
    }

    public class SetProgressMonitor
    implements Runnable {
        IProgressMonitor monitor;
        String text;
        int step;

        public SetProgressMonitor(IProgressMonitor monitor, String text, int step) {
            this.monitor = monitor;
            this.text = text;
            this.step = step;
        }

        public void run() {
            this.monitor.beginTask(this.text, this.step);
        }
    }

    public class MoveUpFigure
    extends Panel {
        Label titleLabel;
        Label imageLabel;

        public void setImage(Image img) {
            if (img != null) {
                this.imageLabel.setIcon(img);
            } else {
                log.info((Object)("setimage:" + this.getLabel()));
            }
        }

        public String getLabel() {
            return this.titleLabel.getText();
        }

        public void setLabel(String text) {
            this.titleLabel.setText(text);
        }

        public MoveUpFigure(String label, Image img) {
            this.setLayoutManager((LayoutManager)new FlowLayout(false));
            this.imageLabel = new Label(img);
            this.imageLabel.setToolTip((IFigure)new Label(label));
            this.add((IFigure)this.imageLabel);
            this.titleLabel = new Label(label);
            this.add((IFigure)this.titleLabel);
            this.imageLabel.setToolTip((IFigure)new Label(Messages.getString("moveup_directory")));
            this.addMouseListener(new MouseListener(){

                public void mousePressed(MouseEvent arg0) {
                }

                public void mouseReleased(MouseEvent arg0) {
                }

                public void mouseDoubleClicked(MouseEvent arg0) {
                    String path = new File(ExplorerView.this.currentDir).getParent();
                    log.info((Object)path);
                    ExplorerView.this.openDirectory(path);
                }
            });
        }
    }

    public class FolderFigure
    extends Panel {
        Label titleLabel;
        Label imageLabel;

        public void setImage(Image img) {
            if (img != null) {
                this.imageLabel.setIcon(img);
            } else {
                log.info((Object)("setimage:" + this.getLabel()));
            }
        }

        public String getLabel() {
            return this.titleLabel.getText();
        }

        public void setLabel(String text) {
            this.titleLabel.setText(text);
        }

        public FolderFigure(String label, Image img) {
            this.setLayoutManager((LayoutManager)new FlowLayout(false));
            this.imageLabel = new Label(img);
            this.imageLabel.setToolTip((IFigure)new Label(label));
            this.add((IFigure)this.imageLabel);
            this.titleLabel = new Label(label);
            this.add((IFigure)this.titleLabel);
            this.addMouseListener(new MouseListener(){

                public void mousePressed(MouseEvent arg0) {
                }

                public void mouseReleased(MouseEvent arg0) {
                }

                public void mouseDoubleClicked(MouseEvent arg0) {
                    File dir = new File(ExplorerView.this.currentDir, FolderFigure.this.titleLabel.getText());
                    ExplorerView.this.openDirectory(dir.getAbsolutePath());
                }
            });
        }
    }

    public class ThumbnailFigure
    extends Panel {
        Label titleLabel;
        Label imageLabel;
        boolean hasExtension = true;

        public void setImage(Image img) {
            if (img != null) {
                this.imageLabel.setIcon(img);
            } else {
                log.info((Object)("setimage:" + this.getLabel()));
            }
        }

        public String getLabel() {
            return this.titleLabel.getText();
        }

        public void setLabel(String text) {
            this.titleLabel.setText(text);
        }

        public ThumbnailFigure(String label, Image img) {
            this.setLayoutManager((LayoutManager)new FlowLayout(false));
            this.imageLabel = new Label(img);
            this.imageLabel.setToolTip((IFigure)new Label(label));
            this.add((IFigure)this.imageLabel);
            this.titleLabel = new Label(label);
            this.add((IFigure)this.titleLabel);
            this.addMouseListener(new MouseListener(){

                public File toFile() {
                    if (ThumbnailFigure.this.isHasExtension()) {
                        return new File(ExplorerView.this.currentDir, String.valueOf(ThumbnailFigure.this.titleLabel.getText()) + ".flv");
                    }
                    return new File(ExplorerView.this.currentDir, ThumbnailFigure.this.titleLabel.getText());
                }

                public void mousePressed(MouseEvent arg0) {
                    ExplorerView.this.currentFile = this.toFile();
                    log.info((Object)("currentFile:" + ExplorerView.this.currentFile));
                }

                public void mouseReleased(MouseEvent arg0) {
                }

                public void mouseDoubleClicked(MouseEvent arg0) {
                    ExplorerView.this.playFile(this.toFile());
                }
            });
        }

        public boolean isHasExtension() {
            return this.hasExtension;
        }

        public void setHasExtension(boolean hasExtension) {
            this.hasExtension = hasExtension;
        }
    }

    public class CustomLayout
    implements LayoutManager {
        Figure control;

        public CustomLayout(Figure control) {
            this.control = control;
        }

        public Object getConstraint(IFigure child) {
            return null;
        }

        public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
            return this.getPreferredSize(container, wHint, hHint);
        }

        public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
            this.layout(container);
            Figure[] figures = container.getChildren().toArray(new Figure[0]);
            int my = 0;
            int i = 0;
            while (i < figures.length) {
                my = Math.max(my, figures[i].getLocation().y + figures[i].getSize().height);
                ++i;
            }
            return new Dimension(this.control.getClientArea().x, my);
        }

        public void invalidate() {
        }

        public void layout(IFigure container) {
            Figure[] figures = container.getChildren().toArray(new Figure[0]);
            int space = 1;
            int dx = 0;
            int dy = 0;
            int preHeight = 0;
            if (this.control.getSize().width == 0 && this.control.getSize().height == 0) {
                return;
            }
            int i = 0;
            while (i < figures.length) {
                Dimension d = figures[i].getPreferredSize();
                if (dx == 0) {
                    figures[i].setLocation(new Point(dx, dy));
                    figures[i].setSize(d.width, d.height);
                    dx += d.width + space;
                    preHeight = d.height + space;
                } else {
                    int sc = 0;
                    if (!ExplorerView.this.canvas.getVerticalBar().isEnabled()) {
                        sc = 16;
                    }
                    if (dx + d.width > this.control.getClientArea().width - sc) {
                        dx = 0;
                        dy += preHeight;
                    }
                    figures[i].setLocation(new Point(dx, dy));
                    figures[i].setSize(d.width, d.height);
                    dx += d.width + space;
                    preHeight = d.height + space;
                }
                ++i;
            }
            int my = 0;
            int i2 = 0;
            while (i2 < figures.length) {
                my = Math.max(my, figures[i2].getLocation().y + figures[i2].getSize().height);
                ++i2;
            }
        }

        public void remove(IFigure child) {
        }

        public void setConstraint(IFigure child, Object constraint) {
        }
    }

    public class ResizeMonitor
    implements ControlListener {
        Figure figure;

        public ResizeMonitor(Figure figure) {
            this.figure = figure;
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            this.figure.revalidate();
        }
    }

    public class ActionValues
    implements org.eclipse.swt.events.MouseListener {
        private File file;
        private CCombo combo;
        private CCombo text;

        public File getFile() {
            return this.file;
        }

        public String getNewName() {
            return this.text.getText();
        }

        public String getNewDirectory() {
            return this.combo.getText();
        }

        public void setEnabled(boolean bool) {
            this.combo.setEnabled(bool);
            this.text.setEnabled(bool);
        }

        public ActionValues(File file, CCombo combo, CCombo text) {
            this.file = file;
            this.combo = combo;
            this.text = text;
        }

        public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
            log.warn((Object)"mouse");
        }

        public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
        }

        public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
        }
    }
}

