/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.flvtools.explorer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.flvtools.explorer.ExplorerView;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FlowPlayerShell {
    private Browser browser;
    private Shell shell;
    File tmpFile;

    public FlowPlayerShell(Shell parent) {
        this.shell = new Shell(parent);
        this.shell.setLayout((Layout)new FillLayout());
        this.browser = new Browser((Composite)this.shell, 0);
        this.shell.setSize(364, 326);
        this.shell.open();
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FlowPlayerShell.this.removeTmpFile();
            }
        });
    }

    public void removeTmpFile() {
        if (this.tmpFile != null) {
            boolean result = this.tmpFile.delete();
            ExplorerView.log.debug((Object)("delete:" + result));
        }
    }

    public Shell getShell() {
        return this.shell;
    }

    public void openFLVFile(File file) {
        try {
            File tmp = File.createTempFile("flowplayer", ".html");
            FileWriter writer = new FileWriter(tmp);
            FlowPlayer player = new FlowPlayer(file);
            writer.write(player.toHTML());
            writer.close();
            this.browser.setUrl("file://" + tmp.getAbsolutePath());
            this.removeTmpFile();
            this.tmpFile = tmp;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class FlowPlayer {
        private int width = 360;
        private int height = 240;
        private String headerHtml = "<html><body style='marign=0;padding=0'>";
        private String footerHtml = "</body></html>";
        private File file;

        public FlowPlayer(File file) {
            this.file = file;
        }

        public String toHTML() {
            StringBuffer str = new StringBuffer();
            String swfPath = String.valueOf(Akj_betasPlugin.getDefault().flowPlayerDir.getAbsolutePath()) + "\\" + "FlowPlayer.swf";
            String dir = this.file.getParent();
            String video = this.file.getName();
            str.append(this.headerHtml);
            str.append("<object type=\"application/x-shockwave-flash\" data=\"FlowPlayer.swf\" width=\"320\" height=\"263\" id=\"FlowPlayer\">");
            str.append("<param name=\"allowScriptAccess\" value=\"sameDomain\" />");
            str.append("<param name=\"movie\" value=\"" + swfPath + "\" />");
            str.append("<param name=\"quality\" value=\"high\" />");
            str.append("<param name=\"scale\" value=\"noScale\" />");
            str.append("<param name=\"wmode\" value=\"transparent\" />");
            str.append("<param name=\"flashvars\" value=\"baseURL=" + dir + "&amp;videoFile=" + video + "&amp;autoPlay=true&amp;bufferLength=5&amp;loop=false&amp;progressBarColor1=0xAAAAAA&amp;progressBarColor2=0x555555&amp;autoBuffering=false&amp;splashImageFile=main_clickToPlay.jpg&amp;hideControls=false\" />");
            str.append("</object>");
            str.append(this.footerHtml);
            return str.toString();
        }
    }
}

