/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.flvtools.explorer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.flvtools.basic.ProcessMonitor;
import jp.sourceforge.akjrcp.util.MD5Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ThumbnailManager {
    public static Log log;
    public static File baseDirectory;
    public static long expiretime;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.akjrcp.flvtools.explorer.ExplorerView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        baseDirectory = new File(String.valueOf(System.getProperty("user.dir")) + "\\" + "thumbs");
        expiretime = 7776000000L;
    }

    public static Image loadThumbnail(File file) {
        return ThumbnailManager.loadThumbnail(file, null);
    }

    public static Image loadThumbnail(File file, Image noimg) {
        File thumbFile;
        log.info((Object)("base file:" + file.getAbsolutePath()));
        if (!ThumbnailManager.isExistThumbnail(file)) {
            ThumbnailManager.makeThumbnail(file);
        }
        if (!(thumbFile = ThumbnailManager.toThumbnailPath(file)).exists()) {
            return noimg;
        }
        return new Image((Device)Display.getCurrent(), thumbFile.getAbsolutePath());
    }

    public static void clearThumbnails() {
        String[] list = ThumbnailManager.getThumbs();
        if (list == null) {
            log.warn((Object)("file not found " + baseDirectory));
        }
        log.info((Object)("expire:" + expiretime));
        int i = 0;
        while (i < list.length) {
            File file = new File(list[i]);
            if (file.lastModified() + expiretime < System.currentTimeMillis()) {
                log.info((Object)("delete:" + file.getAbsolutePath() + new Date(file.lastModified() + expiretime) + " last=" + new Date(System.currentTimeMillis())));
                file.delete();
            }
            ++i;
        }
    }

    public static void clearThumbnails(String[] keepFiles) {
        ArrayList<String> array = new ArrayList<String>();
        String[] list = ThumbnailManager.getThumbs();
        if (list == null) {
            log.warn((Object)("file not found " + baseDirectory));
        }
        int i = 0;
        while (i < list.length) {
            array.add(list[i]);
            ++i;
        }
        i = 0;
        while (i < keepFiles.length) {
            String thumb = ThumbnailManager.toThumbnailPath(new File(keepFiles[i])).getAbsolutePath();
            array.remove(thumb);
            ++i;
        }
        log.info((Object)("array-length:" + array.size()));
        String[] deleteFiles = array.toArray(new String[0]);
        int i2 = 0;
        while (i2 < deleteFiles.length) {
            boolean b = new File(deleteFiles[i2]).delete();
            if (b) {
                log.info((Object)("delete file:" + deleteFiles[i2]));
            } else {
                log.warn((Object)("delete faild:" + deleteFiles[i2]));
            }
            ++i2;
        }
    }

    public static String[] getThumbs() {
        ArrayList<String> array = new ArrayList<String>();
        if (baseDirectory.exists()) {
            String[] list = baseDirectory.list();
            int i = 0;
            while (i < list.length) {
                File tmp = new File(baseDirectory, list[i]);
                if (tmp.isFile() && tmp.getName().endsWith(".jpg")) {
                    array.add(tmp.getAbsolutePath());
                }
                ++i;
            }
        }
        return array.toArray(new String[0]);
    }

    public static void debugArray(String[] array) {
        String v = "";
        int i = 0;
        while (i < array.length) {
            v = String.valueOf(v) + "\"" + array[i] + "\"" + " ";
            ++i;
        }
        Akj_betasPlugin.getDefault().addLog(String.valueOf(v) + "\n");
    }

    public static void makeThumbnail(File file) {
        ProcessMonitor monitor = null;
        Runtime runtime = Runtime.getRuntime();
        ArrayList<String> param = new ArrayList<String>();
        IPreferenceStore store = Akj_betasPlugin.getDefault().getPreferenceStore();
        String ffmpegPath = store.getString("ffmpeg_path");
        File ffmpegFile = new File(ffmpegPath);
        if (!ffmpegFile.exists()) {
            log.warn((Object)"ffmpeg not found");
            return;
        }
        param.add(ffmpegPath);
        param.add("-i");
        param.add(file.getAbsolutePath());
        param.add("-f");
        param.add("image2");
        param.add("-ss");
        param.add("00:00:05");
        param.add("-vframes");
        param.add("1");
        param.add("-s");
        param.add("160x120");
        param.add(ThumbnailManager.toThumbnailPath(file).getAbsolutePath());
        try {
            String[] arg = param.toArray(new String[0]);
            ThumbnailManager.debugArray(arg);
            Process p = runtime.exec(arg);
            monitor = new ProcessMonitor(p);
            monitor.startMonitor();
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isExistThumbnail(File file) {
        return ThumbnailManager.toThumbnailPath(file).exists();
    }

    public static File toThumbnailPath(File file) {
        return new File(baseDirectory, String.valueOf(file.length()) + "_" + file.lastModified() + "_" + MD5Util.getMD5(file, 256) + ".jpg");
    }
}

